/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeRemoveField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@JTranscInvisible
@HaxeAddMembers(value={"public var _length:Int;", "public var _data:haxe.io.Bytes;", "public var shortData:haxe.io.UInt16Array;", "public var intData:haxe.io.Int32Array;", "public var floatData:haxe.io.Float32Array;", "public var doubleData:haxe.io.Float64Array;"})
public final class FastMemory {
    @HaxeRemoveField
    private int length;
    @HaxeRemoveField
    private ByteBuffer data;

    @HaxeMethodBody(value="this._length = p0;\nthis._data = haxe.io.Bytes.alloc((p0 + 7) & ~7);\nthis.shortData = haxe.io.UInt16Array.fromBytes(this._data);\nthis.intData = haxe.io.Int32Array.fromBytes(this._data);\nthis.floatData = haxe.io.Float32Array.fromBytes(this._data);\nthis.doubleData = haxe.io.Float64Array.fromBytes(this._data);\n")
    public FastMemory(int size) {
        this.length = size;
        this.data = ByteBuffer.allocateDirect(size + 7 & 0xFFFFFFF8).order(ByteOrder.nativeOrder());
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._length;")
    public final int getLength() {
        return this.length;
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.length;")
    public final int getAllocatedLength() {
        return this.data.limit();
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.get(p0);")
    public final int getInt8(int index) {
        return this.data.get(index) & 0xFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return (this._data.getUInt16(p0) << 16) >> 16;")
    public final int getInt16(int index) {
        return this.data.getShort(index) & 0xFFFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getInt32(p0);")
    public final int getInt32(int index) {
        return this.data.getInt(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getInt64(p0);")
    public final long getInt64(int index) {
        return this.data.getLong(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getFloat(p0);")
    public final float getFloat32(int index) {
        return this.data.getFloat(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getDouble(p0);")
    public final double getFloat64(int index) {
        return this.data.getDouble(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.set(p0, p1);")
    public final void setInt8(int index, int value) {
        this.data.put(index, (byte)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setUInt16(p0, p1);")
    public final void setInt16(int index, int value) {
        this.data.putShort(index, (short)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setInt32(p0, p1);")
    public final void setInt32(int index, int value) {
        this.data.putInt(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setInt64(p0, p1);")
    public final void setInt64(int index, long value) {
        this.data.putLong(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setFloat(p0, p1);")
    public final void setFloat32(int index, float value) {
        this.data.putFloat(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setDouble(p0, p1);")
    public final void setFloat64(int index, double value) {
        this.data.putDouble(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.get(p0);")
    public final int getAlignedInt8(int index) {
        return this.data.get(index << 0) & 0xFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return (this.shortData.get(p0) << 16) >> 16;")
    public final int getAlignedInt16(int index2) {
        return this.data.getShort(index2 << 1) & 0xFFFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return this.intData.get(p0);")
    public final int getAlignedInt32(int index4) {
        return this.data.getInt(index4 << 2);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getInt64(p0 << 3);")
    public final long getAlignedInt64(int index8) {
        return this.data.getLong(index8 << 3);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this.floatData.get(p0);")
    public final float getAlignedFloat32(int index4) {
        return this.data.getFloat(index4 << 2);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this.doubleData.get(p0);")
    public final double getAlignedFloat64(int index8) {
        return this.data.getDouble(index8 << 3);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.set(p0, p1);")
    public final void setAlignedInt8(int index, int value) {
        this.data.put(index << 0, (byte)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.shortData.set(p0, p1);")
    public final void setAlignedInt16(int index2, int value) {
        this.data.putShort(index2 << 1, (short)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.intData.set(p0, p1);")
    public final void setAlignedInt32(int index4, int value) {
        this.data.putInt(index4 << 2, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setInt64(p0 << 3, p1);")
    public final void setAlignedInt64(int index8, long value) {
        this.data.putLong(index8 << 3, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.floatData.set(p0, p1);")
    public final void setAlignedFloat32(int index4, float value) {
        this.data.putFloat(index4 << 2, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.doubleData.set(p0, p1);")
    public final void setAlignedFloat64(int index8, double value) {
        this.data.putDouble(index8 << 3, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.get(p0);")
    public final int getInt8_REV(int index) {
        return this.data.get(index) & 0xFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return HaxeNatives.swap16((this._data.getUInt16(p0) << 16) >> 16);")
    public final int getInt16_REV(int index) {
        return Short.reverseBytes(this.data.getShort(index)) & 0xFFFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return HaxeNatives.swap32(this._data.getInt32(p0));")
    public final int getInt32_REV(int index) {
        return Integer.reverseBytes(this.data.getInt(index));
    }

    @JTranscInline
    @HaxeMethodBody(value="return HaxeNatives.intBitsToFloat(HaxeNatives.swap32(this._data.getInt32(p0)));")
    public final float getFloat32_REV(int index) {
        return Float.intBitsToFloat(Integer.reverseBytes(this.data.getInt(index)));
    }

    public static void copy(byte[] from, int fromOffset, byte[] to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to[toOffset + n] = from[fromOffset + n];
        }
    }

    public static void copy(FastMemory from, int fromOffset, byte[] to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to[toOffset + n] = (byte)from.getInt8(fromOffset + n);
        }
    }

    public static void copy(byte[] from, int fromOffset, FastMemory to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to.setInt8(toOffset + n, from[fromOffset + n]);
        }
    }

    public static void copy(FastMemory from, int fromOffset, FastMemory to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to.setInt8(toOffset + n, from.getInt8(fromOffset + n));
        }
    }
}

