/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;

public class JTranscSystem {
    static double start = -1.0;

    @HaxeMethodBody(value="return N.getTime();")
    public static double fastTime() {
        return System.currentTimeMillis();
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="Sys.sleep(p0 / 1000.0);"), @HaxeMethodBody(value="var start = N.getTime(); while (N.getTime() - start < p0) { }")})
    public static void sleep(double ms) {
        try {
            Thread.sleep((long)ms);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int stamp() {
        if (start < 0.0) {
            start = JTranscSystem.fastTime();
        }
        return (int)(JTranscSystem.fastTime() - start);
    }

    public static int elapsedTime(int first, int second) {
        return second - first;
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cpp", value="cpp.vm.Gc.enable(false);"), @HaxeMethodBody(value="")})
    public static void gcDisable() {
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cpp", value="cpp.vm.Gc.enable(true);"), @HaxeMethodBody(value="")})
    public static void gcEnable() {
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cpp", value="cpp.vm.Gc.compact();"), @HaxeMethodBody(value="")})
    public static void gc() {
        System.gc();
    }

    @HaxeMethodBody(value="return true;")
    public static boolean usingJTransc() {
        return false;
    }

    @JTranscInline
    @HaxeMethodBody(value="HaxeNatives.debugger();")
    public static void debugger() {
        System.out.println("debugger");
        throw new Error("Debugger");
    }

    @JTranscInline
    @HaxeMethodBody(value="if (!p0) HaxeNatives.debugger();")
    public static void assert2(boolean trueCond) {
        if (!trueCond) {
            System.out.println("debugger");
            throw new Error("Debugger");
        }
    }

    public static String getRuntimeKind() {
        if (!JTranscSystem.usingJTransc()) {
            return "java";
        }
        if (JTranscSystem.isJs()) {
            return "js";
        }
        if (JTranscSystem.isSwf()) {
            return "swf";
        }
        if (JTranscSystem.isJava()) {
            return "java";
        }
        if (JTranscSystem.isCsharp()) {
            return "csharp";
        }
        if (JTranscSystem.isCpp()) {
            return "cpp";
        }
        if (JTranscSystem.isNeko()) {
            return "neko";
        }
        if (JTranscSystem.isPhp()) {
            return "php";
        }
        if (JTranscSystem.isPython()) {
            return "python";
        }
        return "unknown";
    }

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isSys();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cpp", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isCpp();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cs", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isCsharp();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="java", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isJava();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="js", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isJs();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="flash", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isSwf();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="neko", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isNeko();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="php", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isPhp();

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="python", value="return true;"), @HaxeMethodBody(value="return false;")})
    public static native boolean isPython();

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return HaxeNatives.str(Sys.systemName());"), @HaxeMethodBody(target="js", value="return HaxeNatives.str(untyped __js__(\"(typeof navigator != 'undefined' ? navigator.platform : process.platform)\"));"), @HaxeMethodBody(value="return HaxeNatives.str('unknown');")})
    private static String getOSRaw() {
        return System.getProperty("os.name");
    }

    public static String getOS() {
        String os = JTranscSystem.getOSRaw().toLowerCase();
        if (os.startsWith("win")) {
            return "windows";
        }
        if (os.startsWith("lin")) {
            return "linux";
        }
        if (os.startsWith("mac") || os.startsWith("osx")) {
            return "mac";
        }
        return os;
    }

    @HaxeMethodBody(value="return HaxeNatives.str('x86');")
    public static String getArch() {
        return System.getProperty("os.arch");
    }

    public static boolean isWindows() {
        return JTranscSystem.getOS().toLowerCase().startsWith("win");
    }

    public static boolean isLinux() {
        return JTranscSystem.getOS().toLowerCase().startsWith("linux");
    }

    public static boolean isMac() {
        return JTranscSystem.getOS().toLowerCase().startsWith("mac");
    }

    public static String fileSeparator() {
        return JTranscSystem.isWindows() ? "\\" : "/";
    }

    public static String pathSeparator() {
        return JTranscSystem.isWindows() ? ";" : ":";
    }

    public static String lineSeparator() {
        return JTranscSystem.isWindows() ? "\r\n" : "\n";
    }
}

