/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JTranscIoTools {
    public static byte[] readStreamFully(InputStream ios) {
        int length = 0;
        try {
            int readed;
            length = ios.available();
            byte[] out = new byte[length];
            for (int offset = 0; offset < length; offset += readed) {
                readed = ios.read(out, offset, length - offset);
                if (readed >= 0) continue;
                throw new IOException("Can't read file");
            }
            ios.close();
            return out;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = JTranscIoTools.readStreamFully(fileInputStream);
            return byArray;
        }
    }
}

