/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import com.jtransc.JTranscSystem;
import com.jtransc.JTranscWrapped;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBodyPre;
import com.jtransc.io.JTranscHaxeInputStream;
import com.jtransc.io.JTranscHaxeOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

@HaxeAddMembers(value={"#if sys public var process: sys.io.Process; #end"})
public class JTranscProcess
extends Process {
    private JTranscWrapped processWrapped;
    private InputStream stdout;
    private InputStream stderr;
    private OutputStream stdin;
    private String stdoutString;
    private String stderrString;
    private int exitCode;
    private int pid;

    @HaxeMethodBodyPre(value="var cmd = HaxeNatives.toNativeString(p0);\nvar args = HaxeNatives.toNativeStrArray(p1);\nvar cwd = HaxeNatives.toNativeString(p2);\nvar env = HaxeNatives.mapToObject(p3);\n")
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return HaxeNatives.wrap(new sys.io.Process(cmd, args));"), @HaxeMethodBody(target="js", value="return HaxeNatives.wrap(untyped __js__(\"require('child_process')\").spawnSync(cmd, args, {cwd:cwd, env:env}));"), @HaxeMethodBody(value="return null;")})
    private native JTranscWrapped create(String var1, String[] var2, String var3, Map<String, String> var4);

    public Process start(String[] cmdarray, Map<String, String> environment, String dir, ProcessBuilder.Redirect[] redirects, boolean redirectErrorStream) {
        this.processWrapped = this.create(cmdarray[0], Arrays.copyOfRange(cmdarray, 1, cmdarray.length), dir, environment);
        if (JTranscSystem.isJs()) {
            this.stdoutString = Objects.toString(this.processWrapped.get("stdout"));
            this.stderrString = Objects.toString(this.processWrapped.get("stderr"));
            this.stdout = new ByteArrayInputStream(this.stdoutString.getBytes(Charset.forName("utf-8")));
            this.stderr = new ByteArrayInputStream(this.stderrString.getBytes(Charset.forName("utf-8")));
            this.stderr = null;
            this.exitCode = (Integer)this.processWrapped.get("status");
            this.pid = (Integer)this.processWrapped.get("pid");
        } else {
            this.stdin = new JTranscHaxeOutputStream((JTranscWrapped)this.processWrapped.get("stdin"));
            this.stdout = new JTranscHaxeInputStream((JTranscWrapped)this.processWrapped.get("stdout"));
            this.stderr = new JTranscHaxeInputStream((JTranscWrapped)this.processWrapped.get("stderr"));
        }
        return this;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.exitValue();
    }

    @Override
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return this.process.exitCode();"), @HaxeMethodBody(value="return this.{% FIELD com.jtransc.io.JTranscProcess:exitCode %};")})
    public native int exitValue();

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return this.process.getPid();"), @HaxeMethodBody(value="return this.{% FIELD com.jtransc.io.JTranscProcess:pid %};")})
    public native int pid();

    @Override
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="this.process.kill();"), @HaxeMethodBody(value="")})
    public native void destroy();
}

