/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import java.io.FileNotFoundException;
import java.io.IOException;

public class JTranscSyncIO {
    public static final int O_RDONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_SYNC = 4;
    public static final int O_DSYNC = 8;
    public static final int ACCESS_EXECUTE = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_READ = 4;
    public static Impl impl = new Impl(null){

        @Override
        public ImplStream open(String path, int mode) throws FileNotFoundException {
            JTranscIOSyncFile file = new JTranscIOSyncFile();
            try {
                file.open(path, mode);
                return file;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new FileNotFoundException(path);
            }
        }

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.getLength(p0._str);")
        public native long getLength(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.delete(p0._str);")
        public native boolean delete(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.getBooleanAttributes(p0._str);")
        public native int getBooleanAttributes(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.checkAccess(p0._str, p1);")
        public native boolean checkAccess(String var1, int var2);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.createDirectory(p0._str);")
        public native boolean createDirectory(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.rename(p0._str, p1._str);")
        public native boolean rename(String var1, String var2);

        @Override
        @HaxeMethodBody(value="return HaxeNatives.strArray(HaxeIO.SyncFS.list(p0._str));")
        public native String[] list(String var1);

        @Override
        @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return HaxeNatives.str(Sys.getCwd());"), @HaxeMethodBody(target="js", value="return HaxeNatives.str(untyped __js__('HaxeNatives.isNode() ? process.cwd() : \"/assets\"'));"), @HaxeMethodBody(value="return HaxeNatives.str('');")})
        public native String getCwd();

        @Override
        @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return Sys.setCwd(p0._str);"), @HaxeMethodBody(target="js", value="untyped __js__('process.chdir({0})', p0._str);"), @HaxeMethodBody(value="")})
        public native void setCwd(String var1);
    };

    public static JTranscIOSyncFile open(String name, int mode) throws FileNotFoundException {
        JTranscIOSyncFile out = new JTranscIOSyncFile();
        out.open(name, mode);
        return out;
    }

    public static abstract class ImplStream {
        private byte[] temp = new byte[1];

        public abstract void setPosition(long var1);

        public abstract long getPosition();

        public abstract void setLength(long var1);

        public abstract long getLength();

        public int read() {
            return this.read(this.temp, 0, 1) == 1 ? this.temp[0] : -1;
        }

        public void write(int b) {
            this.temp[0] = (byte)b;
            this.write(this.temp, 0, 1);
        }

        public abstract int read(byte[] var1, int var2, int var3);

        public abstract int write(byte[] var1, int var2, int var3);

        public abstract void close() throws IOException;
    }

    public static abstract class Impl {
        protected Impl parent;

        public Impl(Impl parent) {
            this.parent = parent;
        }

        public abstract ImplStream open(String var1, int var2) throws FileNotFoundException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLength(String path) {
            long l;
            ImplStream stream = this.open(path, 1);
            try {
                l = stream.getLength();
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    return 0L;
                }
            }
            stream.close();
            return l;
        }

        public long getTotalSpace(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getTotalSpace");
            }
            return this.parent.getTotalSpace(file);
        }

        public long getFreeSpace(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getFreeSpace");
            }
            return this.parent.getFreeSpace(file);
        }

        public long getUsableSpace(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getUsableSpace");
            }
            return this.parent.getUsableSpace(file);
        }

        public boolean setReadOnly(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setReadOnly");
            }
            return this.parent.setReadOnly(file);
        }

        public boolean setLastModifiedTime(String file, long time) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setLastModifiedTime");
            }
            return this.parent.setLastModifiedTime(file, time);
        }

        public boolean rename(String fileOld, String fileNew) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.rename");
            }
            return this.parent.rename(fileOld, fileNew);
        }

        public boolean createDirectory(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.createDirectory");
            }
            return this.parent.createDirectory(file);
        }

        public String[] list(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.list");
            }
            return this.parent.list(file);
        }

        public boolean delete(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.delete");
            }
            return this.parent.delete(file);
        }

        public boolean createFileExclusively(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.createFileExclusively");
            }
            return this.parent.createFileExclusively(file);
        }

        public boolean setPermission(String file, int access, boolean enable, boolean owneronly) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setPermission");
            }
            return this.parent.setPermission(file, access, enable, owneronly);
        }

        public long getLastModifiedTime(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getLastModifiedTime");
            }
            return this.parent.getLastModifiedTime(file);
        }

        public boolean checkAccess(String file, int access) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.checkAccess");
            }
            return this.parent.checkAccess(file, access);
        }

        public int getBooleanAttributes(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getBooleanAttributes");
            }
            return this.parent.getBooleanAttributes(file);
        }

        public String getCwd() {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getCwd");
            }
            return this.parent.getCwd();
        }

        public void setCwd(String path) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setCwd");
            }
            this.parent.setCwd(path);
        }
    }

    public static class ByteStream
    extends ImplStream {
        private int position;
        private byte[] data;

        public ByteStream(byte[] data) {
            this.data = data;
            this.position = 0;
        }

        @Override
        public void setPosition(long offset) {
            this.position = (int)offset;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public void setLength(long length) {
            throw new RuntimeException("Not implemented ByteStream.setLength");
        }

        @Override
        public long getLength() {
            return this.data.length;
        }

        @Override
        public int read(byte[] data, int offset, int size) {
            int available = (int)(this.getLength() - this.getPosition());
            if (available <= 0) {
                return -1;
            }
            int toRead = Math.min(available, size);
            for (int n = 0; n < toRead; ++n) {
                data[offset + n] = this.data[this.position + n];
            }
            this.position += toRead;
            return toRead;
        }

        @Override
        public int write(byte[] data, int offset, int size) {
            throw new RuntimeException("Not implemented ByteStream.write");
        }

        @Override
        public void close() {
        }
    }

    @HaxeAddMembers(value={"private var _stream = new HaxeIO.SyncStream();"})
    private static class JTranscIOSyncFile
    extends ImplStream {
        private JTranscIOSyncFile() {
        }

        @HaxeMethodBody(value="_stream.syncioOpen(p0._str, p1);")
        native void open(String var1, int var2) throws FileNotFoundException;

        @Override
        @HaxeMethodBody(value="_stream.syncioClose();")
        public native void close() throws IOException;

        @Override
        @HaxeMethodBody(value="return _stream.syncioReadBytes(p0, p1, p2);")
        public native int read(byte[] var1, int var2, int var3);

        @Override
        @HaxeMethodBody(value="return _stream.syncioWriteBytes(p0, p1, p2);")
        public native int write(byte[] var1, int var2, int var3);

        @Override
        @HaxeMethodBody(value="return _stream.syncioPosition();")
        public native long getPosition();

        @Override
        @HaxeMethodBody(value="_stream.syncioSetPosition(p0);")
        public native void setPosition(long var1);

        @Override
        @HaxeMethodBody(value="return _stream.syncioLength();")
        public native long getLength();

        @Override
        @HaxeMethodBody(value="_stream.syncioSetLength(p0);")
        public native void setLength(long var1);
    }
}

