/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.ChangesXMLParser;
import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.update.Updater;
import com.floreantpos.update.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class UpdateChangesInfoDialog
extends JDialog {
    private boolean canceled;
    private JEditorPane taChanges;
    private String url;
    private Modes readMode;
    private Component parent;
    private boolean readFromResource;
    private URL changeLogURL;

    public UpdateChangesInfoDialog(Component parent, String url) {
        this(parent, url, Modes.URL);
    }

    public UpdateChangesInfoDialog(Component parent, URL url, boolean resourceFile) {
        this(parent, null, Modes.FILE);
        this.readFromResource = resourceFile;
        this.changeLogURL = url;
    }

    public UpdateChangesInfoDialog(Component parent, String url, Modes modes) {
        super((Frame)((JFrame)parent), true);
        String title = ((JFrame)parent).getTitle();
        this.setTitle(title);
        this.url = url;
        this.readMode = modes;
        this.parent = parent;
        this.setIconImage(((JFrame)parent).getIconImage());
        this.setLayout(new BorderLayout());
        JPanel headerPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 0", "", ""));
        headerPanel.setBackground(Color.white);
        JLabel lblUpdateTitle = new JLabel("Changes");
        lblUpdateTitle.setFont(new Font(null, 1, 16));
        lblUpdateTitle.setOpaque(false);
        headerPanel.add((Component)lblUpdateTitle, "gapleft 10,growx,span");
        headerPanel.add((Component)new JSeparator(), "growx,span");
        this.add((Component)headerPanel, "North");
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 20"));
        this.taChanges = new JEditorPane("text/html", "");
        this.taChanges.setEditable(false);
        this.taChanges.setBackground(Color.white);
        this.taChanges.setBorder(BorderFactory.createCompoundBorder(null, BorderFactory.createEmptyBorder(10, 8, 5, 5)));
        JScrollPane scrollPane = new JScrollPane(this.taChanges);
        scrollPane.setBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)));
        contentPanel.add((Component)scrollPane, "grow,span");
        this.add(contentPanel);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fillx,center,ins 0 0 5 0"));
        buttonPanel.add((Component)new JSeparator(), "growx,span,gapbottom 5");
        JButton btnCancel = new JButton("OK ");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateChangesInfoDialog.this.canceled = false;
                UpdateChangesInfoDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)btnCancel, "center,h 35!,w 90!");
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (UpdateChangesInfoDialog.this.readMode == Modes.FILE) {
                        UpdateChangesInfoDialog.this.showCurrentChanges();
                    } else {
                        UpdateChangesInfoDialog.this.showNewChanges();
                    }
                }
            });
        }
        super.setVisible(b);
    }

    protected void showNewChanges() {
        try {
            StringBuilder builder = new StringBuilder();
            UpdateXMLParser updateParser = new UpdateXMLParser();
            ArrayList<Information> versionInfos = updateParser.parse(this.url + "/" + "update.xml", Modes.URL);
            builder.append("<html>");
            if (versionInfos != null) {
                for (Information versionInfo : versionInfos) {
                    String changesLogFile = versionInfo.getChangesLogFile();
                    if (changesLogFile == null || changesLogFile.isEmpty()) continue;
                    this.appendChanges(this.url, changesLogFile, builder);
                }
                builder.append("</html>");
                this.taChanges.setText(builder.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showCurrentChanges() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            String changesLogFile = "change.log.xml";
            String findPathJar = "";
            if (!this.readFromResource) {
                findPathJar = Updater.findPathJar(this.parent.getClass());
                if (findPathJar.contains(".jar")) {
                    findPathJar = findPathJar.substring(0, findPathJar.lastIndexOf(File.separator));
                }
                findPathJar = findPathJar.replace("/classes", "");
            } else {
                findPathJar = this.url;
            }
            this.appendChanges(findPathJar, changesLogFile, builder);
            builder.append("</html>");
            this.taChanges.setText(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendChanges(String url, String changesLogFile, StringBuilder builder) {
        try {
            ChangesXMLParser parser = new ChangesXMLParser();
            ArrayList<Version> versions = null;
            versions = this.readFromResource ? parser.parse(this.changeLogURL) : parser.parse(url + (this.readMode == Modes.URL ? "/" : File.separator) + changesLogFile, this.readMode);
            for (Version version : versions) {
                builder.append("<b>Version: " + version.getVersionNo() + "</b><br>");
                if (version.getChanges() == null) continue;
                for (String change : version.getChanges()) {
                    builder.append("&nbsp;&nbsp;&nbsp;" + change + "<br>");
                }
                builder.append("<br>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTitle(String title, String labelText) {
        this.setTitle(title);
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

