/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.ProgressObserver;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class UpdateProgressDialog
extends JDialog
implements ProgressObserver {
    private JProgressBar pbFile = new JProgressBar();
    private JLabel lblProgress;
    private int v = 0;
    private Component parent;
    private String url;
    private UpdateListener updateListener;
    private boolean update;
    private String appName;

    public UpdateProgressDialog(Component parent, boolean update, UpdateListener lisener, String url, String appName) {
        super((Frame)((JFrame)parent), true);
        this.parent = parent;
        this.updateListener = lisener;
        this.update = update;
        this.url = url;
        this.appName = appName;
        this.setLayout(new BorderLayout());
        if (parent != null && parent instanceof JFrame) {
            this.setIconImage(((JFrame)parent).getIconImage());
        }
        this.setDefaultCloseOperation(0);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.pbFile.setValue(0);
        this.pbFile.setMaximum(100);
        this.pbFile.setStringPainted(true);
        this.pbFile.setBorder(BorderFactory.createTitledBorder(""));
        JPanel progressPanel = new JPanel(new BorderLayout());
        this.lblProgress = new JLabel("Updating..");
        progressPanel.add((Component)this.lblProgress, "North");
        progressPanel.add(this.pbFile);
        contentPanel.add(progressPanel);
        JButton btnCancel = new JButton("Cancel");
        JPanel buttonPanel = new JPanel();
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateProgressDialog.this.doCancel();
            }
        });
        buttonPanel.add(btnCancel);
        contentPanel.add((Component)buttonPanel, "South");
        this.add(contentPanel);
        this.setWindowSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWindowSize() {
        this.setSize(new Dimension(400, 200));
        File file = new File("app.config");
        if (file.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(inputStream);
                String property = properties.getProperty("SCREEN_COMPONENT_SIZE_RATIO");
                Double scaleFactor = 1.0;
                try {
                    scaleFactor = Double.parseDouble(property);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setSize(new Dimension((int)(400.0 * scaleFactor), (int)(150.0 * scaleFactor)));
            }
            catch (Exception exception) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void doCancel() {
        this.dispose();
        this.updateListener.updateCanceled();
    }

    public void setTitle(String title, String labelText) {
        this.setTitle(title);
    }

    public void setProgressTitle(String progressTitle) {
        this.lblProgress.setText(progressTitle);
    }

    public void setProgressValue(int value) {
        this.v = value;
        this.pbFile.setValue(value);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            new Thread(){

                @Override
                public void run() {
                    UpdateProgressDialog.this.v = 0;
                    if (UpdateProgressDialog.this.update) {
                        if (UpdateService.update(UpdateProgressDialog.this, UpdateProgressDialog.this, UpdateProgressDialog.this.url, UpdateProgressDialog.this.appName)) {
                            UpdateProgressDialog.this.dispose();
                            UpdateProgressDialog.this.updateListener.updateComplete();
                        }
                    } else if (UpdateService.download(UpdateProgressDialog.this, UpdateProgressDialog.this.url, UpdateProgressDialog.this.appName)) {
                        UpdateProgressDialog.this.dispose();
                        UpdateProgressDialog.this.updateListener.downloadComplete();
                    }
                }
            }.start();
        }
        super.setVisible(b);
    }

    public void stopProcessing() {
    }

    public void incrementValue() {
        ++this.v;
        this.pbFile.setValue(this.v);
    }

    @Override
    public void progress(int percent, String text) {
        this.pbFile.setValue(percent);
        this.setProgressTitle(text);
    }

    @Override
    public void progress(int percent) {
        this.pbFile.setValue(percent);
    }

    @Override
    public Component getParentComponent() {
        return this.parent;
    }

    public UpdateListener getUpdateListener() {
        return this.updateListener;
    }
}

