/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.Downloader;
import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.ProgressObserver;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateProgressDialog;
import com.floreantpos.update.UpdatePromptDialog;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.update.Updater;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.xml.sax.SAXException;

public class UpdateService {
    public static final String UPDATE_FILE = "update.xml";
    public static final String UP_TO_DATE = "up_to_date";

    public static void checkForUpdate(Component parent, UpdateListener updateListener, String url, String appName, String appVersion, int numVersion) {
        try {
            Information newUpdate = UpdateService.getNewVersionInfo(url, appVersion, numVersion);
            if (newUpdate == null) {
                return;
            }
            String newVersion = newUpdate.getPkgver();
            if (newVersion == null) {
                return;
            }
            appName = newUpdate.getAppName();
            if (appName == null) {
                appName = "";
            }
            UpdateService.propmtToUpdate(parent, updateListener, url, newVersion, appName, appVersion, numVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void propmtToUpdate(Component parent, UpdateListener updateListener, String url, String newVersion, String productName, String appVersion, int numVersion) {
        UpdatePromptDialog promptDialog = new UpdatePromptDialog(parent, url, appVersion, productName, newVersion, numVersion);
        promptDialog.pack();
        promptDialog.setLocationRelativeTo(parent);
        promptDialog.setDefaultCloseOperation(0);
        promptDialog.setVisible(true);
        if (promptDialog.isCanceled()) {
            return;
        }
        UpdateService.startDownload(parent, updateListener, url, productName);
    }

    public static void startDownload(Component parent, UpdateListener updateListener, String url, String productName) {
        UpdateProgressDialog dialog = new UpdateProgressDialog(parent, false, updateListener, url, productName);
        dialog.setTitle("Software update");
        dialog.setProgressTitle("Downloading software in progress.");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public static String getAvaiableUpdate(String url, String appVersion, int numVersion) throws Exception {
        Information serverVersionInfo = UpdateService.getLatestVersion(url);
        Information currentVersionInfo = new Information();
        currentVersionInfo.setPkgver(appVersion);
        currentVersionInfo.setPkgrel(numVersion);
        if (serverVersionInfo == null) {
            return null;
        }
        if (serverVersionInfo.compareTo(currentVersionInfo) > 0) {
            return serverVersionInfo.getPkgver();
        }
        return UP_TO_DATE;
    }

    public static Information getNewVersionInfo(String url, String appVersion, int numVersion) throws Exception {
        Information serverVersionInfo = UpdateService.getLatestVersion(url);
        Information currentVersionInfo = new Information();
        currentVersionInfo.setPkgver(appVersion);
        currentVersionInfo.setPkgrel(numVersion);
        if (serverVersionInfo == null) {
            return null;
        }
        if (serverVersionInfo.compareTo(currentVersionInfo) > 0) {
            return serverVersionInfo;
        }
        return null;
    }

    public static Information getLatestVersion(String url) throws Exception {
        UpdateXMLParser parser = new UpdateXMLParser();
        Iterator<Information> iterator = parser.parse(url = url.endsWith("/") ? url + UPDATE_FILE : url + "/update.xml", Modes.URL).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static boolean download(ProgressObserver observer, String url, String appName) {
        Component rootPane = observer.getParentComponent();
        try {
            observer.progress(0, "Downloading..");
            Downloader dl = new Downloader();
            dl.download(observer, url, url + "/" + UPDATE_FILE, System.getProperty("java.io.tmpdir") + "/" + appName, Modes.URL);
            return true;
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(rootPane, "The xml wasn't loaded succesfully!\n", "Something went wrong!", 2);
            Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(rootPane, "Files were unable to be read or created successfully!\nPlease be sure that you have the right permissions and internet connectivity!", "Something went wrong!", 2);
            Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(rootPane, "Please check your internet connectivity.", "Something went wrong!", 2);
            Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            JOptionPane.showMessageDialog(rootPane, "The connection has been lost!\nPlease check your internet connectivity!", "Something went wrong!", 2);
            Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(ProgressObserver observer, Component rootPane, String destination, String appName) {
        try {
            observer.progress(0, "Extracting...");
            Thread.sleep(500L);
            Updater update = new Updater();
            update.update(observer, UPDATE_FILE, System.getProperty("java.io.tmpdir") + "/" + appName, Modes.FILE, destination);
            System.out.println("Update completed.......");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(rootPane, "Something went wrong, failed to update..", "Error!", 2);
            Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
            observer.progress(0, "Failed.");
            boolean bl = false;
            return bl;
        }
    }

    public static void deleteTempFile(String appName) {
        File tmp = new File(System.getProperty("java.io.tmpdir") + "/" + appName);
        if (tmp.exists()) {
            for (File file : tmp.listFiles()) {
                file.delete();
            }
            tmp.delete();
        }
    }

    public static void restart() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String classPath = System.getProperty("java.class.path");
            String mainClass = System.getProperty("sun.java.command");
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-cp");
            command.add(classPath);
            command.add(mainClass);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

