/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.ProgressObserver;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.update.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class Updater {
    private static final String EXCLUDE_FILE_LIST = "files.xml";

    public void update(ProgressObserver observer, String instructionsxml, String tmp, Modes mode, String destination) throws Exception {
        UpdateXMLParser parser = new UpdateXMLParser();
        ArrayList<Information> updateList = parser.parse(tmp + File.separator + instructionsxml, mode);
        if (updateList == null || updateList.isEmpty()) {
            throw new Exception("Not found.");
        }
        for (Information information : updateList) {
            File pluginsDir;
            observer.progress(0);
            String findPathJar = destination;
            if (findPathJar != null && findPathJar.contains(".jar")) {
                try {
                    findPathJar = findPathJar.substring(0, findPathJar.lastIndexOf("\\"));
                }
                catch (Exception e) {
                    findPathJar = findPathJar.substring(0, findPathJar.lastIndexOf("/"));
                }
            }
            information.setDestination(findPathJar);
            if (information.isRemoveOldPlugins() && (pluginsDir = new File(findPathJar, "plugins")).exists() && pluginsDir.isDirectory()) {
                File[] files;
                for (File file : files = pluginsDir.listFiles()) {
                    file.delete();
                }
            }
            switch (information.getAction()) {
                case MOVE: {
                    if (information.isPlugin().booleanValue()) {
                        try {
                            this.copy(tmp + File.separator + information.getFilename(), information.getDestination() + File.separator + "plugins");
                        }
                        catch (FileNotFoundException e) {}
                        break;
                    }
                    ZipUtil.unZip(observer, tmp + File.separator + information.getFilename(), information.getDestination());
                    break;
                }
                case DELETE: {
                    this.delete(information.getDestination());
                    break;
                }
                case EXECUTE: {
                    Runtime.getRuntime().exec("java -jar " + tmp + File.separator + information.getFilename());
                }
            }
        }
    }

    private void copy(String source, String destination) throws FileNotFoundException, IOException {
        int length;
        destination = destination.replace("/classes", "");
        File srcfile = new File(source);
        File dstfile = new File(destination);
        if (dstfile.isDirectory()) {
            dstfile = new File(destination + File.separator + srcfile.getName());
        }
        FileInputStream in = new FileInputStream(srcfile);
        FileOutputStream out = new FileOutputStream(dstfile);
        byte[] buffer = new byte[512];
        while ((length = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void delete(String filename) {
        File file = new File(filename);
        file.delete();
    }

    public static String findPathJar(Class<?> context) throws IllegalStateException {
        String rawName;
        int idx;
        String classFileName;
        String uri;
        if (context == null) {
            context = Updater.class;
        }
        if ((uri = context.getResource(classFileName = ((idx = (rawName = context.getName()).lastIndexOf(46)) == -1 ? rawName : rawName.substring(idx + 1)) + ".class").toString()).startsWith("file:")) {
            return context.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        if (!uri.startsWith("jar:file:")) {
            int idx2 = uri.indexOf(58);
            String protocol = idx2 == -1 ? "(unknown)" : uri.substring(0, idx2);
            throw new IllegalStateException("This class has been loaded remotely via the " + protocol + " protocol. Only loading from a jar on the local file system is supported.");
        }
        int idx3 = uri.indexOf(33);
        if (idx3 == -1) {
            throw new IllegalStateException("You appear to have loaded this class from a local jar file, but I can't make sense of the URL!");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring("jar:file:".length(), idx3), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("default charset doesn't exist. Your VM is borked.");
        }
    }
}

