/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.ProgressObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    List<String> fileList;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(ProgressObserver observer, String sourceZipFile, String outputFolder) throws Exception {
        outputFolder = outputFolder.replace("/classes", "");
        ZipUtil.cleanUpData(outputFolder);
        ZipFile zipFile = new ZipFile(sourceZipFile);
        long totalBytesRead = 0L;
        int percentCompleted = 0;
        long fileSize = 0L;
        try {
            Enumeration<? extends ZipEntry> entryList = zipFile.entries();
            while (entryList.hasMoreElements()) {
                ZipEntry entry = entryList.nextElement();
                fileSize += entry.getSize();
            }
            System.out.println("Starting unzip.....");
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                int bytesRead = (int)entry.getSize();
                percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                String name = entry.getName();
                File entryDestination = new File(outputFolder, name);
                if (entry.isDirectory()) {
                    if (name.contains("i18n") || name.contains("database") || name.contains("config")) continue;
                    entryDestination.mkdirs();
                    observer.progress(percentCompleted, name);
                    continue;
                }
                if (name.contains("app.config") || name.contains("database") || name.contains("config")) continue;
                observer.progress(percentCompleted, name);
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                if (name.contains("messages") && name.endsWith(".properties")) {
                    try {
                        FileInputStream inStream = new FileInputStream(entryDestination);
                        Properties properties = new Properties();
                        properties.load(inStream);
                        Properties properties2 = new Properties();
                        properties2.load(in);
                        properties2.putAll((Map<?, ?>)properties);
                        FileOutputStream out = new FileOutputStream(entryDestination);
                        properties2.save(out, "");
                        try {
                            in.close();
                            out.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    catch (FileNotFoundException inStream) {
                        // empty catch block
                    }
                }
                FileOutputStream out = new FileOutputStream(entryDestination);
                ZipUtil.copy(in, out);
                System.out.println("Copying file... " + entryDestination.getPath() + File.pathSeparator + name);
                observer.progress(percentCompleted);
                try {
                    in.close();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void cleanUpData(String projectLocation) throws Exception {
        System.out.println("Deleting data ............." + projectLocation);
        File directory = new File(projectLocation);
        try {
            ZipUtil.delete(directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delete(File file) throws IOException {
        System.out.println("Checking directory : " + file.getAbsolutePath());
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                System.out.println("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    if (temp.contains("i18n") || temp.contains("database") || temp.contains("config") || temp.contains("updater.jar")) continue;
                    File fileDelete = new File(file, temp);
                    ZipUtil.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            try {
                if (file.delete()) {
                    System.out.println("File is deleted : " + file.getAbsolutePath());
                } else if (file.renameTo(new File(System.getProperty("java.io.tmpdir") + "/" + file.getName()))) {
                    System.out.println("File is moved successful!");
                } else {
                    System.out.println("File is failed to move--!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = ZipUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return ZipUtil.copyLarge(input, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void unZipIt(String zipFile, String outputFolder) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(outputFolder + File.separator + fileName);
                System.out.println("file unzip : " + newFile.getAbsoluteFile());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            System.out.println("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

