/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.ProgressObserver;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.update.Updater;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.SAXException;

public class Downloader {
    private ProgressObserver observer;

    public void download(ProgressObserver observer, String link, String filesxml, String destinationdir, Modes mode) throws SAXException, FileNotFoundException, IOException, InterruptedException {
        this.observer = observer;
        File dir = new File(destinationdir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        URL url = new URL(filesxml);
        this.download(url, destinationdir + File.separator + new File(url.getFile()).getName());
        String findPathJar = Updater.findPathJar(observer.getParentComponent().getClass());
        if (findPathJar.contains(".jar")) {
            findPathJar = findPathJar.substring(0, findPathJar.lastIndexOf(File.separator));
        }
        Information info = UpdateXMLParser.parse(filesxml, mode);
        url = new URL(link + "/" + info.getFilename());
        this.download(url, destinationdir + File.separator + new File(url.getFile()).getName());
    }

    private void download(URL url, String destination) throws MalformedURLException, IOException {
        int length;
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        File dstfile = new File(destination);
        FileOutputStream out = new FileOutputStream(dstfile);
        byte[] buffer = new byte[512];
        long totalBytesRead = 0L;
        int percentCompleted = 0;
        long fileSize = conn.getContentLength();
        while ((length = in.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
            percentCompleted = (int)((totalBytesRead += (long)length) * 100L / fileSize);
            this.observer.progress(percentCompleted);
        }
        in.close();
        ((OutputStream)out).close();
    }
}

