/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateProgressDialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class UpdateServiceWindow
extends JFrame
implements UpdateListener {
    private String appName;

    public static void main(String[] args) throws Exception {
        System.out.println("Starting updates .......");
        UpdateServiceWindow window = new UpdateServiceWindow();
        ImageIcon icon = new ImageIcon("download.png");
        window.setIconImage(icon.getImage());
        String url = "";
        if (args.length > 0) {
            url = args[0];
        }
        if (url == null || url.isEmpty()) {
            System.out.println("Error: Update url address not defined.");
        }
        String appName = "";
        if (args.length > 1) {
            appName = args[1];
            appName = appName.replaceAll("\\W+", "_").toLowerCase();
        }
        window.setDefaultCloseOperation(0);
        window.setAppName(appName);
        window.setTitle("Updating " + appName);
        window.setSize(0, 0);
        window.setResizable(false);
        UpdateServiceWindow.setWindowLocation(window);
        window.setVisible(true);
        System.out.println(url + "/" + appName);
        UpdateProgressDialog dialog = new UpdateProgressDialog(window, true, window, url, appName);
        dialog.setSize(400, 200);
        dialog.setTitle(appName);
        dialog.setProgressTitle("Updating..");
        dialog.setLocationRelativeTo(window);
        dialog.setIconImage(icon.getImage());
        dialog.setVisible(true);
    }

    private static void setWindowLocation(UpdateServiceWindow window) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = window.getSize().width;
        int h = window.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        window.setLocation(x, y);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public void downloadComplete() {
        this.startMainApp();
    }

    @Override
    public void updateComplete() {
        this.startMainApp();
    }

    public void startMainApp() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String mainClass = "com.floreantpos.main.Main";
            File currentJar = new File(UpdateServiceWindow.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            String decodedParentPath = URLDecoder.decode(currentJar.getPath(), "UTF-8");
            String appJar = decodedParentPath.replace(currentJar.getName(), this.appName.toLowerCase() + ".jar");
            File appDir = new File(appJar);
            if (appDir.isFile()) {
                appDir = appDir.getParentFile();
            }
            StringBuilder classPath = new StringBuilder();
            classPath.append(appJar);
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "i18n");
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "config");
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "lib" + File.separator + "*");
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "plugins" + File.separator + "*");
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-cp");
            command.add(classPath.toString());
            command.add(mainClass);
            new ProcessBuilder(command).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    @Override
    public void updateCanceled() {
        this.startMainApp();
    }

    @Override
    public void downloadFailed() {
    }

    @Override
    public void updateFailed() {
    }
}

