/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.UpdateXMLParserHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class UpdateXMLParser {
    public static Information parse(String filename, Modes mode) throws SAXException, FileNotFoundException, IOException, InterruptedException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        UpdateXMLParserHandler handler = new UpdateXMLParserHandler();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        if (mode == Modes.FILE) {
            try (FileReader fileReader = new FileReader(new File(filename));){
                reader.parse(new InputSource(fileReader));
            }
        }
        URL u = new URL(filename);
        URLConnection conn = u.openConnection();
        try (InputStream in = conn.getInputStream();){
            reader.parse(new InputSource(in));
        }
        ArrayList<Information> informations = handler.getInformations();
        if (informations.size() > 0) {
            return informations.get(0);
        }
        return null;
    }
}

