/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.ProgressObserver;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.update.ZipUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class Updater {
    public void update(ProgressObserver observer, String updateXmlFile, String updateXmlFileLoc, Modes mode, String destination) throws Exception {
        observer.progress(0);
        Information updateInfo = UpdateXMLParser.parse(updateXmlFileLoc + File.separator + updateXmlFile, mode);
        if (updateInfo == null) {
            throw new Exception("Update information not found.");
        }
        updateInfo.setDestination(this.formatJarLocation(destination));
        try (PrintStream printStream = new PrintStream(this.getLogFile());){
            try {
                if (updateInfo.isPlugin().booleanValue()) {
                    this.doUpdatePlugin(updateInfo, printStream);
                    observer.progress(100);
                } else {
                    String zipFile = new File(updateXmlFileLoc, updateInfo.getFilename()).getAbsolutePath();
                    ZipUtil zipUtil = new ZipUtil(zipFile, updateInfo.getDestination(), updateInfo.isRemoveOldPlugins(), printStream);
                    zipUtil.unZip(observer);
                }
            }
            catch (Exception e) {
                e.printStackTrace(printStream);
                throw e;
            }
        }
    }

    private void doUpdatePlugin(Information updateXmlFileInfo, PrintStream printStream) throws IOException {
        String appName = updateXmlFileInfo.getAppName();
        String filename = updateXmlFileInfo.getFilename();
        File sourceFileDir = new File(System.getProperty("java.io.tmpdir"), appName);
        File sourceFile = new File(sourceFileDir, filename);
        File destinationDir = new File(updateXmlFileInfo.getDestination(), "plugins");
        printStream.println("Source file: " + sourceFile);
        printStream.println("Destination location: " + destinationDir);
        File[] listOfFiles = destinationDir.listFiles();
        if (listOfFiles != null && listOfFiles.length > 0) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fileName = listOfFiles[i].getName();
                printStream.println("File name: " + fileName);
                if (!fileName.startsWith(appName.toLowerCase())) continue;
                try {
                    printStream.println("File name matched.");
                    boolean delete = listOfFiles[i].delete();
                    if (delete) {
                        printStream.println("File deleted." + fileName);
                        break;
                    }
                    printStream.println("Unable to delete: " + filename);
                    break;
                }
                catch (Exception e) {
                    printStream.println("Error: " + e.getMessage());
                }
            }
        }
        if (sourceFile.exists()) {
            printStream.println("source file exists. size " + sourceFile.length());
        } else {
            printStream.println("source file does not exist");
        }
        File destFile = new File(destinationDir, filename);
        printStream.println("dest file: " + destFile);
        byte[] bytes = new byte[1024];
        try (BufferedInputStream bInputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             FileOutputStream outputStream = new FileOutputStream(destFile);){
            int read = bInputStream.read(bytes);
            while (read != -1) {
                outputStream.write(bytes);
                read = bInputStream.read(bytes);
            }
        }
    }

    private File getLogFile() throws IOException {
        String filePath = System.getProperty("user.home") + File.separator + "auto-updater.log";
        File logFile = new File(filePath);
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        return logFile;
    }

    private String formatJarLocation(String jarLocation) {
        if (jarLocation != null && jarLocation.contains(".jar")) {
            try {
                jarLocation = jarLocation.substring(0, jarLocation.lastIndexOf("\\"));
            }
            catch (Exception e) {
                jarLocation = jarLocation.substring(0, jarLocation.lastIndexOf("/"));
            }
        }
        return jarLocation;
    }

    public static String findPathJar(Class<?> context) throws IllegalStateException {
        String rawName;
        int idx;
        String classFileName;
        String uri;
        if (context == null) {
            context = Updater.class;
        }
        if ((uri = context.getResource(classFileName = ((idx = (rawName = context.getName()).lastIndexOf(46)) == -1 ? rawName : rawName.substring(idx + 1)) + ".class").toString()).startsWith("file:")) {
            return context.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        if (!uri.startsWith("jar:file:")) {
            int idx2 = uri.indexOf(58);
            String protocol = idx2 == -1 ? "(unknown)" : uri.substring(0, idx2);
            throw new IllegalStateException("This class has been loaded remotely via the " + protocol + " protocol. Only loading from a jar on the local file system is supported.");
        }
        int idx3 = uri.indexOf(33);
        if (idx3 == -1) {
            throw new IllegalStateException("You appear to have loaded this class from a local jar file, but I can't make sense of the URL!");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring("jar:file:".length(), idx3), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("default charset doesn't exist. Your VM is borked.");
        }
    }
}

