/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.update;

import com.floreantpos.update.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    private final int DEFAULT_BUFFER_SIZE = 4096;
    private final int EOF = -1;
    private String sourceZipFile;
    private String outputFolder;
    private boolean removeOldPlugins;
    private PrintStream printStream;

    public ZipUtil(String sourceZipFile, String outputFolder, boolean removeOldPlugins, PrintStream printStream) {
        this.sourceZipFile = sourceZipFile;
        this.outputFolder = outputFolder;
        this.removeOldPlugins = removeOldPlugins;
        this.printStream = printStream;
    }

    public void unZip(ProgressObserver observer) throws Exception {
        this.outputFolder = this.outputFolder.replace("/classes", "");
        this.cleanUpData(this.outputFolder, this.removeOldPlugins);
        long totalBytesRead = 0L;
        int percentCompleted = 0;
        long fileSize = 0L;
        try (ZipFile zipFile = new ZipFile(this.sourceZipFile);){
            Enumeration<? extends ZipEntry> entryList = zipFile.entries();
            while (entryList.hasMoreElements()) {
                ZipEntry entry = entryList.nextElement();
                fileSize += entry.getSize();
            }
            this.print("Starting unzip.....");
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                int bytesRead = (int)entry.getSize();
                percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                String name = entry.getName();
                File entryDestination = new File(this.outputFolder, name);
                if (entry.isDirectory()) {
                    if (name.contains("database") || name.startsWith("config") || name.startsWith("jre") || name.endsWith(".sh") || name.contains("jre/")) continue;
                    entryDestination.mkdirs();
                    observer.progress(percentCompleted, name);
                    continue;
                }
                if (name.contains("app.config") || name.contains("database") || name.startsWith("config") || name.endsWith(".sh") || name.startsWith("jre") || name.contains("jre/")) continue;
                observer.progress(percentCompleted, name);
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    Throwable throwable2 = null;
                    try {
                        this.copy(in, out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    private int copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private void cleanUpData(String projectLocation, boolean removeOldPlugins) throws Exception {
        this.print("Deleting data ............." + projectLocation);
        File directory = new File(projectLocation);
        try {
            this.delete(directory, removeOldPlugins, this.getUpdatedPluginNamesFromZip());
        }
        catch (IOException e) {
            this.print("Error: " + e.getMessage());
        }
    }

    private List<String> getUpdatedPluginNamesFromZip() {
        ArrayList<String> updatedPluginNames = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(this.sourceZipFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.contains("plugins") || !name.endsWith(".jar")) continue;
                String pluginName = name.substring(name.indexOf("/") + 1);
                if (updatedPluginNames.contains(pluginName = this.getPluginNameWithoutVersion(pluginName))) continue;
                updatedPluginNames.add(pluginName);
                this.print("Plugin found: " + pluginName);
            }
        }
        catch (Exception e) {
            this.print("Error: " + e.getMessage());
        }
        return updatedPluginNames;
    }

    private void delete(File file, boolean removeOldPlugins, List<String> updatedPluginNames) throws IOException {
        String fileName = file.getName().toLowerCase();
        if (file.isDirectory()) {
            File[] listFiles;
            boolean pluginsFolder = fileName.equals("plugins");
            if (pluginsFolder && !removeOldPlugins || fileName.equals("database") || fileName.equals("config") || fileName.equals("jre")) {
                this.print("Skipping directory " + fileName);
                return;
            }
            for (File file2 : listFiles = file.listFiles()) {
                if (pluginsFolder && !updatedPluginNames.contains(this.getPluginNameWithoutVersion(file2.getName()))) {
                    this.print("No update found for plugin : " + file2.getName());
                    continue;
                }
                this.delete(file2, removeOldPlugins, updatedPluginNames);
            }
        } else {
            try {
                if (fileName.equals("app.config") || fileName.equals("auto-updater.jar") || fileName.endsWith(".sh")) {
                    return;
                }
                if (file.delete()) {
                    this.print("Deleted : " + file.getAbsolutePath());
                }
                File dest = new File(System.getProperty("java.io.tmpdir") + "/" + file.getName());
                if (file.renameTo(dest)) {
                    this.print(String.format("%s is moved to %s", fileName, dest.getAbsolutePath()));
                }
                this.print("Failed to delete or move " + fileName);
            }
            catch (Exception e) {
                this.print("Error: " + file.getName() + ":" + e.getMessage());
            }
        }
    }

    private String getPluginNameWithoutVersion(String name) {
        if (!(name = name.toLowerCase()).contains("-")) {
            return name;
        }
        return name.substring(0, name.indexOf("-"));
    }

    void print(String s) {
        this.printStream.println(s);
    }
}

