/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.POIReportItem;
import com.floreantpos.report.PurchaseOrderItemReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class ItemwisePurchaseReportService {
    private PurchaseOrderItemReportModel itemReportModel;
    private Date startDate;
    private Date toDate;
    private Terminal terminal;
    private List<MenuGroup> groups;
    private Boolean isInventory;
    private boolean showInGroups;
    private boolean includeFreeItems;
    private boolean isShowModifier;
    private boolean isShowOnlineTicket;
    private Outlet outlet;

    public ItemwisePurchaseReportService(Date startDate, Date toDate, Terminal terminal, List<MenuGroup> groups, Boolean isInventory, boolean showInGroups, boolean includeFreeItems, boolean showModifier, boolean isShowOnlineTicket, Outlet outlet) {
        this.startDate = startDate;
        this.toDate = toDate;
        this.terminal = terminal;
        this.groups = groups;
        this.isInventory = isInventory;
        this.showInGroups = showInGroups;
        this.includeFreeItems = includeFreeItems;
        this.isShowModifier = showModifier;
        this.isShowOnlineTicket = isShowOnlineTicket;
        this.outlet = outlet;
    }

    public JasperPrint createJasperPrint() throws JRException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)this.outlet);
        ReportUtil.populateReportHeader(map, (Outlet)this.outlet, (Date)this.startDate, (Date)this.toDate, null, (boolean)false, (boolean)true);
        this.createModels();
        JasperReport itemReport = ReportUtil.getReport((String)PaperSize.getReportNameAccording2Size((String)"itemwise_sales_sub_report"));
        JasperReport modifierReport = ReportUtil.getReport((String)PaperSize.getReportNameAccording2Size((String)"itemwise_sales_sub_report"));
        String reportTitle = POSConstants.ITEMWISE_SALES_REPORT;
        if (this.isInventory != null) {
            reportTitle = this.isInventory != false ? reportTitle + Messages.getString((String)"ItemwiseSalesReportService.0") : reportTitle + Messages.getString((String)"ItemwiseSalesReportService.1");
        }
        map.put("reportTitle", reportTitle);
        map.put("itemDataSource", new JRTableModelDataSource((TableModel)this.itemReportModel));
        map.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("itemReport", itemReport);
        map.put("isShowGroup", this.showInGroups);
        map.put("isShowModifier", this.isShowModifier);
        map.put("modifierReport", modifierReport);
        map.put("colId", ReportUtil.reportLabelWithBoldTag((String)POSConstants.ID));
        map.put("colName", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NAME));
        map.put("colQty", ReportUtil.reportLabelWithBoldTag((String)POSConstants.QTY));
        map.put("colUnit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT));
        map.put("colSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT_PRICE));
        map.put("colDiscount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.DISCOUNT));
        map.put("colCost", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST));
        map.put("colCostPer", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST_PERCENTAGE));
        map.put("colNetTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NET_SALES));
        map.put("colTax", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TAX));
        map.put("colSC", ReportUtil.reportLabelWithBoldTag((String)POSConstants.S_C));
        map.put("colGrossT", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TOTAL));
        map.put("groupTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROUP_TOTAL));
        map.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.ITEM_TOTAL + ": ")));
        map.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.MODIFIER_TOTAL + ": ")));
        map.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_SALES));
        map.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"SalesReportService.0")));
        map.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.RETURN));
        map.put("lblProfit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_PROFIT));
        map.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.PROFIT + " %")));
        map.put("itemSection", POSConstants.ITEMS);
        JasperReport masterReport = ReportUtil.getReport((String)PaperSize.getReportNameAccording2Size((String)"itemwise_sales_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    public void createModels() {
        LinkedHashMap<String, POIReportItem> itemMap = new LinkedHashMap<String, POIReportItem>();
        PosLog.info(this.getClass(), (String)("Start time: " + this.startDate + ", End time: " + this.toDate));
        for (PurchaseOrderItem purchaseOrderItem : PurchaseOrderItemDAO.getInstance().findPoItemWithinDate(this.startDate, this.toDate, this.groups, this.outlet)) {
            this.populateReportTicketItemToMap(purchaseOrderItem, itemMap);
        }
        ArrayList arrayList = new ArrayList(itemMap.values());
        arrayList.sort(Comparator.comparing(POIReportItem::getDate).reversed().thenComparing(POIReportItem::getName));
        this.itemReportModel = new PurchaseOrderItemReportModel();
        this.itemReportModel.setItems(arrayList);
        this.itemReportModel.calculateGrandTotal();
    }

    private void populateModifiers(TicketItem ticketItem, List<TicketItemModifier> modifiableItems, boolean comboModifier) {
        List ticketItemModifiers = ticketItem instanceof ModifiableTicketItem ? ((ModifiableTicketItem)ticketItem).getTicketItemModifiers() : ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return;
        }
        if (comboModifier && ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                if (ticketItemModifier.isLabDoctorFee()) continue;
                ticketItemModifier.setUnitPrice(Double.valueOf(0.0));
                ticketItemModifier.setUnitCost(Double.valueOf(0.0));
                ticketItemModifier.calculatePrice();
                modifiableItems.add(ticketItemModifier);
            }
        }
    }

    private void populateReportTicketItemToMap(PurchaseOrderItem purchaseOrderItem, Map<String, POIReportItem> itemMap) {
        String menuItemId = purchaseOrderItem.getMenuItemId();
        String key = menuItemId + "_" + purchaseOrderItem.getName() + "_" + purchaseOrderItem.getUnitCost();
        POIReportItem reportItem = itemMap.get(key);
        if (reportItem == null) {
            reportItem = new POIReportItem();
            reportItem.setId(key);
            reportItem.setDate(purchaseOrderItem.getPurchaseOrder().getCreatedDate());
            reportItem.setCost(purchaseOrderItem.getUnitCost().doubleValue());
            String itemName = purchaseOrderItem.getName();
            reportItem.setName(itemName);
            String unitCode = purchaseOrderItem.getItemUnitName();
            InventoryUnit inventoryUnit = DataProvider.get().getInventoryUnitById(unitCode);
            if (inventoryUnit != null) {
                reportItem.setUnit(inventoryUnit.getName());
            } else {
                reportItem.setUnit("");
            }
            reportItem.calculate();
            itemMap.put(key, reportItem);
        }
        reportItem.setQuantity(reportItem.getQuantity() + purchaseOrderItem.getItemQuantity());
        reportItem.setCost(purchaseOrderItem.getUnitCost().doubleValue());
        double netTotal = purchaseOrderItem.getTotalAmount();
        reportItem.setNetTotal(reportItem.getNetTotal() + netTotal);
    }

    public PurchaseOrderItemReportModel getItemReportModel() {
        return this.itemReportModel;
    }
}

