/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.ui.RefreshableView;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.OkCancelWindow;
import com.orocube.siiopa.cloud.client.OkDetailsWindow;
import com.orocube.siiopa.cloud.client.YesNoCancelDialog;
import com.orocube.siiopa.cloud.client.YesNoDialog;
import com.orocube.siiopa.cloud.server.security.CurrentSession;
import com.vaadin.server.Page;
import com.vaadin.shared.Position;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.vaadin.dialogs.ConfirmDialog;

public class CloudNotification {
    public static void showMessage(String message) {
        Notification success = new Notification(message);
        success.setDelayMsec(200);
        success.setStyleName("success");
        success.setPosition(Position.BOTTOM_RIGHT);
        success.show(Page.getCurrent());
    }

    public static void showErrorMessage(String message) {
        Notification success = new Notification(message);
        success.setDelayMsec(5000);
        success.setStyleName("error");
        success.setPosition(Position.BOTTOM_RIGHT);
        success.show(Page.getCurrent());
    }

    public static void showErrorMessage(String message, int delay) {
        Notification success = new Notification(message);
        success.setDelayMsec(delay);
        success.setStyleName("error");
        success.setPosition(Position.BOTTOM_RIGHT);
        success.show(Page.getCurrent());
    }

    public static void showErrorMessageHtmlEnabled(String message) {
        Notification success = new Notification(message);
        success.setDelayMsec(5000);
        success.setHtmlContentAllowed(true);
        success.setStyleName("error");
        success.setPosition(Position.BOTTOM_RIGHT);
        success.show(Page.getCurrent());
    }

    public static void showMessage(String message, int delay) {
        Notification success = new Notification(message);
        success.setDelayMsec(delay);
        success.show(Page.getCurrent());
    }

    public static void showInfoMessageDialog(final String msg, int w, int h) {
        OkCancelWindow window = new OkCancelWindow(){
            private static final long serialVersionUID = 1L;

            @Override
            public void initUI(HorizontalLayout contentPane) {
                CssLayout layout = new CssLayout();
                layout.setSizeFull();
                contentPane.setSizeFull();
                Label lbl = new Label();
                lbl.setWidth("100%");
                lbl.setCaptionAsHtml(true);
                lbl.setCaption(msg);
                layout.addComponent((Component)lbl);
                contentPane.addComponent((Component)layout);
            }

            @Override
            public String getHeaderDisplayString() {
                return ConsoleMessages.getString("CloudNotification.1");
            }

            @Override
            public boolean doOk() {
                return true;
            }
        };
        window.setOkButtonText(ConsoleMessages.getString("CloudNotification.2"));
        window.setCancelButtonVisible(false);
        window.setSize(w, h);
        window.setClosable(false);
        window.setResizable(false);
        window.setModal(true);
        window.open();
    }

    public static void showErrorMessageDialog(String msg) {
        CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("CloudNotification.0"), msg, null);
    }

    public static void showErrorMessageDialog(Class clazz, Exception e) {
        CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("CloudNotification.0"), e.getMessage(), null);
    }

    public static void showErrorMessageDialog(String msg, Exception exception) {
        CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("CloudNotification.0"), msg, exception, null);
    }

    public static void showErrorMessageDialog(String title, String msg, Exception exception) {
        CloudNotification.showErrorMessageDialog(title, msg, exception, null);
    }

    public static void showErrorMessageDialog(String title, String msg, Exception x, ConfirmDialog.Listener listener) {
        if (x != null && !(x instanceof PosException)) {
            String storeSchema = CurrentSession.getStoreSchema();
            String logMessage = "Store: " + storeSchema + ", error: " + msg;
            PosLog.error(CloudNotification.class, (String)logMessage, (Exception)x);
        }
        ConfirmDialog d = ConfirmDialog.show((UI)UI.getCurrent(), (String)title, (String)msg, (String)ConsoleMessages.getString("UIUtil.6"), (String)"", (ConfirmDialog.Listener)listener);
        d.setClosable(false);
        Button cancelButton = d.getCancelButton();
        cancelButton.setVisible(false);
        Button okButton = d.getOkButton();
        if (okButton != null) {
            okButton.setResponsive(true);
            okButton.addStyleName("color-background-button");
            okButton.addStyleName("no-box-shadow");
        }
    }

    public static void showMessageDialog(String msg) {
        CloudNotification.showMessageDialog(ConsoleMessages.getString("UIUtil.5"), msg, null);
    }

    public static void showWarningMessageDialog(String msg) {
        CloudNotification.showMessageDialog(ConsoleMessages.getString("CloudNotification.4"), msg, null);
    }

    public static void showMessageDialog(String title, String msg) {
        CloudNotification.showMessageDialog(title, msg, null);
    }

    public static void showMessageDialog(String title, String msg, ConfirmDialog.Listener listener) {
        ConfirmDialog d = ConfirmDialog.show((UI)UI.getCurrent(), (String)title, (String)msg, (String)ConsoleMessages.getString("UIUtil.6"), (String)"", (ConfirmDialog.Listener)listener);
        d.setClosable(false);
        d.addStyleName("z-index-20000");
        Button okButton = d.getOkButton();
        if (okButton != null) {
            okButton.setResponsive(true);
            okButton.addStyleName("color-background-button");
            okButton.addStyleName("no-box-shadow");
        }
        Button cancelButton = d.getCancelButton();
        cancelButton.setVisible(false);
    }

    public static void showMessageDialogWithOkButton(String title, String msg, ConfirmDialog.Listener listener) {
        ConfirmDialog d = ConfirmDialog.show((UI)UI.getCurrent(), (String)title, (String)msg, (String)ConsoleMessages.getString("EmailSendSubWindow.3"), (String)"", (ConfirmDialog.Listener)listener);
        d.setClosable(false);
        Button cancelButton = d.getCancelButton();
        cancelButton.setVisible(false);
        Button okButton = d.getOkButton();
        if (okButton != null) {
            okButton.setResponsive(true);
            okButton.addStyleName("color-background-button");
            okButton.addStyleName("no-box-shadow");
        }
    }

    public static void showYesNoDialog(String caption, String question, YesNoDialog.Callback callback) {
        YesNoDialog dialog = new YesNoDialog(caption, question, callback);
        UI.getCurrent().addWindow((Window)dialog);
    }

    public static void showCustomYesNoDialog(String headerCaption, String msgContent, YesNoDialog.Callback callback, String yesCaption, String noCaption) {
        CloudNotification.showCustomYesNoDialog(headerCaption, msgContent, callback, yesCaption, noCaption, 0, 0, null);
    }

    public static void showCustomYesNoDialog(String headerCaption, String msgContent, YesNoDialog.Callback callback, String yesCaption, String noCaption, int width, int height, String yesButtonStyle) {
        YesNoDialog dialog = new YesNoDialog(headerCaption, msgContent, callback);
        dialog.setYesButtonCaption(yesCaption, yesButtonStyle);
        dialog.setNoButtonCaption(noCaption);
        if (width > 0 && height > 0) {
            dialog.setWidth(width + "px");
            dialog.setHeight(height + "px");
        }
        UI.getCurrent().addWindow((Window)dialog);
    }

    public static void showYesNoCancelDialog(String headerCaption, String msgContent, YesNoCancelDialog.YesNoCancelListener listener, String yesCaption, String noCaption) {
        CloudNotification.showYesNoCancelDialog(headerCaption, msgContent, listener, yesCaption, noCaption, 0, 0, null);
    }

    public static void showYesNoCancelDialog(String headerCaption, String msgContent, YesNoCancelDialog.YesNoCancelListener listener, String yesCaption, String noCaption, int width, int height, String yesButtonStyle) {
        YesNoCancelDialog dialog = new YesNoCancelDialog(headerCaption, msgContent, listener);
        dialog.setYesButtonCaption(yesCaption, yesButtonStyle);
        dialog.setNoButtonCaption(noCaption);
        if (width > 0 && height > 0) {
            dialog.setWidth(width + "px");
            dialog.setHeight(height + "px");
        }
        UI.getCurrent().addWindow((Window)dialog);
    }

    public static void showYesNoDialog(String question, YesNoDialog.Callback callback) {
        YesNoDialog dialog = new YesNoDialog(ConsoleMessages.getString("CloudNotification.3"), question, callback);
        UI.getCurrent().addWindow((Window)dialog);
    }

    public static void showMessage(String message, Notification.Type errorMessage) {
        Notification error = new Notification(message, errorMessage);
        error.setDelayMsec(1000);
        error.setStyleName("error");
        error.setPosition(Position.BOTTOM_RIGHT);
        error.show(Page.getCurrent());
    }

    public static void showMessageDetailsDialog(String msg, PosException exception) {
        OkDetailsWindow dialog = new OkDetailsWindow(ConsoleMessages.getString("CloudNotification.0"), exception.getMessage(), exception.getDetails());
        dialog.setModal(true);
        UI.getCurrent().addWindow((Window)dialog);
    }

    public static void showMessageDialogWithReloadButton(RefreshableView refreshView) {
        CloudNotification.showMessageDialogWithReloadButton(ConsoleMessages.getString("CloudNotification.0"), ConsoleMessages.getString("CloudNotification.5"), ConsoleMessages.getString("CloudNotification.6"), "", refreshView);
    }

    public static void showMessageDialogWithReloadButton(String windowCaption, String message, String okCaption, String cancelCaption, RefreshableView refreshView) {
        ConfirmDialog d = ConfirmDialog.show((UI)UI.getCurrent(), (String)windowCaption, (String)message, (String)okCaption, (String)cancelCaption, null, null);
        d.setClosable(false);
        Button cancelButton = d.getCancelButton();
        cancelButton.setVisible(false);
        Button okButton = d.getOkButton();
        okButton.addStyleName("color-white");
        okButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (refreshView != null) {
                refreshView.refresh();
            }
        });
    }
}

