/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosLog;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.vaadin.ui.Grid;

public abstract class FooterSupportedBeanGrid<T>
extends BeanGrid<T> {
    private Grid.FooterRow footer;
    private Grid.FooterCell subtotalCell;

    public void mergeAndshowTotal(String ... joinColumns) {
        this.showSummaryRow(null, joinColumns);
    }

    public void showSummaryRow(String column, String ... joinColumns) {
        this.footer = (Grid.FooterRow)this.getFooter().appendRow();
        this.footer.setStyleName("summary-text");
        if (column != null) {
            this.subtotalCell = this.createSummaryTextValue(this.footer, column);
        }
        this.createSummaryText(this.footer, ConsoleMessages.getString("DailySummaryReportGrid.5"), joinColumns);
    }

    public Grid.FooterCell createSummaryCell(String column) {
        return this.createSummaryTextValue(this.footer, column);
    }

    public Grid.FooterCell createSummaryText(Grid.FooterRow footer, String text, String[] joinColumns) {
        Grid.FooterCell totalText = joinColumns.length == 1 ? (Grid.FooterCell)footer.getCell((Object)joinColumns[0]) : (Grid.FooterCell)footer.join((Object[])joinColumns);
        totalText.setStyleName("summary-text");
        totalText.setHtml(this.createDivElement(text));
        return totalText;
    }

    public void updateView(Double subtotalAmount) {
        this.updateCellValue(this.subtotalCell, subtotalAmount);
    }

    public void updateCellValue(Grid.FooterCell cell, Double value) {
        try {
            cell.setHtml(this.createDivElement(NumberUtil.format((Number)value)));
        }
        catch (Exception e) {
            PosLog.error((Class)this.getReferenceClass(), (Exception)e);
        }
    }

    public void updateCellValue(Grid.FooterCell cell, Integer value) {
        try {
            cell.setHtml(this.createDivElement(NumberUtil.trimDecilamIfNotNeeded((Number)value)));
        }
        catch (Exception e) {
            PosLog.error((Class)this.getReferenceClass(), (Exception)e);
        }
    }

    private String createDivElement(String text) {
        return "<div style='font-weight:bold;font-size:16px;'>" + text + "</div>";
    }

    private Grid.FooterCell createSummaryTextValue(Grid.FooterRow footer, String key) {
        Grid.FooterCell cell = (Grid.FooterCell)footer.getCell((Object)key);
        cell.setStyleName("summary-text");
        return cell;
    }

    public void doUpdateTotalValue() {
    }

    public void clearFooterCell() {
        if (this.subtotalCell != null) {
            this.updateCellValue(this.subtotalCell, 0.0);
        }
    }
}

