/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.report.PurchaseOrderItemReportModel;
import com.floreantpos.report.service.ItemwisePurchaseReportService;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTypeableCombobox;
import com.orocube.siiopa.cloud.client.curd.grid.ItemwisePurchaseReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.orocube.siiopa.cloud.server.CloudResourceCache;
import com.vaadin.data.Property;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class ItemwisePurchaseReportView
extends ReportView {
    public static final String VIEW_NAME = "Itemwise purchase report";
    private SiiopaCombobox cbGroup;
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private PurchaseOrderItemReportModel itemReportModel;
    private CheckBox chkShowModifierSeparately;
    private CheckBox chkShowOnlineReport;

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        topLayout.setSizeUndefined();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                ItemwisePurchaseReportView.this.updateView();
            }
        };
        this.cbGroup = new SiiopaTypeableCombobox();
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(POSConstants.ALL);
        List menuGroups = MenuGroupDAO.getInstance().findAll();
        groups.addAll(menuGroups);
        this.cbGroup.addItems(groups);
        this.cbGroup.setNullSelectionAllowed(false);
        this.cbGroup.select(POSConstants.ALL);
        ShortcutListener shortcutListener = new ShortcutListener("Enter key pressed", 13, null){

            public void handleAction(Object sender, Object target) {
                PosLog.debug(ItemwisePurchaseReportView.class, (String)"group shortcut listener fired");
                if (target == ItemwisePurchaseReportView.this.cbGroup) {
                    ItemwisePurchaseReportView.this.updateView();
                }
            }
        };
        this.cbGroup.addShortcutListener(shortcutListener);
        this.cbGroup.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.chkShowModifierSeparately = new CheckBox(ConsoleMessages.getString("ItemwiseSalesReportView.0"));
        this.chkShowModifierSeparately.setValue((Object)Boolean.FALSE);
        this.chkShowOnlineReport = new CheckBox(ConsoleMessages.getString("show_online_report_only"));
        this.chkShowOnlineReport.setValue((Object)Boolean.FALSE);
        if (CloudResourceCache.get().isSiiopa()) {
            this.chkShowOnlineReport.setVisible(false);
        }
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("InventoryItemSalesReportView.3"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET") + " :", (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("InventoryItemSalesReportView.4"), (Component)this.cbGroup));
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource(this.itemReportModel);
    }

    @Override
    protected BeanGrid createItemGrid() {
        ItemwisePurchaseReportGrid itemwisePurchaseReportGrid = new ItemwisePurchaseReportGrid();
        itemwisePurchaseReportGrid.addStyleName("InventoryItemSalesReportGrid");
        return itemwisePurchaseReportGrid;
    }

    private void doClear() {
        this.grid.removeAll();
        this.gridLayout.setVisible(false);
        this.cbGroup.setValue(POSConstants.ALL);
        this.chkShowOnlineReport.setValue((Object)Boolean.FALSE);
        this.cbOutlet.selectFirstComponent();
        this.clearDateFields();
        this.chkShowModifierSeparately.setValue((Object)Boolean.FALSE);
    }

    private StreamResource getStreamResource(PurchaseOrderItemReportModel itemReportModel) {
        StreamResource streamResource = null;
        try {
            this.validateDate();
            Date startTime = this.getFromDate();
            Date endTime = this.getToDate();
            Outlet outlet = null;
            if (this.cbOutlet.getValue() instanceof Outlet) {
                outlet = (Outlet)this.cbOutlet.getValue();
            }
            JasperPrint jasperPrint = CommonCloudReportService.getItemwisePurchaseReportPrint(startTime, endTime, null, Boolean.FALSE, itemReportModel, null, (Boolean)this.chkShowModifierSeparately.getValue(), outlet, (Boolean)this.chkShowOnlineReport.getValue());
            streamResource = CommonCloudReportService.getReportStream("itemwise_purchase_report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (PosException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e);
        }
        return streamResource;
    }

    private void doSearch() throws Exception {
        ArrayList<MenuGroup> groupList = new ArrayList<MenuGroup>();
        MenuGroup group = null;
        Object menuGroup = this.cbGroup.getValue();
        if (menuGroup != null && !menuGroup.equals(POSConstants.ALL)) {
            group = (MenuGroup)menuGroup;
            groupList.add(group);
        }
        Outlet outlet = this.cbOutlet.getSelectedOrDefaultOutlet();
        boolean isShowModifierSeparately = (Boolean)this.chkShowModifierSeparately.getValue();
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        ItemwisePurchaseReportService itemwiseSalesReportService = new ItemwisePurchaseReportService(startTime, endTime, null, groupList, null, Boolean.FALSE, Boolean.TRUE, isShowModifierSeparately, (Boolean)this.chkShowOnlineReport.getValue(), outlet);
        itemwiseSalesReportService.createModels();
        this.itemReportModel = itemwiseSalesReportService.getItemReportModel();
    }

    private String getBoldText(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append("<strong style=\"font-size:18px\">");
        builder.append(text);
        builder.append("</strong>");
        return builder.toString();
    }

    private String getValueAsIntegerString(Double number) {
        try {
            double doubleValue = number;
            int integerValue = (int)doubleValue;
            return String.valueOf(integerValue);
        }
        catch (Exception e0) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e0);
            return "";
        }
    }

    @Override
    public void updateView() {
        this.grid.removeAll();
        try {
            this.doSearch();
        }
        catch (PosException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
            this.gridLayout.setVisible(false);
            return;
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(((Object)((Object)this)).getClass(), e);
            this.gridLayout.setVisible(false);
            return;
        }
        if (this.itemReportModel != null && this.itemReportModel.getRowCount() > 0) {
            Double sumOfGrossSales = 0.0;
            for (int i = 0; i < this.itemReportModel.getRowCount(); ++i) {
                String date = String.valueOf(this.itemReportModel.getValueAt(i, 0));
                String name = String.valueOf(this.itemReportModel.getValueAt(i, 1));
                String unitCost = NumberUtil.formatNumber((Double)((Double)this.itemReportModel.getValueAt(i, 2)));
                String quantity = String.valueOf(this.itemReportModel.getValueAt(i, 3));
                String unitName = String.valueOf(this.itemReportModel.getValueAt(i, 4));
                String netTotal = NumberUtil.formatNumber((Double)((Double)this.itemReportModel.getValueAt(i, 5)));
                sumOfGrossSales = sumOfGrossSales + (Double)this.itemReportModel.getValueAt(i, 5);
                this.grid.addRow(new Object[]{date, name, unitCost, quantity, unitName, netTotal});
            }
            String sumOfGrossSalesText = NumberUtil.formatNumber((Double)sumOfGrossSales);
            sumOfGrossSalesText = this.getBoldText(sumOfGrossSalesText);
            this.grid.addRow(new Object[]{null, null, null, null, this.getBoldText(POSConstants.GRAND_TOTAL), sumOfGrossSalesText});
        }
        this.gridLayout.setVisible(true);
    }
}

