/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.util.DataProvider;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.PurchaseSummaryReportGrid;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PurchaseSummaryReportView
extends ReportView {
    public static final String VIEW_NAME = "Purchase Summary Report";
    private SiiopaTextField tfPONo;
    private OutletCombobox cbOutlet;
    private SiiopaCombobox cbVendor;
    private VerticalLayout gridLayout;
    private PurchaseSummaryReportGrid reportGrid;
    private List<PurchaseOrder> purchaseOrders;

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.tfPONo = new SiiopaTextField();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                PurchaseSummaryReportView.this.updateView();
            }
        };
        this.cbVendor = new SiiopaCombobox();
        this.cbVendor.addItems(InventoryVendorDAO.getInstance().findAll());
        this.cbVendor.setInputPrompt(ConsoleMessages.getString("LedgerEntryInlineForm.3"));
        this.cbVendor.setFilteringMode(FilteringMode.CONTAINS);
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("PO. No", (Component)this.tfPONo));
        super.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Vendor", (Component)this.cbVendor));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(false);
        buttonLayout.setSpacing(true);
        this.gridLayout.addComponent((Component)buttonLayout);
        this.gridLayout.setExpandRatio((Component)buttonLayout, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    protected void doClear() {
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
        super.clearDateFields();
        this.tfPONo.clear();
        this.cbVendor.clear();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        InventoryVendor vendor = (InventoryVendor)this.cbVendor.getValue();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(1);
        statusList.add(7);
        statusList.add(4);
        this.purchaseOrders = PurchaseOrderDAO.getInstance().findBy(this.tfPONo.getValue(), vendor, startTime, endTime, ProductType.GOODS, null, this.cbOutlet.getSelectedOrDefaultOutlet(), statusList);
        this.reportGrid.setItems((Collection<PurchaseOrder>)this.purchaseOrders);
        this.gridLayout.setVisible(true);
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        return null;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.reportGrid = new PurchaseSummaryReportGrid();
        return this.reportGrid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            try {
                this.doSearch();
            }
            catch (PosException e) {
                CloudNotification.showErrorMessageDialog(e.getMessage());
                this.gridLayout.setVisible(false);
                return;
            }
            catch (Exception e) {
                CloudNotification.showErrorMessageDialog(e.getMessage(), e);
                this.gridLayout.setVisible(false);
                return;
            }
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
        }
    }
}

