/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class ItemwiseSalesReportService {
    private SalesReportModel itemReportModel;
    private SalesReportModel modifierReportModel;
    private Date startDate;
    private Date toDate;
    private Terminal terminal;
    private List<MenuGroup> groups;
    private Boolean isInventory;
    private boolean showInGroups;
    private boolean includeFreeItems;
    private boolean isShowModifier;
    private boolean isShowOnlineTicket;
    private Outlet outlet;
    private String orderNo;

    public ItemwiseSalesReportService(Date startDate, Date toDate, Terminal terminal, List<MenuGroup> groups, Boolean isInventory, boolean showInGroups, boolean includeFreeItems, boolean showModifier, boolean isShowOnlineTicket, Outlet outlet) {
        this(startDate, toDate, terminal, groups, isInventory, showInGroups, includeFreeItems, showModifier, isShowOnlineTicket, outlet, "");
    }

    public ItemwiseSalesReportService(Date startDate, Date toDate, Terminal terminal, List<MenuGroup> groups, Boolean isInventory, boolean showInGroups, boolean includeFreeItems, boolean showModifier, boolean isShowOnlineTicket, Outlet outlet, String orderNo) {
        this.startDate = startDate;
        this.toDate = toDate;
        this.terminal = terminal;
        this.groups = groups;
        this.isInventory = isInventory;
        this.showInGroups = showInGroups;
        this.includeFreeItems = includeFreeItems;
        this.isShowModifier = showModifier;
        this.isShowOnlineTicket = isShowOnlineTicket;
        this.outlet = outlet;
        this.orderNo = orderNo;
    }

    public JasperPrint createJasperPrint() throws JRException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)this.outlet);
        ReportUtil.populateReportHeader(map, (Outlet)this.outlet, (Date)this.startDate, (Date)this.toDate, null, (boolean)false, (boolean)true);
        this.createModels();
        JasperReport itemReport = ReportUtil.getReport((String)PaperSize.getReportNameAccording2Size((String)"itemwise_sales_sub_report"));
        JasperReport modifierReport = ReportUtil.getReport((String)PaperSize.getReportNameAccording2Size((String)"itemwise_sales_sub_report"));
        String reportTitle = POSConstants.ITEMWISE_SALES_REPORT;
        if (this.isInventory != null) {
            reportTitle = this.isInventory != false ? reportTitle + Messages.getString((String)"ItemwiseSalesReportService.0") : reportTitle + Messages.getString((String)"ItemwiseSalesReportService.1");
        }
        map.put("reportTitle", reportTitle);
        map.put("itemDataSource", new JRTableModelDataSource((TableModel)this.itemReportModel));
        map.put("modifierDataSource", new JRTableModelDataSource((TableModel)this.modifierReportModel));
        map.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("itemReport", itemReport);
        map.put("isShowGroup", this.showInGroups);
        map.put("isShowModifier", this.isShowModifier);
        map.put("modifierReport", modifierReport);
        map.put("colId", ReportUtil.reportLabelWithBoldTag((String)POSConstants.ID));
        map.put("colName", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NAME));
        map.put("colQty", ReportUtil.reportLabelWithBoldTag((String)POSConstants.QTY));
        map.put("colUnit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT));
        map.put("colSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT_PRICE));
        map.put("colDiscount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.DISCOUNT));
        map.put("colCost", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST));
        map.put("colCostPer", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST_PERCENTAGE));
        map.put("colNetTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NET_SALES));
        map.put("colTax", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TAX));
        map.put("colSC", ReportUtil.reportLabelWithBoldTag((String)POSConstants.S_C));
        map.put("colGrossT", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TOTAL));
        map.put("groupTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROUP_TOTAL));
        map.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.ITEM_TOTAL + ": ")));
        map.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.MODIFIER_TOTAL + ": ")));
        map.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_SALES));
        map.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"SalesReportService.0")));
        map.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.RETURN));
        map.put("lblProfit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_PROFIT));
        map.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.PROFIT + " %")));
        map.put("itemSection", POSConstants.ITEMS);
        if (this.modifierReportModel.getItems().size() > 0) {
            map.put("modifierSection", Messages.getString((String)"SalesReportService.5"));
        }
        this.populateGrandTotal(map);
        JasperReport masterReport = ReportUtil.getReport((String)PaperSize.getReportNameAccording2Size((String)"itemwise_sales_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    public void createModels() {
        LinkedHashMap<String, ReportItem> itemMap = new LinkedHashMap<String, ReportItem>();
        LinkedHashMap<String, ReportItem> modifierMap = new LinkedHashMap<String, ReportItem>();
        PosLog.info(this.getClass(), (String)("Start time: " + this.startDate + " ,End time: " + this.toDate));
        List ticketItems = TicketItemDAO.getInstance().findTicketItemWithinDate(this.startDate, this.toDate, this.terminal, this.groups, this.isInventory, this.outlet, Boolean.valueOf(this.isShowOnlineTicket), null, this.orderNo);
        ArrayList<TicketItemModifier> ticketModifierItems = new ArrayList<TicketItemModifier>();
        for (Object ticketItem : ticketItems) {
            ComboTicketItem comboTicketItem;
            List comboItems;
            if (!this.includeFreeItems) continue;
            this.populateReportTicketItemToMap((TicketItem)ticketItem, null, itemMap);
            this.populateModifiers((TicketItem)ticketItem, ticketModifierItems, false);
            if (!ticketItem.isComboItem().booleanValue() || !(ticketItem instanceof ComboTicketItem) || (comboItems = (comboTicketItem = (ComboTicketItem)ticketItem).getComboItems()) == null || comboItems.size() <= 0) continue;
            for (TicketItem comboChildTicketItem : comboItems) {
                comboChildTicketItem.setUnitPrice(Double.valueOf(0.0));
                comboChildTicketItem.setUnitCost(Double.valueOf(0.0));
                comboChildTicketItem.setGroupId(ticketItem.getGroupId());
                comboChildTicketItem.setGroupName(ticketItem.getGroupName());
                List ticketItemModifiers = comboChildTicketItem.getTicketItemModifiers();
                if (ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
                    for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                        ticketItemModifier.setUnitPrice(Double.valueOf(0.0));
                        ticketItemModifier.setUnitCost(Double.valueOf(0.0));
                    }
                }
                comboChildTicketItem.calculatePrice();
                this.populateReportTicketItemToMap(comboChildTicketItem, (TicketItem)ticketItem, itemMap);
            }
        }
        ArrayList arrayList = new ArrayList(((HashMap)itemMap).values());
        if (this.showInGroups) {
            Collections.sort(arrayList, new Comparator<ReportItem>(){

                @Override
                public int compare(ReportItem o1, ReportItem o2) {
                    if (o1.getGroupName() == o2.getGroupName()) {
                        return 0;
                    }
                    if (o1.getGroupName() == null) {
                        return 1;
                    }
                    if (o2.getGroupName() == null) {
                        return -1;
                    }
                    return o1.getGroupName().compareTo(o2.getGroupName());
                }
            });
        }
        this.itemReportModel = new SalesReportModel();
        this.itemReportModel.setItems(arrayList);
        this.itemReportModel.calculateGrandTotal();
        for (TicketItemModifier modifier : ticketModifierItems) {
            if (modifier.isInfoOnly().booleanValue()) continue;
            String itemId = modifier.getItemId();
            String key = (itemId == null ? modifier.getName() : itemId) + "-" + modifier.getModifierType() + "-" + modifier.getUnitPrice();
            ReportItem modifierReportItem = (ReportItem)((HashMap)modifierMap).get(key);
            if (modifierReportItem == null) {
                modifierReportItem = new ReportItem();
                modifierReportItem.setId(itemId);
                modifierReportItem.setPrice(modifier.getUnitPrice().doubleValue());
                modifierReportItem.setName(modifier.getName());
                if (modifier.getGroupId() != null) {
                    MenuItemModifierSpec modifierGroup = MenuItemModifierSpecDAO.getInstance().get(modifier.getGroupId());
                    modifierReportItem.setGroupName(modifierGroup != null ? modifierGroup.getName() : "");
                }
                modifierReportItem.setTaxRate(modifier.getTotalTaxRate());
                modifierReportItem.setAdjustedPrice(modifier.getAdjustedUnitPrice().doubleValue());
                modifierReportItem.calculate();
                modifierMap.put(key, modifierReportItem);
            }
            modifierReportItem.setCost(modifierReportItem.getCost() + modifier.getTotalCost());
            modifierReportItem.setQuantity(modifierReportItem.getQuantity() + modifier.getItemQuantity() * Math.abs(modifier.getTicketItemQuantity()));
            modifierReportItem.setDiscount(modifierReportItem.getDiscount() + modifier.getAdjustedDiscount());
            modifierReportItem.setTaxTotal(modifierReportItem.getTaxTotal() + modifier.getAdjustedTax());
            modifierReportItem.setServiceCharge(modifierReportItem.getServiceCharge() + modifier.getServiceCharge());
            Double subtotalAmount = modifier.getSubtotalAmount();
            TicketItem ticketItem = modifier.getTicketItem();
            if (ticketItem.isTaxIncluded().booleanValue()) {
                subtotalAmount = subtotalAmount - modifier.getAdjustedTax();
            }
            if (ticketItem.isItemReturned().booleanValue()) {
                modifierReportItem.setReturnAmount(modifierReportItem.getReturnAmount() + subtotalAmount);
            } else {
                modifierReportItem.setGrossSale(modifierReportItem.getGrossSale() + subtotalAmount);
            }
            double netTotal = modifierReportItem.getGrossSale() - modifierReportItem.getDiscount() + modifierReportItem.getReturnAmount();
            modifierReportItem.setNetTotal(netTotal);
            modifierReportItem.setGrossTotal(netTotal + modifierReportItem.getServiceCharge() + modifierReportItem.getTaxTotal());
            modifierReportItem.calculate();
        }
        this.modifierReportModel = new SalesReportModel();
        ArrayList modifiers = new ArrayList(((HashMap)modifierMap).values());
        modifiers.sort(Comparator.comparing(ReportItem::getName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)));
        this.modifierReportModel.setItems(modifiers);
        this.modifierReportModel.calculateGrandTotal();
    }

    private void populateGrandTotal(HashMap<String, Object> map) {
        map.put("gndTotalGrossSales", this.itemReportModel.getGndTotalGrossSales() + this.modifierReportModel.getGndTotalGrossSales());
        map.put("gndTotalDiscount", this.itemReportModel.getGndTotalDiscount() + this.modifierReportModel.getGndTotalDiscount());
        map.put("gndTotalReturn", this.itemReportModel.getGndTotalReturn() + this.modifierReportModel.getGndTotalReturn());
        map.put("gndTotalNetSales", this.itemReportModel.getGndTotalNetSales() + this.modifierReportModel.getGndTotalNetSales());
        map.put("gndTotalServCharge", this.itemReportModel.getGndTotalServCharge() + this.modifierReportModel.getGndTotalServCharge());
        map.put("gndTotalTax", this.itemReportModel.getGndTotalTax() + this.modifierReportModel.getGndTotalTax());
        map.put("gndTotalTotal", this.itemReportModel.getGndTotalTotal() + this.modifierReportModel.getGndTotalTotal());
        map.put("gndTotalCost", this.itemReportModel.getGndTotalCost() + this.modifierReportModel.getGndTotalCost());
        map.put("gndTotalProfit", this.itemReportModel.getGndTotalProfit() + this.modifierReportModel.getGndTotalProfit());
    }

    private void populateModifiers(TicketItem ticketItem, List<TicketItemModifier> modifiableItems, boolean comboModifier) {
        List ticketItemModifiers = ticketItem instanceof ModifiableTicketItem ? ((ModifiableTicketItem)ticketItem).getTicketItemModifiers() : ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return;
        }
        if (comboModifier && ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                if (ticketItemModifier.isLabDoctorFee()) continue;
                ticketItemModifier.setUnitPrice(Double.valueOf(0.0));
                ticketItemModifier.setUnitCost(Double.valueOf(0.0));
                ticketItemModifier.calculatePrice();
                modifiableItems.add(ticketItemModifier);
            }
        }
    }

    private void populateReportTicketItemToMap(TicketItem ticketItem, TicketItem parentTicketItem, HashMap<String, ReportItem> itemMap) {
        ReportItem reportItem;
        String menuItemId = ticketItem.getMenuItemId();
        Double unitPrice = ticketItem.getUnitPrice();
        if (ticketItem.isTaxIncluded().booleanValue()) {
            unitPrice = unitPrice - ticketItem.getAdjustedTax();
        }
        String key = menuItemId + "_" + ticketItem.getName() + "_" + unitPrice;
        if (parentTicketItem != null) {
            List ticketItemModifiers;
            String parentMenuItemId = parentTicketItem.getMenuItemId();
            unitPrice = parentTicketItem.getUnitPrice();
            if (ticketItem.isTaxIncluded().booleanValue()) {
                unitPrice = unitPrice - parentTicketItem.getAdjustedTax();
            }
            key = key + "_" + parentMenuItemId + "_" + parentTicketItem.getName() + "_" + unitPrice;
            if (this.isShowModifier && ticketItem.isHasModifiers().booleanValue() && ticketItem instanceof ModifiableTicketItem && (ticketItemModifiers = ((ModifiableTicketItem)ticketItem).getTicketItemModifiers()) != null) {
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    key = key + "_" + ticketItemModifier.getId();
                }
            }
        }
        if ((reportItem = itemMap.get(key)) == null) {
            reportItem = new ReportItem();
            reportItem.setId(key);
            reportItem.setPrice(unitPrice.doubleValue());
            String itemName = "";
            if (parentTicketItem != null) {
                if (this.isShowModifier && ticketItem.isHasModifiers().booleanValue()) {
                    List ticketItemModifiers;
                    itemName = "    #" + ticketItem.getName();
                    if (ticketItem instanceof ModifiableTicketItem && (ticketItemModifiers = ((ModifiableTicketItem)ticketItem).getTicketItemModifiers()) != null) {
                        for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                            itemName = itemName + "\n     --" + ticketItemModifier.getName();
                        }
                    }
                } else {
                    itemName = "    #" + ticketItem.getName();
                }
            } else {
                itemName = ticketItem.getName();
            }
            reportItem.setName(itemName);
            String unitCode = ticketItem.getUnitName();
            InventoryUnit inventoryUnit = DataProvider.get().getInventoryUnitById(unitCode);
            if (inventoryUnit != null) {
                reportItem.setUnit(inventoryUnit.getName());
            } else {
                reportItem.setUnit("");
            }
            reportItem.setTaxRate(ticketItem.getTotalTaxRate());
            reportItem.setGroupName(ticketItem.getGroupName());
            reportItem.setBarcode(menuItemId);
            reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice().doubleValue());
            reportItem.setComboChildItem(parentTicketItem != null);
            reportItem.calculate();
            itemMap.put(key, reportItem);
        }
        reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
        double discount = 0.0;
        double totalCost = 0.0;
        double totalServiceCharge = 0.0;
        double totalTax = 0.0;
        if (this.isShowModifier) {
            discount = ticketItem.getAdjustedDiscountWithoutModifiers();
            totalCost = ticketItem.getTotalCostWithoutModifiers();
            totalServiceCharge = ticketItem.getServiceChargeWithoutModifiers();
            totalTax = ticketItem.getAdjustedTaxWithoutModifiers();
        } else {
            discount = ticketItem.getAdjustedDiscount();
            totalCost = ticketItem.getTotalCost();
            totalServiceCharge = ticketItem.getServiceCharge();
            totalTax = ticketItem.getAdjustedTax();
        }
        reportItem.setDiscount(reportItem.getDiscount() + discount);
        reportItem.setCost(reportItem.getCost() + totalCost);
        reportItem.setTaxTotal(reportItem.getTaxTotal() + totalTax);
        reportItem.setServiceCharge(reportItem.getServiceCharge() + totalServiceCharge);
        if (ticketItem.getTicket().isApplyDiscountOnReferral()) {
            if (ticketItem.getReferrerFeeOnReport() + discount > discount) {
                reportItem.setAgentFeeAmount(reportItem.getAgentFeeAmount() + ticketItem.getReferrerFeeOnReport());
            }
        } else {
            reportItem.setAgentFeeAmount(reportItem.getAgentFeeAmount() + ticketItem.getReferrerFeeOnReport());
        }
        reportItem.setLabDoctorFeeAmount(reportItem.getLabDoctorFeeAmount() + ticketItem.getLabDoctorFee());
        Double amount = 0.0;
        amount = this.isShowModifier ? (ticketItem.isTaxIncluded().booleanValue() ? Double.valueOf(ticketItem.getSubtotalAmountWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers()) : ticketItem.getSubtotalAmountWithoutModifiers()) : (ticketItem.isTaxIncluded() != false ? Double.valueOf(ticketItem.getSubtotalAmount() - ticketItem.getAdjustedTax()) : ticketItem.getSubtotalAmount());
        if (ticketItem.isItemReturned().booleanValue()) {
            reportItem.setReturnAmount(reportItem.getReturnAmount() + amount);
        } else {
            reportItem.setGrossSale(reportItem.getGrossSale() + amount);
        }
        double netTotal = reportItem.getGrossSale() - reportItem.getDiscount() + reportItem.getReturnAmount() - (reportItem.getAgentFeeAmount() + reportItem.getLabDoctorFeeAmount());
        reportItem.setNetTotal(netTotal);
        reportItem.setGrossTotal(netTotal + reportItem.getServiceCharge() + reportItem.getTaxTotal());
        reportItem.calculate();
    }

    public SalesReportModel getItemReportModel() {
        return this.itemReportModel;
    }

    public SalesReportModel getModifierReportModel() {
        return this.modifierReportModel;
    }
}

