/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosLog;
import com.ibm.icu.text.SimpleDateFormat;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.crud.view.TextPreviewDialog;
import com.orocube.siiopa.cloud.server.CloudContext;
import com.orocube.siiopa.cloud.server.CloudResourceCache;
import com.vaadin.event.LayoutEvents;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FileResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ColorPicker;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.ui.components.colorpicker.ColorChangeListener;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.addons.stackpanel.StackPanel;
import org.vaadin.dialogs.ConfirmDialog;

public class CommonUIUtil {
    private static final String LOGO_NAME_PNG = "medlogics_logo.png";
    private static final String CONSOLE = ConsoleMessages.getString("CONSOLE");
    private static final String RESELLER = ConsoleMessages.getString("RESELLER");
    private static final String ORDER_MANAGER = ConsoleMessages.getString("ORDER_MANAGER");
    public static final String OROWORKSPACE = ConsoleMessages.getString("UIUtil.0");

    public static Button createWhiteButton(String label) {
        CloudButton whiteButton = StringUtils.isEmpty((CharSequence)label) ? new CloudButton() : new CloudButton(label);
        whiteButton.addStyleName("white-background-button");
        whiteButton.addStyleName("no-box-shadow");
        whiteButton.setResponsive(true);
        return whiteButton;
    }

    public static CloudButton createGreyButton(String label) {
        CloudButton colorButton = StringUtils.isEmpty((CharSequence)label) ? new CloudButton() : new CloudButton(label);
        colorButton.setResponsive(true);
        colorButton.addStyleName("grey-color-background-button");
        colorButton.addStyleName("no-box-shadow");
        return colorButton;
    }

    public static CloudButton createColorButton(String label) {
        CloudButton colorButton = StringUtils.isEmpty((CharSequence)label) ? new CloudButton() : new CloudButton(label);
        colorButton.setResponsive(true);
        colorButton.addStyleName("color-background-button");
        colorButton.addStyleName("no-box-shadow");
        return colorButton;
    }

    public static CloudButton createColorButtonListner(String label, Button.ClickListener listener) {
        CloudButton colorButton = StringUtils.isEmpty((CharSequence)label) ? new CloudButton() : new CloudButton(label);
        colorButton.addClickListener(listener);
        colorButton.setResponsive(true);
        colorButton.addStyleName("color-background-button");
        colorButton.addStyleName("no-box-shadow");
        return colorButton;
    }

    public static TextField createTextField(String label, boolean required) {
        TextField textField = new TextField(label);
        textField.setRequired(required);
        textField.setNullRepresentation("");
        textField.setResponsive(true);
        textField.setWidth("100%");
        return textField;
    }

    public static TextField createTextField(String label) {
        return CommonUIUtil.createTextField(label, false, 128);
    }

    public static TextField createTextField(String label, boolean required, int maxLength) {
        TextField textField = StringUtils.isNotBlank((CharSequence)label) ? new TextField(label) : new TextField();
        textField.setRequired(required);
        textField.setNullRepresentation("");
        textField.setResponsive(true);
        textField.setWidth("100%");
        textField.setMaxLength(maxLength);
        return textField;
    }

    public static TextArea createTextArea(String label, boolean required) {
        TextArea textArea = new TextArea(label);
        textArea.setRequired(required);
        textArea.setNullRepresentation("");
        return textArea;
    }

    public static TextArea createTextArea(String label, boolean required, int maxLength) {
        TextArea textArea = new TextArea(label);
        textArea.setRequired(required);
        textArea.setNullRepresentation("");
        textArea.setMaxLength(maxLength);
        return textArea;
    }

    public static void showMessageDialog(String info) {
        CommonUIUtil.showMessageDialog(info, new ConfirmDialog.Listener(){
            private static final long serialVersionUID = 1L;

            public void onClose(ConfirmDialog dialog) {
            }
        });
    }

    public static void showMessageDialog(String info, ConfirmDialog.Listener listener) {
        ConfirmDialog d = ConfirmDialog.show((UI)UI.getCurrent(), (String)ConsoleMessages.getString("UIUtil.5"), (String)info, (String)ConsoleMessages.getString("UIUtil.6"), (String)"", (ConfirmDialog.Listener)listener);
        d.setClosable(false);
        Button cancelButton = d.getCancelButton();
        cancelButton.setVisible(false);
        Button okButton = d.getOkButton();
        if (okButton != null) {
            okButton.setResponsive(true);
            okButton.addStyleName("color-background-button");
            okButton.addStyleName("no-box-shadow");
        }
    }

    public static HorizontalLayout createViewNameSection(String viewName) {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(false);
        layout.addStyleName("navigation-layout-minus-one-top");
        Label label = new Label(viewName);
        layout.addComponent((Component)label);
        layout.setComponentAlignment((Component)label, Alignment.MIDDLE_CENTER);
        return layout;
    }

    public static Component createNavigationLayoutZeroTop(String viewName) {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(false);
        layout.addStyleName("navigation-layout-zero-top");
        Label label = new Label(viewName);
        layout.addComponent((Component)label);
        layout.setComponentAlignment((Component)label, Alignment.MIDDLE_CENTER);
        return layout;
    }

    public static ColorPicker createColorPickerComponent(final String cssStyleButtonColor, final String cssStyleTextColor) {
        ColorPicker textColor = new ColorPicker(){

            protected void showPopup(boolean open) {
                if (open) {
                    CommonUIUtil.setVisibleGlassPane(true);
                }
                super.showPopup(open);
            }

            public void windowClose(Window.CloseEvent e) {
                super.windowClose(e);
                CommonUIUtil.setVisibleGlassPane(false);
            }
        };
        textColor.addColorChangeListener(new ColorChangeListener(){

            public void colorChanged(ColorChangeEvent event) {
                CommonUIUtil.setColorPickerBackground(cssStyleButtonColor, event.getColor().getCSS());
                CommonUIUtil.setColorPickerBackground(cssStyleTextColor, event.getColor().getCSS());
            }
        });
        textColor.addStyleName(cssStyleButtonColor);
        return textColor;
    }

    public static void setColorPickerBackground(String cssStyleName, String css) {
        Page.Styles styles = Page.getCurrent().getStyles();
        styles.add("." + cssStyleName + " { background:" + css + " !important; }");
    }

    public static ColorPicker createTextColorPickerComponent(final String cssStyleName) {
        ColorPicker textColor = new ColorPicker("Color"){

            protected void showPopup(boolean open) {
                if (open) {
                    CommonUIUtil.setVisibleGlassPane(true);
                }
                super.showPopup(open);
            }

            public void windowClose(Window.CloseEvent e) {
                super.windowClose(e);
                CommonUIUtil.setVisibleGlassPane(false);
            }
        };
        textColor.addColorChangeListener(new ColorChangeListener(){

            public void colorChanged(ColorChangeEvent event) {
                CommonUIUtil.setTextColorPickerBackground(cssStyleName, event.getColor().getCSS());
            }
        });
        textColor.addStyleName(cssStyleName);
        return textColor;
    }

    public static void setVisibleGlassPane(boolean visible) {
        if (visible) {
            JavaScript.getCurrent().execute("var body = window.document.body; var div=document.createElement('DIV'); div.id = 'glasspane'; body.appendChild(div);div.style.zIndex= '2000';div.style.background = 'rgba(0, 0, 0, 0.4)';div.style.top = '0';div.style.right = '0';div.style.bottom = '0';div.style.left = '0';div.style.position = 'absolute';div.style.animation = '0.2s lumo-overlay-backdrop-enter both';");
        } else {
            JavaScript.getCurrent().execute(" var div=document.getElementById('glasspane');document.body.removeChild(div);");
        }
    }

    public static void setTextColorPickerBackground(String cssStyleName, String css) {
        Page.Styles styles = Page.getCurrent().getStyles();
        styles.add("." + cssStyleName + " .v-button-wrap .v-button-caption { color: " + css + " !important; margin: -28px; font-size: 12px; display: block;}");
    }

    public static void setDefaultButtonColor(String cssButtonColor, String cssTextColor) {
        CommonUIUtil.setColorPickerBackground(cssButtonColor, new Color(-1).getCSS().toString());
        CommonUIUtil.setColorPickerBackground(cssTextColor, new Color(-1).getCSS().toString());
        CommonUIUtil.setTextColorPickerBackground(cssTextColor, new Color(-16777216).getCSS().toString());
    }

    public static Color setButtonColorCode(Integer buttonColorCode, String cssStyleName) {
        Color color = buttonColorCode != null ? new Color(buttonColorCode.intValue()) : new Color(-1);
        CommonUIUtil.setColorPickerBackground(cssStyleName, color.getCSS().toString());
        return color;
    }

    public static Color setTextColorCodeWithButtonColor(Integer buttonColorCode, Integer textColorCode, String cssStyleName) {
        Color color = buttonColorCode != null ? new Color(buttonColorCode.intValue()) : new Color(-1);
        CommonUIUtil.setColorPickerBackground(cssStyleName, color.getCSS().toString());
        Color colorText = textColorCode != null ? new Color(textColorCode.intValue()) : new Color(-16777216);
        CommonUIUtil.setTextColorPickerBackground(cssStyleName, colorText.getCSS().toString());
        return colorText;
    }

    public static FileResource headerLogo(boolean showSmallLogo) {
        String logoName = "siiopa-console-logo.png";
        if (CloudResourceCache.get().isMenugreat()) {
            logoName = LOGO_NAME_PNG;
        }
        return CommonUIUtil.getImage(logoName);
    }

    public static FileResource getImage(String logoName) {
        String path = VaadinService.getCurrent().getBaseDirectory().getAbsolutePath() + "/WEB-INF/resources/images/" + logoName;
        FileResource resource = new FileResource(new File(path));
        return resource;
    }

    public static FileResource getIconResource(String iconName) {
        String path = VaadinService.getCurrent().getBaseDirectory().getAbsolutePath() + "/VAADIN/themes/orocloudtheme/img/" + iconName;
        FileResource resource = new FileResource(new File(path));
        return resource;
    }

    public static com.vaadin.ui.Image headerLogoLabel() {
        return CommonUIUtil.headerLogoLabel(false);
    }

    public static com.vaadin.ui.Image headerLogoLabel(boolean showSmallLogo) {
        com.vaadin.ui.Image logo = new com.vaadin.ui.Image(null, (Resource)CommonUIUtil.headerLogo(showSmallLogo));
        logo.setHeight("30px");
        logo.addStyleName("console-logo");
        return logo;
    }

    public static BufferedImage getBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExternalResource getImageIcon(Image img) {
        if (img == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ExternalResource eResource;
            BufferedImage bufferedImage = CommonUIUtil.getBufferedImage(img);
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            byte[] bdata = baos.toByteArray();
            String x = Base64.getEncoder().encodeToString(bdata);
            ExternalResource externalResource = eResource = new ExternalResource("data:image/png;base64," + x);
            return externalResource;
        }
        catch (IOException e) {
            PosLog.error(CommonUIUtil.class, (String)e.getMessage());
            return null;
        }
    }

    public static HorizontalLayout requiredHorizontalLayout(String stringCaption, boolean spacingEnabled) {
        HorizontalLayout layout = new HorizontalLayout();
        layout.addStyleName("custom-horizontal-required");
        layout.setCaption(stringCaption);
        layout.setSpacing(spacingEnabled);
        return layout;
    }

    public static Component createLogoWithConsoleTitle() {
        return CommonUIUtil.createLogoWithTitle("", "");
    }

    public static Component createLogoWithConsoleTitleVertically() {
        if (CloudResourceCache.get().isMenugreat()) {
            return CommonUIUtil.createLogoWithTitleVertically(OROWORKSPACE);
        }
        return CommonUIUtil.createLogoWithTitleVertically("");
    }

    public static Component createLogoWithOroWorkspaceTitleHorizontally() {
        if (CloudResourceCache.get().isMenugreat()) {
            return CommonUIUtil.createLogoWithOrocubeWorkspaceTitleHorizontally("");
        }
        return CommonUIUtil.createLogoWithOrocubeWorkspaceTitleHorizontally("");
    }

    private static Component createLogoWithOrocubeWorkspaceTitleHorizontally(String title) {
        HorizontalLayout headerLayout = new HorizontalLayout();
        headerLayout.setStyleName("login-form-header-layout");
        com.vaadin.ui.Image image = CommonUIUtil.headerLogoLabel();
        if (!CloudResourceCache.get().isMenugreat()) {
            image.setWidth("90px");
        }
        Label label = new Label(title);
        label.addStyleName("cloud_logo_title");
        headerLayout.addComponents(new Component[]{image, label});
        headerLayout.setExpandRatio((Component)label, 1.0f);
        return headerLayout;
    }

    public static Component createLogoWithAdminTitleVertically() {
        return CommonUIUtil.createLogoWithTitleVertically("admin");
    }

    public static Component createLogoWithOrderMgmtTitle() {
        return CommonUIUtil.createLogoWithTitleVertically(ORDER_MANAGER);
    }

    public static Component createLogoWithResellerTitle() {
        return CommonUIUtil.createLogoWithTitleVertically(RESELLER);
    }

    public static Component createSmallLogoWithConsoleTitleAndSize() {
        if (CloudResourceCache.get().isMenugreat()) {
            return CommonUIUtil.createLogo("", "18px", true);
        }
        return CommonUIUtil.createLogo("", "16px", false);
    }

    public static Component createLogoWithConsoleTitleAndSize() {
        if (CloudResourceCache.get().isMenugreat()) {
            return CommonUIUtil.createLogoWithTitle("", "24px");
        }
        return CommonUIUtil.createLogoWithTitle("", "16px");
    }

    public static Component createLogoWithAdminTitleAndSize() {
        return CommonUIUtil.createLogoWithTitle("", "16px");
    }

    public static Component createLogoWithResellerTitleAndSize() {
        return CommonUIUtil.createLogoWithTitle(RESELLER, "18px");
    }

    public static Component createLogoWithOrderMgmnTitleAndSize() {
        return CommonUIUtil.createLogoWithTitle(ORDER_MANAGER, "18px");
    }

    private static Component createLogoWithTitle(String title, String height) {
        return CommonUIUtil.createLogo(title, height, false);
    }

    private static Component createLogo(String title, String height, boolean showSmallLogo) {
        HorizontalLayout logoLayout = new HorizontalLayout();
        logoLayout.addStyleName("login-form-header-layout");
        com.vaadin.ui.Image image = CommonUIUtil.headerLogoLabel(showSmallLogo);
        Label label = new Label(title);
        if (!StringUtils.isEmpty((CharSequence)height)) {
            image.setWidthUndefined();
            image.setHeight(height);
            if (!showSmallLogo) {
                label.addStyleName("cloud_logo_title");
            }
        } else if (!showSmallLogo) {
            label.addStyleName("cloud_logo_title");
        }
        if (StringUtils.isBlank((CharSequence)title)) {
            label.setHeight("60%");
            logoLayout.setHeight("100%");
        }
        logoLayout.addComponents(new Component[]{image, label});
        return logoLayout;
    }

    public static Component createLogoWithTitleVertically(String title) {
        VerticalLayout headerLayout = new VerticalLayout();
        com.vaadin.ui.Image image = CommonUIUtil.headerLogoLabel();
        image.removeStyleName("v-margin-top");
        image.removeStyleName("v-margin-bottom");
        Label label = new Label(title);
        label.setWidthUndefined();
        label.setStyleName("cloud_logo_title");
        headerLayout.addComponents(new Component[]{image, label});
        headerLayout.setComponentAlignment((Component)image, Alignment.MIDDLE_CENTER);
        headerLayout.setComponentAlignment((Component)label, Alignment.MIDDLE_CENTER);
        label.setVisible(StringUtils.isNotBlank((CharSequence)title));
        return headerLayout;
    }

    public static String getTextWithBracket(String text) {
        return " (" + text + ")";
    }

    public static void makeEnableIfEditableOnCloud(AbstractComponent ... components) {
    }

    public static void makeVisibleIfEditableOnCloud(AbstractComponent ... components) {
    }

    public static Resource getCreditCardIcon(String brand) {
        switch (brand) {
            case "Visa": {
                return FontAwesome.CC_VISA;
            }
            case "American Express": {
                return FontAwesome.CC_AMEX;
            }
            case "MasterCard": {
                return FontAwesome.CC_MASTERCARD;
            }
            case "Discover": {
                return FontAwesome.CC_DISCOVER;
            }
            case "Diners Club": {
                return FontAwesome.CC_DINERS_CLUB;
            }
            case "JCB": {
                return FontAwesome.CC_JCB;
            }
            case "UnionPay": {
                return FontAwesome.CREDIT_CARD;
            }
        }
        return FontAwesome.CREDIT_CARD;
    }

    public static HorizontalLayout createFooter() {
        return CommonUIUtil.createFooter(null);
    }

    public static HorizontalLayout createFooter(CssLayout footerNotificationLayout) {
        HorizontalLayout footer = new HorizontalLayout();
        footer.setWidth("100%");
        footer.setHeight("40px");
        footer.setMargin(false);
        if (footerNotificationLayout != null) {
            footer.addComponent((Component)footerNotificationLayout);
        }
        Label lblCopyright = new Label();
        footer.addComponent((Component)lblCopyright);
        Date now = new Date();
        SimpleDateFormat yearFormatter = new SimpleDateFormat("YYYY");
        String currentYear = yearFormatter.format(now);
        lblCopyright.setValue("Copyright \u00a9" + currentYear + ", MEDLOGICS. Version " + CloudContext.APP_VERSION);
        lblCopyright.setWidthUndefined();
        lblCopyright.addStyleName("footer-copyright");
        footer.setComponentAlignment((Component)lblCopyright, Alignment.MIDDLE_LEFT);
        footer.setStyleName("footer-layout");
        footer.setExpandRatio((Component)lblCopyright, 1.0f);
        footer.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> CommonUIUtil.doOpenChangelog());
        return footer;
    }

    private static void doOpenChangelog() {
        try {
            TextPreviewDialog previewDialog = new TextPreviewDialog();
            previewDialog.openFullScreen();
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
        }
    }

    public static VerticalLayout createDivider() {
        VerticalLayout vDivider = new VerticalLayout();
        vDivider.setSpacing(false);
        vDivider.setMargin(false);
        vDivider.setWidth(2.0f, Sizeable.Unit.PIXELS);
        vDivider.addStyleName("left-divider-bar");
        return vDivider;
    }

    public static HorizontalLayout createHorizontalDivider() {
        HorizontalLayout hDivider = new HorizontalLayout();
        hDivider.setSpacing(false);
        hDivider.setMargin(true);
        hDivider.setWidth(85.0f, Sizeable.Unit.PERCENTAGE);
        hDivider.addStyleName("horizontal-divider-bar");
        return hDivider;
    }

    public static Component getSearchContainer(Component component) {
        return CommonUIUtil.getFieldSetContainer("Search", component);
    }

    public static Component getFieldSetContainer(String legendText, Component component) {
        final Panel panel = new Panel(component);
        panel.addStyleName("search-filter-panel search-filter-panel-open");
        panel.setCaption("Filter");
        StackPanel stackPanel = StackPanel.extend((Panel)panel);
        stackPanel.addToggleListener(new StackPanel.ToggleListener(){

            public void toggleClick(StackPanel source) {
                boolean open = source.isOpen();
                if (open) {
                    panel.removeStyleName("search-filter-panel-close");
                    panel.addStyleName("search-filter-panel-open");
                } else {
                    panel.removeStyleName("search-filter-panel-open");
                    panel.addStyleName("search-filter-panel-close");
                }
            }
        });
        int windowWidth = Page.getCurrent().getBrowserWindowWidth();
        if (windowWidth < 600) {
            stackPanel.close();
            panel.removeStyleName("search-filter-panel-open");
            panel.addStyleName("search-filter-panel-close");
        }
        return panel;
    }

    public static int getCurrentWindowWidth() {
        return UI.getCurrent().getPage().getBrowserWindowWidth();
    }

    public static Component createOrohubLargeLogoTitleHorizontally(String title) {
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setStyleName("login-form-header-layout");
        com.vaadin.ui.Image logo = CommonUIUtil.getOrohubLargeLogo();
        Label label = new Label(title);
        label.addStyleName("cloud_logo_title");
        horizontalLayout.addComponents(new Component[]{logo, label});
        horizontalLayout.setExpandRatio((Component)label, 1.0f);
        return horizontalLayout;
    }

    public static com.vaadin.ui.Image getOrohubLargeLogo() {
        com.vaadin.ui.Image logo = new com.vaadin.ui.Image(null, (Resource)CommonUIUtil.getOrohubLargeLogoResource());
        logo.addStyleName("about_logo");
        return logo;
    }

    private static FileResource getOrohubLargeLogoResource() {
        String logoName = "";
        logoName = CloudResourceCache.get().isMenugreat() ? LOGO_NAME_PNG : "siiopa-console-logo.png";
        FileResource resource = CommonUIUtil.getImage(logoName);
        return resource;
    }

    public static Component createHiddenPasswordField() {
        PasswordField hiddenPasswordField = new PasswordField();
        hiddenPasswordField.setWidth("0px");
        hiddenPasswordField.setHeight("0px");
        hiddenPasswordField.setTabIndex(-1);
        hiddenPasswordField.addStyleName("hidden-field");
        return hiddenPasswordField;
    }

    public static ShortcutListener createEnterShortCutListener() {
        ShortcutListener shortcutListener = new ShortcutListener("Enter key pressed", 13, null){

            public void handleAction(Object sender, Object target) {
                if (target instanceof SiiopaTextField) {
                    ((SiiopaTextField)((Object)target)).enterKeyPressed((Component)target);
                } else if (target instanceof SiiopaCombobox) {
                    ((SiiopaCombobox)((Object)target)).enterKeyPressed((Component)target);
                }
            }
        };
        return shortcutListener;
    }

    public static Upload createImportButton() {
        Upload btnSelectfileToImport = new Upload(null, new Upload.Receiver(){

            public OutputStream receiveUpload(String filename, String mimeType) {
                try {
                    if (StringUtils.isEmpty((CharSequence)filename)) {
                        throw new RuntimeException(ConsoleMessages.getString("MenuItemCrudView.31"));
                    }
                    ServletContext context = VaadinServlet.getCurrent().getServletContext();
                    File file = new File(context.getRealPath("/WEB-INF/../") + filename);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    return new FileOutputStream(file);
                }
                catch (Exception e) {
                    CloudNotification.showErrorMessageDialog(e.getMessage(), e);
                    return null;
                }
            }
        });
        btnSelectfileToImport.addStyleName("color-background-button");
        btnSelectfileToImport.setImmediate(true);
        return btnSelectfileToImport;
    }

    public static Component createVerticalSpace() {
        Label verticalSpace = new Label();
        verticalSpace.addStyleName("verticalSpaceHeight");
        return verticalSpace;
    }
}

