/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.report.model.PaymentReceivedReportData;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;

public class PaymentReceivedReportGrid
extends FooterSupportedBeanGrid<PaymentReceivedReportData> {
    private Grid.FooterCell amountDisplayCell;
    private boolean isShowOnlyDueCollection;

    public PaymentReceivedReportGrid() {
        this(false);
    }

    public PaymentReceivedReportGrid(boolean isShowOnlyDueCollection) {
        this.isShowOnlyDueCollection = isShowOnlyDueCollection;
        this.initColumn();
    }

    private void initColumn() {
        if (this.isShowOnlyDueCollection) {
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.6"), "transactionTimeDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.4"), "ticketId", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.5"), "orderDateDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.3"), "paymentTypeStringDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("CreditCardReportGrid.10"), "amountDisplay", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        } else {
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.0"), "userDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.5"), "orderDateDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.6"), "transactionTimeDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.2"), PosTransaction.PROP_ID, String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.4"), "ticketId", String.class);
            this.addColumn(ConsoleMessages.getString("PaymentReceivedReportGrid.3"), "paymentTypeStringDisplay", String.class);
            this.addColumn(ConsoleMessages.getString("CreditCardReportGrid.10"), "amountDisplay", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        }
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
        if (this.isShowOnlyDueCollection) {
            this.mergeAndshowTotal("transactionTimeDisplay", "ticketId", "orderDateDisplay", "paymentTypeStringDisplay");
        } else {
            this.mergeAndshowTotal("userDisplay", "orderDateDisplay", "transactionTimeDisplay", PosTransaction.PROP_ID, "ticketId", "paymentTypeStringDisplay");
        }
        this.amountDisplayCell = this.createSummaryCell("amountDisplay");
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PaymentReceivedReportData.class;
    }

    public void updateView(double amountDisplay) {
        this.updateCellValue(this.amountDisplayCell, amountDisplay);
    }

    @Override
    public void clearFooterCell() {
        this.updateCellValue(this.amountDisplayCell, 0.0);
    }
}

