/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.model.PaymentReceivedReportData;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTypeableCombobox;
import com.orocube.siiopa.cloud.client.curd.grid.PaymentReceivedReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class PaymentReceivedReportView
extends ReportView {
    public static final String VIEW_NAME = ConsoleMessages.getString("PaymentReceivedReportView.1");
    public static final String DUE_COLLECTION_VIEW_NAME = "Due collection report";
    private OutletCombobox cbOutlet;
    private SiiopaCombobox cbEmployee;
    private CheckBox chkShowDueCollection;
    private VerticalLayout gridLayout;
    private List<PaymentReceivedReportData> transactions;
    private Property.ValueChangeListener employeeValueChangeListener;
    private String selectedOutletId;
    private PaymentReceivedReportGrid paymentReceivedReportGrid;
    private boolean isShowOnlyDueCollection;

    public PaymentReceivedReportView() {
    }

    public PaymentReceivedReportView(boolean isShowOnlyDueCollection) {
        this.isShowOnlyDueCollection = isShowOnlyDueCollection;
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                PaymentReceivedReportView.this.updateView();
            }
        };
        this.cbEmployee = new SiiopaTypeableCombobox();
        this.cbEmployee.setNullSelectionAllowed(false);
        this.cbEmployee.addItem(POSConstants.ALL);
        this.employeeValueChangeListener = (Property.ValueChangeListener & Serializable)event -> this.updateView();
        this.cbEmployee.select(POSConstants.ALL);
        this.cbEmployee.addValueChangeListener(this.employeeValueChangeListener);
        this.chkShowDueCollection = new CheckBox(ConsoleMessages.getString("PaymentReceivedReportView.3"));
        this.chkShowDueCollection.setValue((Object)Boolean.FALSE);
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        this.addDateFilters(topLayout);
        if (!this.isShowOnlyDueCollection) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout(POSConstants.EMPLOYEE, (Component)this.cbEmployee));
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout("", (Component)this.chkShowDueCollection));
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(this.isShowOnlyDueCollection ? DUE_COLLECTION_VIEW_NAME : VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
        this.cbEmployee.addItems(UserDAO.getInstance().getUserByOutletId(this.cbOutlet.getSelectedOrDefaultOutlet().getId()));
    }

    protected void doClear() {
        this.cbOutlet.setValue(POSConstants.ALL);
        this.cbEmployee.setValue(POSConstants.ALL);
        this.chkShowDueCollection.setValue((Object)Boolean.FALSE);
        this.clearDateFields();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Outlet outlet = this.cbOutlet.getSelectedOrDefaultOutlet();
        User user = null;
        Object employee = this.cbEmployee.getValue();
        if (employee != null && !employee.equals(POSConstants.ALL)) {
            user = (User)employee;
        }
        boolean showDueCollection = this.isShowOnlyDueCollection ? this.isShowOnlyDueCollection : (Boolean)this.chkShowDueCollection.getValue();
        this.transactions = PosTransactionDAO.getInstance().findPayments(startTime, endTime, user, outlet, showDueCollection);
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        User user = null;
        Object employee = this.cbEmployee.getValue();
        if (employee != null && !employee.equals(POSConstants.ALL)) {
            user = (User)employee;
        }
        StreamResource streamResource = null;
        try {
            boolean isShowDueCollection = this.isShowOnlyDueCollection ? this.isShowOnlyDueCollection : (Boolean)this.chkShowDueCollection.getValue();
            JasperPrint jasperPrint = CommonCloudReportService.getPaymentReceivedReportPrint(startTime, endTime, user, outlet, this.transactions, isShowDueCollection);
            streamResource = CommonCloudReportService.getReportStream(this.isShowOnlyDueCollection ? DUE_COLLECTION_VIEW_NAME : VIEW_NAME, jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.paymentReceivedReportGrid = new PaymentReceivedReportGrid(this.isShowOnlyDueCollection);
        return this.paymentReceivedReportGrid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            Outlet outlet = null;
            if (this.cbOutlet.getValue() instanceof Outlet) {
                outlet = (Outlet)this.cbOutlet.getValue();
            }
            if (outlet != null && this.selectedOutletId != null && !this.selectedOutletId.equals(outlet.getId())) {
                this.cbEmployee.removeValueChangeListener(this.employeeValueChangeListener);
                this.cbEmployee.removeAllItems();
                this.cbEmployee.addItem(POSConstants.ALL);
                this.cbEmployee.addItems(UserDAO.getInstance().getUserByOutletId(((Outlet)this.cbOutlet.getValue()).getId()));
                this.cbEmployee.select(POSConstants.ALL);
                this.cbEmployee.addValueChangeListener(this.employeeValueChangeListener);
            }
            try {
                this.doSearch();
                if (outlet != null) {
                    this.selectedOutletId = outlet.getId();
                }
            }
            catch (Exception e2) {
                CloudNotification.showErrorMessageDialog(e2.getMessage());
                this.gridLayout.setVisible(false);
                return;
            }
            if (this.transactions == null || this.transactions.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage(ConsoleMessages.getString("OpenTicketSummaryReportView.16"));
                return;
            }
            this.paymentReceivedReportGrid.setItems(this.transactions);
            this.paymentReceivedReportGrid.updateView(this.transactions.stream().mapToDouble(e -> e.getAmount()).sum());
            this.gridLayout.setVisible(true);
        }
        catch (Exception e3) {
            CloudNotification.showErrorMessageDialog(e3.getMessage(), e3);
        }
    }
}

