/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.view;

import com.floreantpos.PosLog;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.SiiopaDateField;
import com.vaadin.data.Property;
import com.vaadin.event.ShortcutListener;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class DateSelectionView
extends HorizontalLayout {
    private SiiopaDateField dfFromDate;
    private SiiopaDateField dfToDate;
    private int dateRangeMonth;
    private int dateRangeDays;
    private boolean isAllowFutureDate;
    private DateChangeListener dateChangeListener;

    public DateSelectionView() {
        this(0, 1, false, false);
    }

    public DateSelectionView(int dateRangeMonth) {
        this(dateRangeMonth, false);
    }

    public DateSelectionView(int dateRangeMonth, boolean isAllowFutureDate) {
        this(dateRangeMonth, 0, isAllowFutureDate);
    }

    public DateSelectionView(int dateRangeMonth, int dateRangeDays, boolean isAllowFutureDate) {
        this(dateRangeMonth, dateRangeDays, isAllowFutureDate, false);
    }

    public DateSelectionView(int dateRangeMonth, int dateRangeDays, boolean isAllowFutureDate, boolean isShowSingleDate) {
        this.dateRangeMonth = dateRangeMonth;
        this.dateRangeDays = dateRangeDays;
        this.isAllowFutureDate = isAllowFutureDate;
        this.setMargin(false);
        this.setSpacing(false);
        this.dfFromDate = new SiiopaDateField();
        this.dfToDate = new SiiopaDateField();
        this.dfFromDate.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateDataFromReportView());
        this.dfToDate.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateDataFromReportView());
        if (!isShowSingleDate) {
            this.addComponent((Component)CustomLayoutComponent.createSpacing());
            this.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("VoidItemReportView.3"), (Component)this.dfFromDate));
            this.addComponent((Component)CustomLayoutComponent.createSpacing());
            this.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("VoidItemReportView.4"), (Component)this.dfToDate));
        } else {
            this.addComponent((Component)CustomLayoutComponent.createSpacing());
            this.addComponent((Component)CustomLayoutComponent.createLayout("Date", (Component)this.dfFromDate));
        }
        this.clearDateFields();
    }

    public void updateDataFromReportView() {
        if (this.dateChangeListener != null) {
            this.dateChangeListener.updateData();
        }
    }

    public void addEnterListener(ShortcutListener enterKeyListener) {
        this.dfFromDate.addShortcutListener(enterKeyListener);
        this.dfToDate.addShortcutListener(enterKeyListener);
    }

    public void clearDateFields() {
        Date serverTimestamp = StoreDAO.getServerTimestamp();
        Calendar c = Calendar.getInstance();
        c.setTime(serverTimestamp);
        if (this.dateRangeMonth > 0) {
            c.add(2, -this.dateRangeMonth);
        }
        if (this.dateRangeDays > 0) {
            c.add(5, -(this.dateRangeDays - 1));
        }
        Date startOfDate = DateUtil.convertServerTimeToBrowserTime((Date)c.getTime());
        Date browserTime = DateUtil.convertServerTimeToBrowserTime((Date)serverTimestamp);
        this.dfFromDate.setValue(startOfDate);
        this.dfToDate.setValue(browserTime);
        if (!this.isAllowFutureDate) {
            this.fromDateRangeEnd(browserTime);
            this.dfToDate.setRangeEnd(browserTime);
        }
    }

    public void fromDateRangeEnd(Date date) {
        this.dfFromDate.setRangeEnd(date);
    }

    public void toDateRangeEnd(Date date) {
        this.dfToDate.setValue(date);
    }

    public Date getFromDate() {
        if (this.dfFromDate.getValue() == null) {
            return null;
        }
        return DateUtil.convertDateToBrowserTime((Date)DateUtil.startOfDay((Date)((Date)this.dfFromDate.getValue())));
    }

    public Date getToDate() {
        if (this.dfToDate.getValue() == null) {
            return null;
        }
        return DateUtil.convertDateToBrowserTime((Date)DateUtil.endOfDay((Date)((Date)this.dfToDate.getValue())));
    }

    public void doUpdateUi(int reportType) {
        if (reportType == 1) {
            this.dfFromDate.setResolution(Resolution.MONTH);
            this.dfToDate.setResolution(Resolution.MONTH);
            this.dfFromDate.setDateFormat("MMM yy");
            this.dfToDate.setDateFormat("MMM yy");
        } else if (reportType == 0) {
            this.dfFromDate.setResolution(Resolution.DAY);
            this.dfToDate.setResolution(Resolution.DAY);
            this.dfFromDate.setDateFormat("MMM dd, yy");
            this.dfToDate.setDateFormat("MMM dd, yy");
        }
    }

    public void validateDate() throws Exception {
        Date startTime = (Date)this.dfFromDate.getValue();
        Date endTime = (Date)this.dfToDate.getValue();
        DateUtil.validateDate((Date)startTime, (Date)endTime);
        PosLog.info(((Object)((Object)this)).getClass(), (String)("startTime: " + this.getFromDate() + " ,endTime: " + this.getToDate()));
    }

    public boolean isTargetMatch(Object target) {
        return target == this.dfFromDate || target == this.dfToDate;
    }

    public void setDfFromDateWidth(String width) {
        this.dfFromDate.setWidth(width);
    }

    public void setDfToDateWidth(String width) {
        this.dfToDate.setWidth(width);
    }

    public Date getFromDateWithoutFormat() {
        return (Date)this.dfFromDate.getValue();
    }

    public Date getToDateWithoutFormat() {
        return (Date)this.dfToDate.getValue();
    }

    public void setDateChangeListener(DateChangeListener dateChangeListener) {
        this.dateChangeListener = dateChangeListener;
    }

    public static interface DateChangeListener {
        public void updateData();
    }
}

