/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.ExpenseTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PurchaseTransaction;
import com.floreantpos.model.RefundTransaction;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class ProjectReportGrid
extends FooterSupportedBeanGrid<PosTransaction> {
    private Grid.FooterCell totalAmountCell;

    public ProjectReportGrid() {
        this.addColumn("Time", "dateDisplayString", String.class);
        this.addColumn("Type", "classTypeDislay", String.class);
        this.addColumn("Project", "projectNameDisplay", String.class);
        this.addColumn("Description", "projectDescription", String.class);
        this.addColumn("Amount", "amountWithoutRoundingAmount", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.showSummaryRow("dateDisplayString", "classTypeDislay", "projectNameDisplay", "projectDescription");
        this.totalAmountCell = this.createSummaryCell("amountWithoutRoundingAmount");
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
    }

    @Override
    public void setItems(Collection<PosTransaction> items) {
        super.setItems(items);
        this.updateAccountingCellValue(this.totalAmountCell, ProjectReportGrid.calculateTotalAmount(items));
    }

    public static double calculateTotalAmount(Collection<PosTransaction> items) {
        double totalAmount = 0.0;
        if (items != null && items.size() > 0) {
            for (PosTransaction posTransaction : items) {
                if (posTransaction instanceof PurchaseTransaction || posTransaction instanceof ExpenseTransaction || posTransaction instanceof RefundTransaction) {
                    totalAmount -= posTransaction.getAmountWithoutRoundingAmount();
                    continue;
                }
                totalAmount += posTransaction.getAmountWithoutRoundingAmount();
            }
        }
        return totalAmount;
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PosTransaction.class;
    }

    @Override
    public void clearFooterCell() {
        this.updateCellValue(this.totalAmountCell, 0.0);
    }
}

