/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.util.DataProvider;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.AccountsPayableReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class AccountsPayableReportView
extends ReportView {
    public static final String VIEW_NAME = "Accounts payable report";
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private List<PurchaseOrder> purchaseOrders;
    private AccountsPayableReportGrid accountsPayableReportGrid;
    private SiiopaTextField tfPurchaseOrderNo;
    private SiiopaCombobox cbVendor;

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                AccountsPayableReportView.this.updateView();
            }
        };
        this.tfPurchaseOrderNo = new SiiopaTextField();
        this.cbVendor = new SiiopaCombobox();
        this.cbVendor.addItems(InventoryVendorDAO.getInstance().findAll());
        this.cbVendor.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("P.O No", (Component)this.tfPurchaseOrderNo));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Vendor", (Component)this.cbVendor));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    protected void doClear() {
        this.clearDateFields();
        this.tfPurchaseOrderNo.setValue("");
        this.cbVendor.setValue(null);
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        String poNo = this.tfPurchaseOrderNo.getValue();
        InventoryVendor vendor = null;
        if (this.cbVendor.getValue() instanceof InventoryVendor) {
            vendor = (InventoryVendor)this.cbVendor.getValue();
        }
        this.purchaseOrders = new ArrayList<PurchaseOrder>();
        List findPurchaseOrderDue = PurchaseOrderDAO.getInstance().findAccountsPayablePO(outlet.getId(), poNo, vendor, startTime, endTime);
        this.purchaseOrders.addAll(findPurchaseOrderDue);
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        StreamResource streamResource = null;
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getAccountPayableDueReportPrint(startTime, endTime, outlet, this.purchaseOrders);
            streamResource = CommonCloudReportService.getReportStream("account_payable_due_report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.accountsPayableReportGrid = new AccountsPayableReportGrid();
        return this.accountsPayableReportGrid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.accountsPayableReportGrid.clearFooterCell();
            this.doSearch();
            if (this.purchaseOrders == null || this.purchaseOrders.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage(ConsoleMessages.getString("OpenTicketSummaryReportView.16"));
                return;
            }
            this.accountsPayableReportGrid.setItems((Collection<PurchaseOrder>)this.purchaseOrders);
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }
}

