/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Project;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.AverageCostReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;

public class AverageCostReportView
extends ReportView {
    public static final String VIEW_NAME = "Average cost report";
    private VerticalLayout gridLayout;
    private List<InventoryTransaction> transactions;
    private AverageCostReportGrid grid;
    private SiiopaTextField tfNameAndSku;
    private SiiopaCombobox cbGroup;
    private SiiopaCombobox cbCategory;
    private SiiopaCombobox cbProject;

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.tfNameAndSku = new SiiopaTextField();
        this.cbGroup = new SiiopaCombobox();
        this.cbGroup.setWidth("200px");
        this.cbGroup.addItems(MenuGroupDAO.getInstance().findAll());
        this.cbGroup.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbCategory = new SiiopaCombobox();
        this.cbCategory.setWidth("200px");
        this.cbCategory.addItems(MenuCategoryDAO.getInstance().findAll());
        this.cbCategory.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbProject = new SiiopaCombobox();
        this.cbProject.setWidth("200px");
        this.cbProject.addItems(ProjectDAO.getInstance().findAll());
        this.cbProject.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Name/SKY", (Component)this.tfNameAndSku));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Category", (Component)this.cbCategory));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Group", (Component)this.cbGroup));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
    }

    protected void doClear() {
        this.clearDateFields();
        this.tfNameAndSku.setValue("");
        this.cbCategory.setValue(null);
        this.cbGroup.setValue(null);
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Object selectedCategory = this.cbCategory.getValue();
        MenuCategory category = null;
        if (selectedCategory instanceof MenuCategory) {
            category = (MenuCategory)selectedCategory;
        }
        Object selectedGroup = this.cbGroup.getValue();
        MenuGroup group = null;
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        Object selectedProject = this.cbProject.getValue();
        Project project = null;
        if (selectedProject instanceof Project) {
            project = (Project)selectedProject;
        }
        this.transactions = InventoryTransactionDAO.getInstance().findTransactionsForAvgCosting(group, startTime, endTime);
        HashMap<String, MenuItem> itemMap = new HashMap<String, MenuItem>();
        for (InventoryTransaction trans : this.transactions) {
            MenuItem menuItem = trans.getMenuItem();
            if (itemMap.get(menuItem.getId()) != null) continue;
            MenuItemDAO.getInstance().initializeUnits(menuItem);
            itemMap.put(menuItem.getId(), menuItem);
        }
        Date date = startTime;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        date = c.getTime();
        Date endOfPreviousMonth = DateUtil.endOfMonth((Date)date);
        Map openingBalanceMap = InventoryTransactionDAO.getInstance().populateOpeningBalance(itemMap, endOfPreviousMonth, DateUtil.endOfDay((Date)startTime));
        if (this.transactions != null && this.transactions.size() > 0) {
            for (InventoryTransaction trans : this.transactions) {
                InventoryTransaction openingBalance = (InventoryTransaction)openingBalanceMap.get(trans.getMenuItem().getId());
                if (openingBalance == null) continue;
                Double avgCost = openingBalance.getQuantity() == 0.0 ? 0.0 : openingBalance.getTotal() / openingBalance.getQuantity();
                trans.setOpeningQty(openingBalance.getQuantity().doubleValue());
                trans.setOpeningCost(avgCost.doubleValue());
                trans.setOpeningTotalCost(openingBalance.getTotal().doubleValue());
            }
        }
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Object selectedCategory = this.cbCategory.getValue();
        MenuCategory category = null;
        if (selectedCategory instanceof MenuCategory) {
            category = (MenuCategory)selectedCategory;
        }
        Object selectedGroup = this.cbGroup.getValue();
        MenuGroup group = null;
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        StreamResource streamResource = null;
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getInventoryAverageUnitCostReportPrint(startTime, endTime, DataProvider.get().getOutlet(), this.transactions, category, group);
            streamResource = CommonCloudReportService.getReportStream("Inventory-average-unit-cost-report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.grid = new AverageCostReportGrid();
        return this.grid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            this.grid.clearFooterCell();
            if (this.transactions == null || this.transactions.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage("No data found!");
                return;
            }
            this.grid.setItems((Collection<InventoryTransaction>)this.transactions);
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }
}

