/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.EndBalanceTransaction;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PayoutSubReason;
import com.floreantpos.model.Project;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.PayoutSubReasonDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaPayoutReasonCombobox;
import com.orocube.siiopa.cloud.client.SiiopaRecipientCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.ExpenseReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class ExpenseReportView
extends ReportView {
    public static final String VIEW_NAME = "Expense report";
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private List<BalanceUpdateTransaction> balanceUpdateTransactions;
    private ExpenseReportGrid grid;
    private SiiopaCombobox cbStoreOrAccountsManager;
    private SiiopaRecipientCombobox cbRecipient;
    private SiiopaPayoutReasonCombobox cbReason;
    private SiiopaCombobox cbProject;
    private SiiopaCombobox cbSubCategory;
    private boolean isByzlogicsExpense;
    private SiiopaTextField tfBalanceAfterExpense;
    private SiiopaTextField tfCurrentBalance;
    private double balanceAfterExpense;
    private Double totalAmount = 0.0;
    private HorizontalLayout footerLayout;
    private VerticalLayout formLayout;

    public ExpenseReportView() {
        this(false);
    }

    public ExpenseReportView(boolean isByzlogicsExpense) {
        this.isByzlogicsExpense = isByzlogicsExpense;
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                ExpenseReportView.this.updateAccountManagersCombo();
                ExpenseReportView.this.updateView();
            }
        };
        this.cbStoreOrAccountsManager = new SiiopaCombobox();
        this.updateAccountManagersCombo();
        this.cbStoreOrAccountsManager.setWidth("400px");
        this.cbStoreOrAccountsManager.selectFirstComponent();
        this.cbStoreOrAccountsManager.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbRecipient = new SiiopaRecipientCombobox();
        this.cbRecipient.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbReason = new SiiopaPayoutReasonCombobox();
        this.cbReason.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbProject = new SiiopaCombobox();
        List project = ProjectDAO.getInstance().findAll();
        this.cbProject.addItems(project);
        this.cbProject.setWidth("400px");
        this.cbProject.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbSubCategory = new SiiopaCombobox();
        List subCatogry = PayoutSubReasonDAO.getInstance().findAll();
        this.cbSubCategory.addItems(subCatogry);
        this.cbSubCategory.setWidth("400px");
        this.cbSubCategory.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        this.addDateFilters(topLayout);
        if (this.isByzlogicsExpense) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Project", (Component)this.cbProject));
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Recipient", (Component)this.cbRecipient));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(this.isByzlogicsExpense ? "Category" : "Reason", (Component)this.cbReason));
        if (this.isByzlogicsExpense) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sub category", (Component)this.cbSubCategory));
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Accounts manager", (Component)this.cbStoreOrAccountsManager));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.tfBalanceAfterExpense = new SiiopaTextField();
        this.tfBalanceAfterExpense.setWidth("180px");
        this.tfBalanceAfterExpense.setFieldRightAligment();
        this.tfBalanceAfterExpense.setEnabled(false);
        this.tfBalanceAfterExpense.addStyleName("remove-opacity");
        this.tfBalanceAfterExpense.addStyleName("bold-style");
        this.tfCurrentBalance = new SiiopaTextField();
        this.tfCurrentBalance.setWidth("180px");
        this.tfCurrentBalance.setFieldRightAligment();
        this.tfCurrentBalance.setEnabled(false);
        this.tfCurrentBalance.addStyleName("remove-opacity");
        this.tfCurrentBalance.addStyleName("bold-style");
        this.formLayout = new VerticalLayout();
        this.formLayout.addStyleName("bold");
        Label lblBalanceAfterExpense = new Label("Balance after expense:");
        lblBalanceAfterExpense.addStyleName("bold");
        HorizontalLayout row1 = new HorizontalLayout();
        row1.setSpacing(true);
        row1.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        row1.addComponents(new Component[]{lblBalanceAfterExpense, this.tfBalanceAfterExpense});
        Label lblCurrentBalance = new Label("Current balance:");
        lblCurrentBalance.addStyleName("bold");
        HorizontalLayout row2 = new HorizontalLayout();
        row2.addStyleName("margin-top-five");
        row2.setSpacing(true);
        row2.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        row2.addComponents(new Component[]{lblCurrentBalance, this.tfCurrentBalance});
        this.formLayout.addComponents(new Component[]{row1, row2});
        this.formLayout.setComponentAlignment((Component)row1, Alignment.MIDDLE_RIGHT);
        this.formLayout.setComponentAlignment((Component)row2, Alignment.MIDDLE_RIGHT);
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 3.0f);
        this.footerLayout = new HorizontalLayout();
        this.footerLayout.setWidth("100%");
        Label space = new Label();
        this.btnExportPdf.setWidthUndefined();
        space.setWidth("100%");
        this.formLayout.setWidthUndefined();
        this.footerLayout.addComponents(new Component[]{this.btnExportPdf, space, this.formLayout});
        this.footerLayout.setComponentAlignment((Component)this.formLayout, Alignment.MIDDLE_RIGHT);
        this.gridLayout.addComponent((Component)this.footerLayout);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    public void updateAccountManagersCombo() {
        this.cbStoreOrAccountsManager.removeAllItems();
        ArrayList<String> filterList = new ArrayList<String>();
        String outletId = null;
        Object value = this.cbOutlet.getValue();
        outletId = value instanceof Outlet ? ((Outlet)value).getId() : DataProvider.get().getOutletId();
        List accountManagers = UserDAO.getInstance().findAccountsManager(outletId);
        accountManagers.sort((o1, o2) -> o1.getFirstName().compareTo(o2.getFirstName()));
        if (!this.isByzlogicsExpense) {
            filterList.add("Store");
        }
        filterList.addAll(accountManagers);
        this.cbStoreOrAccountsManager.addItems(filterList);
    }

    protected void doClear() {
        this.cbOutlet.setValue(POSConstants.ALL);
        this.cbStoreOrAccountsManager.clear();
        this.clearDateFields();
        this.cbRecipient.clear();
        this.cbReason.clear();
        this.cbSubCategory.clear();
        this.cbProject.clear();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        String accountNo = "";
        Object storeOrAMValue = this.cbStoreOrAccountsManager.getValue();
        if (storeOrAMValue != null) {
            if (storeOrAMValue instanceof String) {
                accountNo = "1";
            } else if (storeOrAMValue instanceof User) {
                User user = (User)storeOrAMValue;
                accountNo = user.getId();
            }
        }
        String recipientId = null;
        Object selectedRecipient = this.cbRecipient.getValue();
        if (selectedRecipient != null && selectedRecipient instanceof PayoutRecepient) {
            PayoutRecepient payoutRecepient = (PayoutRecepient)selectedRecipient;
            recipientId = payoutRecepient.getId();
        }
        String categoryId = null;
        Object selectedReason = this.cbReason.getValue();
        if (selectedReason != null && selectedReason instanceof PayoutReason) {
            PayoutReason payoutReason = (PayoutReason)selectedReason;
            categoryId = payoutReason.getId();
        }
        String projectId = null;
        Object selectedProject = this.cbProject.getValue();
        if (selectedProject != null && selectedProject instanceof Project) {
            Project project = (Project)selectedProject;
            projectId = project.getId();
        }
        String subCategoryId = null;
        Object selectedSubCategory = this.cbSubCategory.getValue();
        if (selectedSubCategory != null && selectedSubCategory instanceof PayoutSubReason) {
            PayoutSubReason subPayoutReason = (PayoutSubReason)selectedSubCategory;
            subCategoryId = subPayoutReason.getId();
        }
        this.balanceUpdateTransactions = BalanceUpdateTransactionDAO.getInstance().loadAccountsManagerPayment(startTime, endTime, accountNo, recipientId, categoryId, projectId, subCategoryId);
        if (this.balanceUpdateTransactions != null && this.balanceUpdateTransactions.size() > 0) {
            this.balanceAfterExpense = this.getBalanceAfterExpense(new ArrayList<BalanceUpdateTransaction>(this.balanceUpdateTransactions));
            for (BalanceUpdateTransaction posTransaction : this.balanceUpdateTransactions) {
                if (posTransaction instanceof BalanceForwardTransaction || posTransaction instanceof EndBalanceTransaction) continue;
                this.totalAmount = this.totalAmount + posTransaction.getExpenseAmountDisplay();
            }
        } else {
            this.balanceAfterExpense = 0.0;
        }
    }

    private double getBalanceAfterExpense(List<BalanceUpdateTransaction> transactions) {
        if (transactions == null || transactions.isEmpty()) {
            return 0.0;
        }
        transactions.sort(Comparator.comparing(BaseBalanceUpdateTransaction::getTransactionTime));
        BalanceUpdateTransaction lastTransaction = transactions.get(transactions.size() - 1);
        return lastTransaction.getBalanceBefore() + lastTransaction.getAmount();
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        StreamResource streamResource = null;
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getExpenseReportReportPrint(startTime, endTime, outlet, this.balanceUpdateTransactions, this.isByzlogicsExpense, this.tfBalanceAfterExpense.isVisible(), this.tfBalanceAfterExpense.getValue(), this.tfCurrentBalance.isVisible(), this.tfCurrentBalance.getValue(), this.totalAmount);
            streamResource = CommonCloudReportService.getReportStream("expense-report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.grid = new ExpenseReportGrid(this.isByzlogicsExpense);
        return this.grid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.totalAmount = 0.0;
            this.doSearch();
            this.grid.clearFooterCell();
            this.grid.setItems(this.balanceUpdateTransactions, this.totalAmount);
            this.gridLayout.setVisible(true);
            this.updateFooter();
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }

    private void updateFooter() {
        Object storeOrAMValue = this.cbStoreOrAccountsManager.getValue();
        if (storeOrAMValue == null) {
            this.formLayout.setVisible(false);
            this.tfBalanceAfterExpense.getParent().setVisible(false);
            this.tfCurrentBalance.getParent().setVisible(false);
            this.footerLayout.setHeight("40px");
            return;
        }
        this.formLayout.setVisible(true);
        if (storeOrAMValue instanceof String) {
            Store store = DataProvider.get().getStore();
            Double cashBalance = store.getCashBalance() == 0.0 ? 0.0 : store.getCashBalance();
            this.tfCurrentBalance.setValue(NumberUtil.formatAmount((Double)cashBalance));
            this.tfCurrentBalance.getParent().setVisible(true);
            this.tfBalanceAfterExpense.getParent().setVisible(false);
            this.footerLayout.setHeight("40px");
            return;
        }
        if (storeOrAMValue instanceof User) {
            User user = (User)storeOrAMValue;
            user = DataProvider.get().getUserById(user.getId(), user.getOutletId());
            double accountsManagerAmount = user.getAccountsManagerAmount() == 0.0 ? 0.0 : user.getAccountsManagerAmount();
            this.tfCurrentBalance.setValue(NumberUtil.formatAmount((Double)accountsManagerAmount));
            this.tfBalanceAfterExpense.getParent().setVisible(true);
            this.tfCurrentBalance.getParent().setVisible(true);
        }
        this.tfBalanceAfterExpense.setValue(NumberUtil.formatAmount((Double)this.balanceAfterExpense));
        this.footerLayout.setHeight("80px");
    }
}

