/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ItemwiseRfReportData;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.ItemwiseRfReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class ItemwiseRfReportView
extends ReportView {
    public static final String VIEW_NAME = ConsoleMessages.getString("ItemwiseRfReportView.0");
    private OutletCombobox cbOutlet;
    private SiiopaTextField tfOrderNo;
    private VerticalLayout gridLayout;
    private List<ItemwiseRfReportData> itemwiseRfReportDatas;
    private ItemwiseRfReportGrid itemwiseRfReportGrid;

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                ItemwiseRfReportView.this.updateView();
            }
        };
        this.tfOrderNo = new SiiopaTextField();
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        this.addDateFilters(topLayout, 0, 1, false);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Order No", (Component)this.tfOrderNo));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.setWidth("100%");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    protected void doClear() {
        this.cbOutlet.setValue(POSConstants.ALL);
        this.clearDateFields();
        this.tfOrderNo.clear();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Outlet outlet = this.cbOutlet.getSelectedOrDefaultOutlet();
        this.itemwiseRfReportDatas = TicketDAO.getInstance().findItemWiseRFReportOrders(outlet.getId(), startTime, endTime, this.tfOrderNo.getValue());
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        StreamResource streamResource = null;
        try {
            this.validateDate();
            Date startTime = this.getFromDate();
            Date endTime = this.getToDate();
            Outlet outlet = null;
            if (this.cbOutlet.getValue() instanceof Outlet) {
                outlet = (Outlet)this.cbOutlet.getValue();
            }
            JasperPrint jasperPrint = CommonCloudReportService.getItemwiseRFReportPrint(startTime, endTime, outlet, this.itemwiseRfReportDatas);
            streamResource = CommonCloudReportService.getReportStream("itemwise_rf_report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (PosException e0) {
            CloudNotification.showErrorMessageDialog(e0.getMessage());
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.itemwiseRfReportGrid = new ItemwiseRfReportGrid();
        return this.itemwiseRfReportGrid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            if (this.itemwiseRfReportDatas == null || this.itemwiseRfReportDatas.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage(ConsoleMessages.getString("OpenTicketSummaryReportView.16"));
                return;
            }
            this.itemwiseRfReportGrid.setItems((Collection<ItemwiseRfReportData>)this.itemwiseRfReportDatas);
            this.gridLayout.setVisible(true);
        }
        catch (PosException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
            this.gridLayout.setVisible(false);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(POSConstants.ERROR_MESSAGE, e);
            this.gridLayout.setVisible(false);
        }
    }
}

