/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.ExpenseTransaction;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Project;
import com.floreantpos.model.PurchaseTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.ProjectReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.hibernate.Session;

public class ProjectReportView
extends ReportView {
    public static final String VIEW_NAME = "Project report";
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private List<PosTransaction> balanceUpdateTransactions;
    private ProjectReportGrid grid;
    private SiiopaCombobox cbProject;
    private SiiopaTextField tfTotalItemSales;
    private SiiopaTextField tfTotalItemSalesPaid;
    private SiiopaTextField tfTotalItemSalesDue;
    private SiiopaTextField tfTotalPurchaseSales;
    private SiiopaTextField tfTotalPurchasePaid;
    private SiiopaTextField tfTotalPurchaseDue;
    private SiiopaTextField tfTotalExpense;
    private Map<String, Double> salesMap = new HashMap<String, Double>();
    private Map<String, Double> purchaseMap = new HashMap<String, Double>();
    private Map<String, Double> expenseMap = new HashMap<String, Double>();

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                ProjectReportView.this.updateView();
            }
        };
        this.cbProject = new SiiopaCombobox();
        List project = ProjectDAO.getInstance().findAll();
        this.cbProject.addItems(project);
        this.cbProject.setWidth("400px");
        this.cbProject.setNullSelectionAllowed(false);
        this.cbProject.selectFirstComponent();
        this.cbProject.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Project", (Component)this.cbProject));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, this.addProjectSummaryLayout(), reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    private Component addProjectSummaryLayout() {
        CssLayout summaryLayout = new CssLayout();
        summaryLayout.addStyleName("margin-bottom-5px");
        this.tfTotalItemSales = this.createTextField();
        this.tfTotalItemSalesPaid = this.createTextField();
        this.tfTotalItemSalesDue = this.createTextField();
        this.tfTotalPurchaseSales = this.createTextField();
        this.tfTotalPurchasePaid = this.createTextField();
        this.tfTotalPurchaseDue = this.createTextField();
        this.tfTotalExpense = this.createTextField();
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales: ", (Component)this.tfTotalItemSales));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales Paid: ", (Component)this.tfTotalItemSalesPaid));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales Due: ", (Component)this.tfTotalItemSalesDue));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Cost: ", (Component)this.tfTotalPurchaseSales));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Cost Paid: ", (Component)this.tfTotalPurchasePaid));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Cost Due: ", (Component)this.tfTotalPurchaseDue));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Expense: ", (Component)this.tfTotalExpense));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        return summaryLayout;
    }

    private SiiopaTextField createTextField() {
        SiiopaTextField textField = new SiiopaTextField();
        textField.setFieldRightAligment();
        textField.setEnabled(false);
        textField.addStyleName("remove-opacity");
        textField.addStyleName("quick-menuitem-txtfield-cost");
        return textField;
    }

    protected void doClear() {
        this.cbOutlet.setValue(POSConstants.ALL);
        this.cbProject.selectFirstComponent();
        this.clearDateFields();
    }

    protected void doSearch() throws Exception {
        this.salesMap.clear();
        this.purchaseMap.clear();
        this.expenseMap.clear();
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Project project = null;
        Object selectedProject = this.cbProject.getValue();
        if (selectedProject != null && selectedProject instanceof Project) {
            project = (Project)selectedProject;
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        this.balanceUpdateTransactions = PosTransactionDAO.getInstance().findProjectTransaction(outlet, startTime, endTime, project);
        double itemSalesPaid = 0.0;
        double purchasePaid = 0.0;
        double expense = 0.0;
        for (PosTransaction posTransaction : this.balanceUpdateTransactions) {
            Double totalAmount;
            String key;
            if (posTransaction instanceof PurchaseTransaction) {
                purchasePaid += posTransaction.getAmountWithoutRoundingAmount();
                key = posTransaction.getPaymentTypeDisplayString();
                totalAmount = this.purchaseMap.get(key);
                totalAmount = totalAmount == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount + posTransaction.getAmountWithoutRoundingAmount());
                this.purchaseMap.put(key, totalAmount);
            }
            if (posTransaction instanceof ExpenseTransaction) {
                expense += posTransaction.getAmountWithoutRoundingAmount();
                key = posTransaction.getPaymentTypeDisplayString();
                totalAmount = this.expenseMap.get(key);
                totalAmount = totalAmount == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount + posTransaction.getAmountWithoutRoundingAmount());
                this.expenseMap.put(key, totalAmount);
            }
            if (posTransaction instanceof CashTransaction || posTransaction instanceof CreditCardTransaction || posTransaction instanceof DebitCardTransaction || posTransaction instanceof CustomPaymentTransaction) {
                itemSalesPaid += posTransaction.getAmountWithoutRoundingAmount();
                key = posTransaction.getPaymentTypeDisplayString();
                totalAmount = this.salesMap.get(key);
                totalAmount = totalAmount == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount + posTransaction.getAmountWithoutRoundingAmount());
                this.salesMap.put(key, totalAmount);
            }
            if (!(posTransaction instanceof RefundTransaction)) continue;
            itemSalesPaid -= posTransaction.getAmountWithoutRoundingAmount();
            key = posTransaction.getPaymentTypeDisplayString();
            String refundKey = key + " refund";
            Double totalAmount2 = this.salesMap.get(refundKey);
            totalAmount2 = totalAmount2 == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount2 + posTransaction.getAmountWithoutRoundingAmount());
            this.salesMap.put(refundKey, totalAmount2 * -1.0);
        }
        try (Session session = GenericDAO.getInstance().createNewSession();){
            session.setDefaultReadOnly(true);
            SalesReportUtil salesReportUtil = new SalesReportUtil(startTime, endTime);
            salesReportUtil.setOutlet(outlet);
            salesReportUtil.setProjectId(project == null ? null : project.getId());
            double ticketItemSales = salesReportUtil.calculateNetSales(session);
            this.tfTotalItemSales.setValue(NumberUtil.formatAmount((Double)ticketItemSales));
            this.tfTotalItemSalesPaid.setValue(NumberUtil.formatAmount((Double)itemSalesPaid));
            this.tfTotalItemSalesDue.setValue(NumberUtil.formatAmount((Double)(ticketItemSales - itemSalesPaid)));
            this.tfTotalPurchaseSales.setValue(NumberUtil.formatAmount((Double)salesReportUtil.calculatePurchaseOrderAmount(session)));
            this.tfTotalPurchasePaid.setValue(NumberUtil.formatAmount((Double)purchasePaid));
            this.tfTotalPurchaseDue.setValue(NumberUtil.formatAmount((Double)salesReportUtil.calculatePurchaseOrderDueAmount(session)));
            this.tfTotalExpense.setValue(NumberUtil.formatAmount((Double)expense));
        }
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        Project project = null;
        Object selectedProject = this.cbProject.getValue();
        if (selectedProject != null && selectedProject instanceof Project) {
            project = (Project)selectedProject;
        }
        Comparator<ReceiptPrintService.TransactionDataRow> comparator = Comparator.comparing(ReceiptPrintService.TransactionDataRow::getPaymentType, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
        ArrayList<ReceiptPrintService.TransactionDataRow> salesTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
        ArrayList<ReceiptPrintService.TransactionDataRow> salesRefundTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
        Set<String> salesKeySet = this.salesMap.keySet();
        for (String salesKey : salesKeySet) {
            Double amount = this.salesMap.get(salesKey);
            ReceiptPrintService.TransactionDataRow transactionDataRow = new ReceiptPrintService.TransactionDataRow(salesKey, amount);
            if (amount < 0.0) {
                salesRefundTransRows.add(transactionDataRow);
                continue;
            }
            salesTransRows.add(transactionDataRow);
        }
        salesTransRows.sort(comparator);
        salesRefundTransRows.sort(comparator);
        salesTransRows.addAll(salesRefundTransRows);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        TransactionReportModel subReportModel = new TransactionReportModel(salesTransRows);
        properties.put("transAmountDataSource", new JRTableModelDataSource((TableModel)((Object)subReportModel)));
        JasperReport subReport = ReportUtil.getReport((String)"byz-project-transaction-subreport");
        properties.put("transAmountReport", subReport);
        ArrayList<ReceiptPrintService.TransactionDataRow> purchaseTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
        Set<String> keySet = this.purchaseMap.keySet();
        for (String key : keySet) {
            Double amount = this.purchaseMap.get(key);
            purchaseTransRows.add(new ReceiptPrintService.TransactionDataRow(key, amount));
        }
        purchaseTransRows.sort(comparator);
        TransactionReportModel purchaseSubReportModel = new TransactionReportModel(purchaseTransRows);
        properties.put("purchaseTransDataSource", new JRTableModelDataSource((TableModel)((Object)purchaseSubReportModel)));
        JasperReport purchaseSubReport = ReportUtil.getReport((String)"byz-project-purchase-transaction-subreport");
        properties.put("purchaseTransReport", purchaseSubReport);
        ArrayList<ReceiptPrintService.TransactionDataRow> expenseTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
        Set<String> expenseKeySet = this.expenseMap.keySet();
        for (String key : expenseKeySet) {
            Double amount = this.expenseMap.get(key);
            expenseTransRows.add(new ReceiptPrintService.TransactionDataRow(key, amount));
        }
        expenseTransRows.sort(comparator);
        TransactionReportModel expenseSubReportModel = new TransactionReportModel(expenseTransRows);
        properties.put("expenseTransDataSource", new JRTableModelDataSource((TableModel)((Object)expenseSubReportModel)));
        JasperReport expenseSubReport = ReportUtil.getReport((String)"byz-project-expense-transaction-subreport");
        properties.put("expenseTransReport", expenseSubReport);
        properties.put("reportName", project != null ? "Project: " + project.getNameDisplay() : null);
        properties.put("totalItemSales", this.tfTotalItemSales.getValue());
        properties.put("salesPaid", this.tfTotalItemSalesPaid.getValue());
        properties.put("salesDue", this.tfTotalItemSalesDue.getValue());
        properties.put("purchaseSales", this.tfTotalPurchaseSales.getValue());
        properties.put("purchasePaid", this.tfTotalPurchasePaid.getValue());
        properties.put("purchaseDue", this.tfTotalPurchaseDue.getValue());
        properties.put("totalExpense", this.tfTotalExpense.getValue());
        StreamResource streamResource = null;
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getByzProjectReportPrint(startTime, endTime, outlet, this.balanceUpdateTransactions, properties);
            streamResource = CommonCloudReportService.getReportStream("project-report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.grid = new ProjectReportGrid();
        return this.grid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            this.grid.clearFooterCell();
            if (this.balanceUpdateTransactions == null || this.balanceUpdateTransactions.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage("No data found!");
                return;
            }
            this.grid.setItems((Collection<PosTransaction>)this.balanceUpdateTransactions);
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }

    private static class TransactionReportModel
    extends ListTableModel<ReceiptPrintService.TransactionDataRow> {
        public TransactionReportModel(List<ReceiptPrintService.TransactionDataRow> posTransactions) {
            super(new String[]{"tenderName", "transAmount"}, posTransactions);
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ReceiptPrintService.TransactionDataRow transaction = (ReceiptPrintService.TransactionDataRow)this.getRowData(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return transaction.getPaymentType();
                }
                case 1: {
                    return NumberUtil.formatAmount((Double)transaction.getAmount());
                }
            }
            return null;
        }
    }
}

