/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.PayOutTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaPayoutReasonCombobox;
import com.orocube.siiopa.cloud.client.SiiopaRecipientCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.SiiopaUserCombobox;
import com.orocube.siiopa.cloud.client.curd.grid.PayoutReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class PayoutReportView
extends ReportView {
    public static final String VIEW_NAME = "Payout report";
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private List<PayOutTransaction> payoutTransactions;
    private PayoutReportGrid payoutReportGrid;
    private SiiopaTextField tfBatchNumber;
    private SiiopaRecipientCombobox cbRecipient;
    private SiiopaPayoutReasonCombobox cbReason;
    private SiiopaUserCombobox cbUser;

    public PayoutReportView() {
        this(false);
    }

    public PayoutReportView(boolean isShowExpenseOnly) {
        super(isShowExpenseOnly ? UserPermission.EXPENSE_REPORT : UserPermission.PAYOUT_REPORT);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                PayoutReportView.this.updateView();
            }
        };
        this.tfBatchNumber = new SiiopaTextField();
        this.cbRecipient = new SiiopaRecipientCombobox();
        this.cbRecipient.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbReason = new SiiopaPayoutReasonCombobox();
        this.cbReason.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbUser = new SiiopaUserCombobox();
        this.cbUser.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Batch No", (Component)this.tfBatchNumber));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Paid by", (Component)this.cbUser));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Recipient", (Component)this.cbRecipient));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Reason", (Component)this.cbReason));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    protected void doClear() {
        this.tfBatchNumber.setValue("");
        this.cbOutlet.setValue(POSConstants.ALL);
        this.clearDateFields();
        this.cbRecipient.clear();
        this.cbReason.clear();
        this.cbUser.clear();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        String recipientId = null;
        Object selectedRecipient = this.cbRecipient.getValue();
        if (selectedRecipient != null && selectedRecipient instanceof PayoutRecepient) {
            PayoutRecepient payoutRecepient = (PayoutRecepient)selectedRecipient;
            recipientId = payoutRecepient.getId();
        }
        String reasonId = null;
        Object selectedReason = this.cbReason.getValue();
        if (selectedReason != null && selectedReason instanceof PayoutReason) {
            PayoutReason payoutReason = (PayoutReason)selectedReason;
            reasonId = payoutReason.getId();
        }
        String userId = null;
        Object selectedUser = this.cbUser.getValue();
        if (selectedUser != null && selectedUser instanceof User) {
            User user = (User)selectedUser;
            userId = user.getId();
        }
        this.payoutTransactions = PayOutTransactionDAO.getInstance().findPayoutReport(startTime, endTime, this.tfBatchNumber.getValue(), recipientId, reasonId, false, userId);
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        StreamResource streamResource = null;
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getPayoutReportReportPrint(startTime, endTime, outlet, this.payoutTransactions);
            streamResource = CommonCloudReportService.getReportStream("payout-report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.payoutReportGrid = new PayoutReportGrid();
        return this.payoutReportGrid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            this.payoutReportGrid.clearFooterCell();
            if (this.payoutTransactions == null || this.payoutTransactions.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage("No data found!");
                return;
            }
            this.payoutReportGrid.setItems((Collection<PayOutTransaction>)this.payoutTransactions);
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }
}

