/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DateUtil;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PurchaseTransactionReportModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"transTime", "transNo", "owner", "paymentType", "totalAmount"};
    private List<PosTransaction> items;
    public static String PROP_DISPLAY_DATE = "displayDate";
    public static String PROP_AMOUNT = "amount";
    private String displayDate;
    private Double amount;
    private int sortOrder;

    public PurchaseTransactionReportModel() {
    }

    public PurchaseTransactionReportModel(String displayDate, Double amount, int sortOrder) {
        this.displayDate = displayDate;
        this.amount = amount;
        this.setSortOrder(sortOrder);
    }

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PosTransaction transaction = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return DateUtil.formatDateWithBrowserTimeOffset((Date)transaction.getTransactionTime());
            }
            case 1: {
                return transaction.getId();
            }
            case 2: {
                if (transaction.getUserId() == null || transaction.getUserName() == null) {
                    return "";
                }
                return transaction.getUserName();
            }
            case 3: {
                String paymentTypeString = transaction.getPaymentTypeString();
                if (paymentTypeString == null) {
                    return "";
                }
                return paymentTypeString.replaceAll("_", " ");
            }
            case 4: {
                if (transaction.getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                    return -transaction.getAmount().doubleValue();
                }
                return transaction.getAmount();
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.items;
    }

    public void setItems(List<PosTransaction> items) {
        this.items = items;
    }

    public String getDisplayDate() {
        return this.displayDate;
    }

    public void setDisplayDate(String displayDate) {
        this.displayDate = displayDate;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

