/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.util;

import com.floreantpos.model.NumberBound;
import com.floreantpos.util.NumberUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CloudNumberUtil {
    private static Map<NumberBound, String> maxValues = new HashMap<NumberBound, String>();
    private static Map<String, Pattern> cloudPatterns = new HashMap<String, Pattern>();

    public static String doCreateMaxValue(int beforeDecimal, int afterDecimal) {
        return CloudNumberUtil.doCreateMaxValue(new NumberBound(beforeDecimal, afterDecimal));
    }

    private static String doCreateMaxValue(NumberBound bound) {
        if (!maxValues.containsKey(bound)) {
            CloudNumberUtil.initMaxValue(bound);
        }
        return maxValues.get(bound);
    }

    private static void initMaxValue(NumberBound bound) {
        StringBuilder builder = new StringBuilder();
        int beforeDecimal = bound.getBeforeDecimal();
        if (beforeDecimal < 1) {
            builder.append("0");
        } else {
            for (int i = 0; i < beforeDecimal; ++i) {
                builder.append("9");
            }
        }
        int afterDecimal = bound.getAfterDecimal();
        if (afterDecimal >= 1) {
            builder.append(".");
            for (int i = 0; i < afterDecimal; ++i) {
                builder.append("9");
            }
        }
        maxValues.put(bound, builder.toString());
    }

    public static boolean isValidNumber(String value) {
        return CloudNumberUtil.isValidNumber(value, false, false, "validNumber");
    }

    public static boolean isValidDoubleNumber(String value) {
        return CloudNumberUtil.isValidNumber(value, true, false, "validDoubleNumber");
    }

    public static boolean isValidPhoneNumber(String value) {
        return CloudNumberUtil.isValidNumber(value, false, true, "validPhoneNumber");
    }

    private static boolean isValidNumber(String value, boolean isDouble, boolean isPhoneNo, String key) {
        Pattern pattern = cloudPatterns.get(key);
        if (pattern != null) {
            return pattern.matcher(value).matches();
        }
        StringBuilder regexBuilder = new StringBuilder();
        if (isPhoneNo) {
            regexBuilder.append("^[+]?{1}");
        }
        regexBuilder.append("[0-9]*");
        if (isDouble) {
            regexBuilder.append("(\\");
            regexBuilder.append(NumberUtil.getDecimalSeparator());
            regexBuilder.append("){1}");
            regexBuilder.append("[0-9]*");
        }
        String regex = regexBuilder.toString();
        pattern = Pattern.compile(regex);
        cloudPatterns.put(key, pattern);
        return pattern.matcher(value).matches();
    }
}

