/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.util;

import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.vaadin.data.Validator;
import org.apache.commons.lang.StringUtils;

public class SiiopaTextFieldValidator
implements Validator {
    private String errorMessage;

    public SiiopaTextFieldValidator(String message) {
        this.errorMessage = message;
    }

    public void validate(Object value) throws Validator.InvalidValueException {
        try {
            if (value == null) {
                return;
            }
            if (value instanceof String && StringUtils.isBlank((String)((String)value))) {
                return;
            }
            double actualDoubleValue = NumberUtil.parseDouble((String)((String)value));
            if (actualDoubleValue < 0.0) {
                throw new Validator.InvalidValueException(ConsoleMessages.getString("NegativeValueNotAllowed"));
            }
        }
        catch (Validator.InvalidValueException e) {
            throw new Validator.InvalidValueException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new Validator.InvalidValueException(this.errorMessage);
        }
        catch (Exception e) {
            throw new Validator.InvalidValueException(e.getMessage());
        }
    }
}

