/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.BalanceUpdateTransaction;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class ExpenseReportGrid
extends FooterSupportedBeanGrid<BalanceUpdateTransaction> {
    public ExpenseReportGrid(boolean isByzlogicsExpense) {
        super.setUseNormalFont(true);
        this.addColumn("Store / Accounts Manager", "accountManager", String.class);
        this.addColumn("Time", "transactionTimeDisplay", String.class);
        this.addColumn("Event date", "eventTimeDisplay", String.class);
        if (isByzlogicsExpense) {
            this.addColumn("Project Name", "projectDisplay", String.class);
            this.addColumn("Expense Recepient", "recepientDisplay", String.class);
            this.addColumn("Category", "reasonDisplay", String.class);
            this.addColumn("Sub category", "subCategoryDisplay", String.class);
        } else {
            this.addColumn("Expense Recepient", "recepientDisplay", String.class);
            this.addColumn("Expense reason", "reasonDisplay", String.class);
        }
        this.addColumn("Note", "description", String.class);
        this.addColumn("Amount", "expenseAmountDisplay", Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        if (isByzlogicsExpense) {
            this.showCSummaryRow("expenseAmountDisplay", "Total expense :", "accountManager", "recepientDisplay", "transactionTimeDisplay", "eventTimeDisplay", "reasonDisplay", "description", "projectDisplay", "reasonDisplay", "subCategoryDisplay");
        } else {
            this.showCSummaryRow("expenseAmountDisplay", "Total expense :", "accountManager", "recepientDisplay", "transactionTimeDisplay", "eventTimeDisplay", "reasonDisplay", "description");
        }
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
        this.getColumn("expenseAmountDisplay").setMinimumWidth(180.0);
        this.getColumn("transactionTimeDisplay").setMaximumWidth(165.0);
    }

    public void setItems(Collection<BalanceUpdateTransaction> items, double totalAmount) {
        super.setItems(items);
        super.updateView(totalAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return BalanceUpdateTransaction.class;
    }
}

