/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.server;

import com.floreantpos.jdbc.SchemaResolver;
import com.floreantpos.model.ChartOfAccounts;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.UnitType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ChartOfAccountsDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.pricecalc.PriceRuleFactory;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.StoreUtil;
import com.orocube.siiopa.cloud.server.CloudContext;
import com.orocube.siiopa.cloud.server.security.CurrentSession;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.io.File;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;

public class CloudDataProvider
extends DataProvider
implements Serializable {
    private Terminal terminal;
    protected Map<String, Tax> taxMap = new HashMap<String, Tax>();
    private Map<String, ChartOfAccounts> cOAMap = new HashMap<String, ChartOfAccounts>();

    public void initialize() {
        this.taxMap.clear();
        this.cOAMap.clear();
        Store store = CurrentSession.getStore();
        if (store == null) {
            return;
        }
        Outlet outlet = this.refreshAndGetOutlet();
        if (outlet == null) {
            return;
        }
        this.loadMainCurrencyAndFormats(outlet.getId());
        this.initializeFormatByOutlet(outlet);
    }

    private Outlet refreshAndGetOutlet() {
        Outlet outlet = this.getOutlet();
        if (outlet == null) {
            return null;
        }
        if (CurrentSession.getCurrentSchema() != null) {
            SchemaResolver.setTenant(CurrentSession.getCurrentSchema());
            OutletDAO.getInstance().refresh((Object)outlet);
        }
        return outlet;
    }

    public void initializeFormatByOutlet(String selectedOutletId) {
        Outlet outlet = OutletDAO.getInstance().get(selectedOutletId);
        NumberUtil.initializeNumberFormats((Outlet)outlet);
    }

    public void initializeFormatByOutlet(Outlet outlet) {
        NumberUtil.initializeNumberFormats((Outlet)outlet);
    }

    public void refreshStore() {
    }

    public void refreshCurrentTerminal() {
    }

    public void setStoreSession(StoreSession session) {
    }

    public StoreSession getStoreSession() {
        return StoreUtil.getCurrentStoreSession();
    }

    public Terminal getCurrentTerminal() {
        return this.terminal;
    }

    public void setCloudTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public OrderType getOrderType(String orderTypeId, String outletId) {
        if (StringUtils.isEmpty((String)orderTypeId)) {
            return null;
        }
        return OrderTypeDAO.getInstance().get(orderTypeId, outletId);
    }

    public List<OrderType> getOrderTypes() {
        return OrderTypeDAO.getInstance().findAll();
    }

    public UserType getUserType(String userTypeId) {
        if (StringUtils.isEmpty((String)userTypeId)) {
            return null;
        }
        return UserTypeDAO.getInstance().get(userTypeId);
    }

    public Currency getCurrency(String currencyId, String outletId) {
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        return CurrencyDAO.getInstance().get(currencyId, outletId);
    }

    public Course getCourse(String courseId) {
        if (StringUtils.isEmpty((String)courseId)) {
            return null;
        }
        return CourseDAO.getInstance().get(courseId);
    }

    public TerminalType getTerminalType(String terminalTypeId, String outletId) {
        if (StringUtils.isEmpty((String)terminalTypeId)) {
            return null;
        }
        return TerminalTypeDAO.getInstance().get(terminalTypeId, outletId);
    }

    public Multiplier getMultiplierById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return MultiplierDAO.getInstance().get(id);
    }

    public List<Multiplier> getMultiplierList() {
        return MultiplierDAO.getInstance().findAll();
    }

    public InventoryLocation getDefaultInLocation() {
        return InventoryLocationDAO.getInstance().getDefaultInInventoryLocation(this.getOutletId());
    }

    public InventoryLocation getDefaultOutLocation() {
        return InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(this.getOutletId());
    }

    public List<Course> getCourses() {
        return CourseDAO.getInstance().findAll();
    }

    public String getDefaultCourseId() {
        return null;
    }

    public String getRecipeMenuItemName(Recepie recipe) {
        return RecepieDAO.getInstance().getMenuItemName(recipe);
    }

    public MenuItemInventoryStatus getMenuItemStockStatus(MenuItem menuItem) {
        MenuItemInventoryStatusDAO dao = MenuItemInventoryStatusDAO.getInstance();
        Outlet outlet = this.getOutlet();
        MenuItemInventoryStatus stockStatus = dao.get(menuItem.getId(), outlet.getId());
        if (stockStatus == null) {
            stockStatus = new MenuItemInventoryStatus();
            stockStatus.setMenuItemId(menuItem.getId());
            stockStatus.setOutletId(outlet.getId());
        }
        return stockStatus;
    }

    public SalesArea getSalesArea(String salesAreaId) {
        if (StringUtils.isEmpty((String)salesAreaId)) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(salesAreaId);
    }

    public Customer getCustomer(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return CustomerDAO.getInstance().get(id);
    }

    public Double getPriceFromPriceRule(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, Customer customer, IUnit unit) {
        Double price = PriceRuleFactory.getPriceRuleService().getPrice(menuItem, orderType, department, salesArea, customer, unit == null ? null : unit.getId());
        if (price == null) {
            if (ProductType.match((String)menuItem.getProductType(), (ProductType)ProductType.MEDICINE) && unit instanceof InventoryStockUnit) {
                InventoryStockUnit inventoryStockUnit = (InventoryStockUnit)unit;
                return inventoryStockUnit.getPrice();
            }
            return menuItem.getPrice();
        }
        return price;
    }

    public PosPrinters getPrinters() {
        return PosPrinters.load((Terminal)this.getCurrentTerminal());
    }

    public synchronized Store getStore() {
        Store store = StoreDAO.getRestaurant();
        return store;
    }

    public Outlet getOutlet() {
        Outlet outlet;
        OutletDAO outletDAO = OutletDAO.getInstance();
        Outlet selectedOutlet = CurrentSession.getSelectedOutlet();
        if (selectedOutlet != null) {
            return selectedOutlet;
        }
        Store store = this.getStore();
        String defaultOutletId = store.getDefaultOutletId();
        if (StringUtils.isNotBlank((String)defaultOutletId) && (outlet = outletDAO.get(defaultOutletId)) != null) {
            return outlet;
        }
        try (Session session = outletDAO.createNewSession();){
            Criteria criteria = session.createCriteria(Outlet.class);
            criteria.setMaxResults(1);
            outletDAO.addDeletedFilter(criteria);
            List outlets = criteria.list();
            if (outlets.size() > 0) {
                Outlet outlet2 = (Outlet)outlets.get(0);
                store.setDefaultOutletId(outlet2.getId());
                StoreDAO.getInstance().update(store);
                Outlet outlet3 = outlet2;
                return outlet3;
            }
            Outlet outlet4 = new Outlet();
            outlet4.setName("Main");
            outlet4.setAddressLine1(store.getAddressLine1());
            outlet4.setAddressLine2(store.getAddressLine2());
            outlet4.setAddressLine3(store.getAddressLine3());
            outlet4.setCountry(store.getCountry());
            outlet4.setState(store.getState());
            outlet4.setCity(store.getCity());
            outlet4.setZipCode(store.getZipCode());
            outlet4.setCurrency(this.getMainCurrency());
            outletDAO.save(outlet4);
            store.setDefaultOutletId(outlet4.getId());
            StoreDAO.getInstance().update(store);
            Outlet outlet5 = outlet4;
            return outlet5;
        }
    }

    public InventoryUnit getInventoryUnitById(String unitId) {
        if (StringUtils.isEmpty((String)unitId)) {
            return null;
        }
        return InventoryUnitDAO.getInstance().get(unitId);
    }

    public IUnit getUnitById(String unitId, String unitType) {
        if (StringUtils.isEmpty((String)unitId)) {
            return null;
        }
        if (UnitType.PACKAGING_UNIT.name().equals(unitType)) {
            return InventoryStockUnitDAO.getInstance().get(unitId);
        }
        return InventoryUnitDAO.getInstance().get(unitId);
    }

    public TaxGroup getTaxGroupById(String taxGroupId) {
        if (StringUtils.isEmpty((String)taxGroupId)) {
            return null;
        }
        return TaxGroupDAO.getInstance().get(taxGroupId, this.getOutlet() == null ? null : this.getOutlet().getId());
    }

    public ReportGroup getReportGroupById(String reportGroupId) {
        if (StringUtils.isEmpty((String)reportGroupId)) {
            return null;
        }
        return ReportGroupDAO.getInstance().get(reportGroupId);
    }

    public PrinterGroup getPrinterGroupById(String printerGroupId) {
        if (StringUtils.isEmpty((String)printerGroupId)) {
            return null;
        }
        return PrinterGroupDAO.getInstance().get(printerGroupId);
    }

    public Department getDepartmentById(String departmentId) {
        if (StringUtils.isEmpty((String)departmentId)) {
            return null;
        }
        return DepartmentDAO.getInstance().get(departmentId);
    }

    public OrderType getOrderTypeById(String orderTypeId, String outletId) {
        if (StringUtils.isEmpty((String)orderTypeId)) {
            return null;
        }
        return OrderTypeDAO.getInstance().get(orderTypeId, outletId);
    }

    public InventoryLocation getInventoryLocationById(String inventoryLocationId) {
        return this.getInventoryLocationById(inventoryLocationId, null);
    }

    public InventoryLocation getInventoryLocationById(String inventoryLocationId, String outletId) {
        if (StringUtils.isEmpty((String)inventoryLocationId)) {
            return null;
        }
        return InventoryLocationDAO.getInstance().get(inventoryLocationId, outletId);
    }

    public User getUserById(String userId) {
        return this.getUserById(userId, null);
    }

    public User getUserById(String userId, String outletId) {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        User eUser = UserDAO.getInstance().get(userId, outletId);
        return eUser;
    }

    public Terminal getTerminalById(Integer terminalId) {
        if (terminalId == null) {
            return null;
        }
        return TerminalDAO.getInstance().get(terminalId, null);
    }

    public Terminal getTerminalById(Integer terminalId, String outletId) {
        if (terminalId == null || outletId == null) {
            return null;
        }
        return TerminalDAO.getInstance().get(terminalId, outletId);
    }

    public Object getObjectOf(Class clazz, Serializable id) {
        try (Session session = StoreDAO.getInstance().createNewSession();){
            Object object = session.get(clazz, id);
            return object;
        }
    }

    public Shift getShiftById(String shiftId) {
        return this.getShiftById(shiftId, null);
    }

    public Shift getShiftById(String shiftId, String outletId) {
        if (StringUtils.isEmpty((String)shiftId)) {
            return null;
        }
        return ShiftDAO.getInstance().get(shiftId, outletId);
    }

    public List<DayPart> getDaryPartShifts() {
        return DayPartDAO.getInstance().findByOutletId(this.getOutlet().getId());
    }

    public List<PriceShift> getPriceShifts() {
        return PriceShiftDAO.getInstance().findByOutletId(this.getOutlet().getId());
    }

    public List<MenuShift> getMenuShifts() {
        return MenuShiftDAO.getInstance().findByOutletId(this.getOutlet().getId());
    }

    public File getAppConfigFileLocation() {
        String userHome = System.getProperty("user.home");
        File prefDir = new File(userHome + "/prefs");
        return prefDir;
    }

    public Currency getMainCurrency() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return null;
        }
        return (Currency)session.getAttribute(Currency.class);
    }

    public List<Currency> getCurrencies(String outletId) {
        return CurrencyDAO.getInstance().findByOutletId(outletId);
    }

    public int getTimeZoneOffset() {
        Page page = Page.getCurrent();
        if (page != null && UI.getCurrent().getSession() != null) {
            return page.getWebBrowser().getTimezoneOffset();
        }
        return 0;
    }

    public void loadMainCurrencyAndFormats(String outletId) {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return;
        }
        if (CurrentSession.getCurrentSchema() == null) {
            return;
        }
        SchemaResolver.setTenant(CurrentSession.getCurrentSchema());
        Currency mainCurrencyByOutletId = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outletId);
        if (mainCurrencyByOutletId == null) {
            mainCurrencyByOutletId = new Currency();
            mainCurrencyByOutletId.setName("US Dollar");
            mainCurrencyByOutletId.setCode("USD");
            mainCurrencyByOutletId.setSymbol("$");
            mainCurrencyByOutletId.setExchangeRate(Double.valueOf(1.0));
            mainCurrencyByOutletId.setMain(Boolean.valueOf(true));
        }
        session.setAttribute(Currency.class, (Object)mainCurrencyByOutletId);
    }

    public Tax getTaxById(String taxId, String outletId) {
        if (StringUtils.isEmpty((String)taxId) || StringUtils.isEmpty((String)outletId)) {
            return null;
        }
        String key = taxId + "_" + outletId;
        Tax tax = this.taxMap.get(key);
        if (tax != null && (tax = TaxDAO.getInstance().get(taxId, outletId)) != null) {
            this.taxMap.put(key, tax);
        }
        return tax;
    }

    public String getMqttDeviceId() {
        return CloudContext.MQTT_DEVICE_ID;
    }

    public NumberFormat getDefaultNumberFormat() {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession == null) {
            return NumberFormat.getNumberInstance();
        }
        NumberFormat numberFormat = (NumberFormat)vaadinSession.getAttribute("default_number_format");
        if (numberFormat == null) {
            numberFormat = NumberFormat.getNumberInstance();
            int decimalPlaceInt = 2;
            String decimalPlace = this.getOutlet().getProperty("decimal.place");
            if (StringUtils.isNotBlank((String)decimalPlace)) {
                try {
                    decimalPlaceInt = Integer.parseInt(decimalPlace);
                }
                catch (Exception e) {
                    decimalPlaceInt = 2;
                }
            }
            numberFormat.setMinimumFractionDigits(decimalPlaceInt);
            numberFormat.setMaximumFractionDigits(decimalPlaceInt);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            numberFormat.setGroupingUsed(false);
            vaadinSession.setAttribute("default_number_format", (Object)numberFormat);
        }
        return numberFormat;
    }

    public Date getServerTimestamp() {
        return new Date();
    }

    public User getCurrentUser() {
        return CurrentSession.getUser();
    }

    public ChartOfAccounts getCOAFromMap(String code, Session session) {
        return this.getCOAFromMap(code, session, true);
    }

    public ChartOfAccounts getCOAFromMap(String code, Session session, boolean isInsertCOA) {
        ChartOfAccounts chartOfAccounts = this.cOAMap.get(code);
        if (chartOfAccounts == null) {
            chartOfAccounts = ChartOfAccountsDAO.getInstance().findByAcountCode(code, session, isInsertCOA);
            this.cOAMap.put(code, chartOfAccounts);
        }
        return chartOfAccounts;
    }
}

