/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosLog;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.ExceptionView;
import com.orocube.siiopa.cloud.client.SimpleView;
import com.orocube.siiopa.cloud.client.crud.view.DateSelectionView;
import com.orocube.siiopa.cloud.server.security.CurrentSession;
import com.vaadin.event.ShortcutListener;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;

public abstract class ReportView
extends SimpleView
implements DateSelectionView.DateChangeListener {
    protected FileDownloader downloader = null;
    protected Button btnExportPdf;
    private DateSelectionView dateSelectionView;
    protected UserPermission requiredPermission;

    public ReportView() {
        this(null);
    }

    public ReportView(UserPermission userPermission) {
        this.requiredPermission = userPermission;
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (this.requiredPermission != null && !CurrentSession.getUser().hasPermission(this.requiredPermission)) {
            this.setWidth("100%");
            this.addComponent((Component)new ExceptionView());
            return;
        }
        this.createExportPdfButton();
        super.enter(event);
    }

    private void createExportPdfButton() {
        this.btnExportPdf = CommonUIUtil.createColorButton(ConsoleMessages.getString("ReportView.0"));
        this.btnExportPdf.addStyleName("margin-top-five");
        StreamResource.StreamSource source = new StreamResource.StreamSource(){

            public InputStream getStream() {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
        StreamResource resource = new StreamResource(source, "");
        this.downloader = new FileDownloader((Resource)resource){

            public boolean handleConnectorRequest(VaadinRequest request, VaadinResponse response, String path) throws IOException {
                ReportView.this.downloader.setFileDownloadResource((Resource)ReportView.this.executeExportButtonAction());
                return super.handleConnectorRequest(request, response, path);
            }
        };
        this.downloader.extend((AbstractComponent)this.btnExportPdf);
    }

    protected abstract StreamResource executeExportButtonAction();

    public void addDateFilters(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView();
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addDateFilters(CssLayout topLayout, int dateRangeMonth, int dateRangeDays, boolean isAllowFutureDate) {
        this.dateSelectionView = new DateSelectionView(dateRangeMonth, dateRangeDays, isAllowFutureDate);
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addUserWiseSalesReportDateFilter(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView(0, 1, false, true);
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addAccountingDateFilters(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView(6, true);
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    private ShortcutListener createKeyPressListener() {
        ShortcutListener shortcutListener = new ShortcutListener("Enter key pressed", 13, null){

            public void handleAction(Object sender, Object target) {
                PosLog.debug(ReportView.class, (String)"date field shortcut listener fired");
                if (ReportView.this.dateSelectionView.isTargetMatch(target)) {
                    ReportView.this.updateView();
                }
            }
        };
        return shortcutListener;
    }

    public Date getFromDate() {
        return this.dateSelectionView.getFromDate();
    }

    public Date getToDate() {
        return this.dateSelectionView.getToDate();
    }

    public Date getFromDateWithoutFormat() {
        return this.dateSelectionView.getFromDateWithoutFormat();
    }

    public Date getToDateWithoutFormat() {
        return this.dateSelectionView.getToDateWithoutFormat();
    }

    public void doUpdateUi(int reportType) {
        this.dateSelectionView.doUpdateUi(reportType);
    }

    public void validateDate() throws Exception {
        this.dateSelectionView.validateDate();
    }

    public void clearDateFields() {
        this.dateSelectionView.clearDateFields();
    }

    public void clearAccountDateFields() {
        this.dateSelectionView.clearDateFields();
        Date serverTimestamp = StoreDAO.getServerTimestamp();
        Calendar c = Calendar.getInstance();
        c.setTime(serverTimestamp);
        c.add(2, 6);
        this.dateSelectionView.toDateRangeEnd(DateUtil.endOfMonth((Date)c.getTime()));
    }

    @Override
    public void updateData() {
        this.updateView();
    }
}

