/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.server;

import com.floreantpos.PosLog;
import com.floreantpos.util.POSUtil;
import com.orocube.siiopa.cloud.Constants;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Image;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CloudResourceCache {
    public static final String WEB_INF_RESOURCES = "/WEB-INF/resources/";
    public static final String custCreateConfirmEmailTmplName = "cust-create-confirm-email-template.html";
    public static final String REGISTRATION_EMAIL_TMPL_NAME = "registration-email-template.html";
    public static final String VERIFICATION_EMAIL_TMPL_NAME = "verification-code-email-template.html";
    public static final String SIIOPA_REGISTRATION_EMAIL_TMPL_NAME = "siiopa-registration-email-template.html";
    public static final String resetPasswordEmailTmplName = "reset-password-email-template.html";
    public static final String SIIOPA_LOGO = "title_bar_icon_30.png";
    private static String stripeApiKey;
    private String custCreateConfirmEmailTemplate;
    private String regEmailTemplate;
    private String resetPassTemplate;
    private String verificationEmailTemplate;
    private String emailFromAddrHost;
    private String menugreatUrl;
    private ByteArrayDataSource siiopaLogoDataSource;
    private Integer maxMindUserId;
    private String maxMindApiKey;
    private Boolean maxMindLocalDBEnabled;
    private boolean isMenugreat;
    private String appUrl;
    private String medlogicsUrl;
    private String orostoreUrl;
    private String oroHUBAutoLoginParam;
    private String jwtSecretKey;
    private boolean isStandAlone;
    private String lmServiceUrl;
    private static CloudResourceCache instance;

    public static CloudResourceCache get() {
        if (instance == null) {
            instance = new CloudResourceCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletContext servletContext) throws Exception {
        block16: {
            FileInputStream emailTemlStream = null;
            FileInputStream resetPassTemlStream = null;
            FileInputStream custCreateConfirmTemlStream = null;
            FileInputStream verificationTemplateStream = null;
            FileInputStream logoStream = null;
            try {
                Image image;
                String appMode = servletContext.getInitParameter("app.mode");
                if ("standalone".equals(appMode)) {
                    this.isStandAlone = true;
                }
                if ("menugreat".equalsIgnoreCase(servletContext.getInitParameter("system.name"))) {
                    this.isMenugreat = true;
                    Constants.appFullName = CommonUIUtil.OROWORKSPACE;
                    Constants.host = "https://backoffice.p-os.com";
                }
                stripeApiKey = servletContext.getInitParameter("stripe.apikey");
                this.emailFromAddrHost = servletContext.getInitParameter("email.from_address.host");
                this.appUrl = servletContext.getInitParameter("app.url");
                if (this.appUrl != null && this.appUrl.endsWith("/")) {
                    this.appUrl = this.appUrl.substring(0, this.appUrl.length() - 1);
                }
                this.menugreatUrl = servletContext.getInitParameter("menugreat.url");
                if (StringUtils.isNotBlank((String)this.menugreatUrl)) {
                    if (this.menugreatUrl.endsWith("/")) {
                        this.menugreatUrl = this.menugreatUrl.substring(0, this.menugreatUrl.lastIndexOf(47));
                    }
                } else {
                    this.menugreatUrl = "https://menugreat.com";
                }
                this.medlogicsUrl = servletContext.getInitParameter("oroposlive.url");
                if (StringUtils.isNotBlank((String)this.medlogicsUrl) && this.medlogicsUrl.endsWith("/")) {
                    this.medlogicsUrl = this.medlogicsUrl.substring(0, this.medlogicsUrl.lastIndexOf(47));
                }
                this.orostoreUrl = servletContext.getInitParameter("orostore.url");
                if (StringUtils.isNotBlank((String)this.orostoreUrl) && this.orostoreUrl.endsWith("/")) {
                    this.orostoreUrl = this.orostoreUrl.substring(0, this.orostoreUrl.lastIndexOf(47));
                }
                if (StringUtils.isBlank((String)this.orostoreUrl) || this.orostoreUrl.startsWith("{")) {
                    this.orostoreUrl = stripeApiKey != null && stripeApiKey.startsWith("sk_test") ? "https://test.orodev.net/orostore" : "https://shop.orocube.com";
                }
                this.oroHUBAutoLoginParam = servletContext.getInitParameter("orohub_auto_login_param");
                this.jwtSecretKey = servletContext.getInitParameter("jwt.key");
                if (StringUtils.isBlank((String)this.jwtSecretKey)) {
                    this.jwtSecretKey = "thebestsecretkeyoro";
                }
                this.initMaxMindProperties(servletContext);
                String realPath = servletContext.getRealPath(WEB_INF_RESOURCES + (this.isMenugreat ? REGISTRATION_EMAIL_TMPL_NAME : SIIOPA_REGISTRATION_EMAIL_TMPL_NAME));
                emailTemlStream = new FileInputStream(realPath);
                this.regEmailTemplate = IOUtils.toString((InputStream)emailTemlStream);
                custCreateConfirmTemlStream = new FileInputStream(servletContext.getRealPath("/WEB-INF/resources/cust-create-confirm-email-template.html"));
                this.custCreateConfirmEmailTemplate = IOUtils.toString((InputStream)custCreateConfirmTemlStream);
                resetPassTemlStream = new FileInputStream(servletContext.getRealPath("/WEB-INF/resources/reset-password-email-template.html"));
                this.resetPassTemplate = IOUtils.toString((InputStream)resetPassTemlStream);
                verificationTemplateStream = new FileInputStream(servletContext.getRealPath("/WEB-INF/resources/verification-code-email-template.html"));
                this.verificationEmailTemplate = IOUtils.toString((InputStream)verificationTemplateStream);
                logoStream = new FileInputStream(servletContext.getRealPath("/WEB-INF/resources/title_bar_icon_30.png"));
                ThemeResource resource = new ThemeResource("img/title_bar_icon_30.png");
                if (resource != null && (image = new Image("", (Resource)resource)) != null) {
                    this.siiopaLogoDataSource = new ByteArrayDataSource((InputStream)logoStream, resource.getMIMEType());
                }
                this.lmServiceUrl = servletContext.getInitParameter("lm.service.url");
                IOUtils.closeQuietly((InputStream)emailTemlStream);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (String)"could not cache resources", (Exception)e);
                break block16;
            }
            finally {
                IOUtils.closeQuietly(emailTemlStream);
                IOUtils.closeQuietly(resetPassTemlStream);
                IOUtils.closeQuietly(verificationTemplateStream);
                IOUtils.closeQuietly(custCreateConfirmTemlStream);
                IOUtils.closeQuietly(logoStream);
            }
            IOUtils.closeQuietly((InputStream)resetPassTemlStream);
            IOUtils.closeQuietly((InputStream)verificationTemplateStream);
            IOUtils.closeQuietly((InputStream)custCreateConfirmTemlStream);
            IOUtils.closeQuietly((InputStream)logoStream);
        }
    }

    private void initMaxMindProperties(ServletContext servletContext) {
        try {
            this.maxMindUserId = POSUtil.parseInteger((String)servletContext.getInitParameter("maxmind.user_id"));
            this.maxMindApiKey = servletContext.getInitParameter("maxmind.api_key");
            this.maxMindLocalDBEnabled = POSUtil.getBoolean((String)servletContext.getInitParameter("maxmind.local"));
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
        }
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public String getAppUrl(URI locationInBrowser) {
        if (!this.isStandAlone()) {
            return this.getAppUrl();
        }
        try {
            URL location = locationInBrowser.toURL();
            String protocol = location.getProtocol();
            String authority = location.getAuthority();
            return protocol + "://" + authority + "/medlogicsbo";
        }
        catch (MalformedURLException malformedURLException) {
            return this.getAppUrl();
        }
    }

    public String getMenugreatUrl() {
        return this.menugreatUrl;
    }

    public String getMedlogicsUrl() {
        return this.medlogicsUrl;
    }

    public String getMedlogicsUrl(URI locationInBrowser) {
        if (!this.isStandAlone()) {
            return this.getMedlogicsUrl();
        }
        try {
            URL location = locationInBrowser.toURL();
            String protocol = location.getProtocol();
            String authority = location.getAuthority();
            return protocol + "://" + authority + "/medlogics";
        }
        catch (MalformedURLException malformedURLException) {
            return this.getMedlogicsUrl();
        }
    }

    public String getCustCreateConfirmEmailTemplate() {
        return this.custCreateConfirmEmailTemplate;
    }

    public String getRegEmailTemplate() {
        return this.regEmailTemplate;
    }

    public String getVerificationEmailTemplate() {
        return this.verificationEmailTemplate;
    }

    public String getResetPassTemplate() {
        return this.resetPassTemplate;
    }

    public ByteArrayDataSource getSiiopaLogoDataSource() {
        return this.siiopaLogoDataSource;
    }

    public String getSiiopaLogoFileName() {
        return SIIOPA_LOGO;
    }

    public Integer getMaxMindUserId() {
        return this.maxMindUserId;
    }

    public String getMaxMindApiKey() {
        return this.maxMindApiKey;
    }

    public Boolean isMaxMindLocalDBEnabled() {
        return this.maxMindLocalDBEnabled;
    }

    public boolean isMenugreat() {
        return this.isMenugreat;
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public boolean isSiiopa() {
        return !this.isMenugreat();
    }

    public static String getStripeApiKey() {
        return stripeApiKey;
    }

    public String getEmailFromAddrHost() {
        return this.emailFromAddrHost;
    }

    public void setEmailFromAddrHost(String emailFromAddrHost) {
        this.emailFromAddrHost = emailFromAddrHost;
    }

    public String getJWTSecretKey() {
        return this.jwtSecretKey;
    }

    public String getOroHubAutoLoginParam() {
        return this.oroHUBAutoLoginParam;
    }

    public String getOrostoreUrl() {
        return this.orostoreUrl;
    }

    public String getLmServiceUrl() {
        return this.lmServiceUrl;
    }
}

