/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.PaginationBar;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.MenuBar;

public class PaginationMenuBar
extends HorizontalLayout {
    private PaginationBar.PagingListener listener;
    private MenuBar menuBar;
    private long size;
    private int pageSize;
    private int currentPage;
    private int pages;
    private MenuBar.MenuItem itemNext;
    private MenuBar.MenuItem itemPrev;
    private MenuBar.MenuItem mainMenu;

    public PaginationMenuBar(PaginationBar.PagingListener listener, int pageSize, long size) {
        this.listener = listener;
        this.size = size;
        this.pageSize = pageSize;
        this.pages = (int)Math.ceil(((double)size + 0.0) / ((double)pageSize + 0.0));
        this.setWidth("80px");
        this.initUI();
        this.updateState();
    }

    public void setRowCount(long rowCount) {
        this.size = rowCount;
        this.pages = (int)Math.ceil(((double)this.size + 0.0) / ((double)this.pageSize + 0.0));
        this.updateState();
    }

    public long getRowCount() {
        return this.size;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private void initUI() {
        MenuBar.Command previousCommand = new MenuBar.Command(){

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                PaginationMenuBar.this.currentPage--;
                PaginationMenuBar.this.listener.pageRequested(PaginationMenuBar.this.currentPage);
                PaginationMenuBar.this.updateState();
            }
        };
        MenuBar.Command nextCommand = new MenuBar.Command(){

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                PaginationMenuBar.this.currentPage++;
                PaginationMenuBar.this.listener.pageRequested(PaginationMenuBar.this.currentPage);
                PaginationMenuBar.this.updateState();
            }
        };
        this.menuBar = new MenuBar();
        this.menuBar.setStyleName("pagination-menu-bar");
        this.mainMenu = this.menuBar.addItem(ConsoleMessages.getString("PaginationMenuBar.0"), null, null);
        this.itemNext = this.mainMenu.addItem(ConsoleMessages.getString("Next"), null, nextCommand);
        this.itemNext.setIcon((Resource)FontAwesome.FORWARD);
        this.itemPrev = this.mainMenu.addItem(ConsoleMessages.getString("PaginationMenuBar.1"), null, previousCommand);
        this.itemPrev.setIcon((Resource)FontAwesome.BACKWARD);
        this.addComponent((Component)this.menuBar);
    }

    private void updateState() {
        if (this.pageSize != 0) {
            boolean hasPrev = this.currentPage > 0;
            this.itemPrev.setEnabled(hasPrev);
            boolean hasNext = this.currentPage < this.pages - 1;
            this.itemNext.setEnabled(hasNext);
            this.mainMenu.setText(ConsoleMessages.getString("PaginationMenuBar.2") + (this.currentPage + 1));
        } else {
            this.itemPrev.setEnabled(Boolean.FALSE.booleanValue());
            this.itemNext.setEnabled(Boolean.FALSE.booleanValue());
            this.mainMenu.setText(ConsoleMessages.getString("PaginationMenuBar.0"));
        }
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

