/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.form.inline;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.InputPromptModel;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.GlobalIdGenerator;
import com.google.gson.Gson;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanExplorerGridView;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.BeanInlineEditorView;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.InlineFormEditorWindow;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.page.CloudInputDialog;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class CustomPaymentInlineForm
extends BeanInlineEditorView<CustomPayment> {
    private BeanExplorerGridView<CustomPayment> crudView;
    private InlineFormEditorWindow mainWindow;
    private OutletCombobox cbOutlet;
    private TextField tfName;
    private CheckBox chkEnable;
    private InputPromptGrid inputPromptGrid;
    private CheckBox chkLinkWithBankAccount;

    public CustomPaymentInlineForm() {
    }

    public CustomPaymentInlineForm(BeanExplorerGridView<CustomPayment> crudView, CustomPayment customPayment) {
        this.crudView = crudView;
        this.setBean(customPayment);
    }

    public CustomPaymentInlineForm(BeanExplorerGridView<CustomPayment> crudView, CustomPayment customPayment, InlineFormEditorWindow mainWindow) {
        this.crudView = crudView;
        this.mainWindow = mainWindow;
        this.setBean(customPayment);
    }

    @Override
    protected void doClose() {
        super.doClose();
        if (this.mainWindow != null) {
            this.mainWindow.close();
            BeanItem dataSource = this.binder.getItemDataSource();
            CustomPayment bean = (CustomPayment)dataSource.getBean();
            if (bean.getId() != null) {
                this.crudView.refresh(bean);
            }
        }
        this.crudView.clearSelection();
    }

    @Override
    protected boolean save() {
        try {
            BeanItem dataSource = this.binder.getItemDataSource();
            CustomPayment customPayment = (CustomPayment)dataSource.getBean();
            customPayment.setName(this.getName());
            String outletId = ((Outlet)this.cbOutlet.getValue()).getId();
            GenericDAO.getInstance().checkIdOrNameExists(customPayment.getId(), customPayment.getName(), CustomPayment.class, outletId);
            customPayment.setOutletId(outletId);
            if (StringUtils.isBlank((String)customPayment.getId())) {
                customPayment.setId(GlobalIdGenerator.generateGlobalId());
            }
            customPayment.setConfirmPaymentImmediately(Boolean.valueOf(this.isComfirmPaymentImmediately()));
            customPayment.putInputFieldNameJson(this.getReferenceFieldName());
            customPayment.setEnable(Boolean.valueOf(this.getIsEnable()));
            customPayment.putLinkWithBankAccount(((Boolean)this.chkLinkWithBankAccount.getValue()).booleanValue());
            CustomPaymentDAO.getInstance().saveOrUpdate(customPayment);
            return true;
        }
        catch (PosException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
        }
        catch (StaleStateException e) {
            CloudNotification.showMessageDialogWithReloadButton(this);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("CurrencyForm.3"), ConsoleMessages.getString("CustomPaymentInlineForm.0"), e);
        }
        return false;
    }

    public FormLayout createForm(BeanFieldGroup<CustomPayment> binder) {
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(true);
        formLayout.setMargin(true);
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
            }
        };
        this.cbOutlet.setCaption(ConsoleMessages.getString("OUTLET"));
        formLayout.addComponent((Component)this.cbOutlet);
        this.tfName = new TextField(POSConstants.NAME);
        this.tfName.setNullRepresentation("");
        this.tfName.addStyleName("custom-width");
        this.inputPromptGrid = new InputPromptGrid();
        this.inputPromptGrid.setHeight("250px");
        HorizontalLayout buttonContainer = new HorizontalLayout();
        buttonContainer.setSpacing(true);
        CloudButton btnAdd = CommonUIUtil.createColorButton("Add");
        btnAdd.addClickListener((Button.ClickListener & Serializable)event -> this.doAddPrompt());
        CloudButton btnEdit = CommonUIUtil.createColorButton("Edit");
        btnEdit.addClickListener((Button.ClickListener & Serializable)event -> this.doEditPrompt());
        CloudButton btnDelete = CommonUIUtil.createColorButton("Delete");
        btnDelete.addClickListener((Button.ClickListener & Serializable)event -> this.doDeletePrompt());
        buttonContainer.addComponents(new Component[]{btnAdd, btnEdit, btnDelete});
        this.chkEnable = new CheckBox(POSConstants.ENABLE_OPTION_LABEL);
        this.chkLinkWithBankAccount = new CheckBox("Link with bank account");
        formLayout.addComponents(new Component[]{this.tfName, this.inputPromptGrid, buttonContainer, this.chkEnable, this.chkLinkWithBankAccount});
        this.updateView((CustomPayment)this.getBean());
        return formLayout;
    }

    private void doDeletePrompt() {
        InputPromptModel selectedValue = (InputPromptModel)this.inputPromptGrid.getSelectedRow();
        if (selectedValue == null) {
            return;
        }
        this.inputPromptGrid.remove(selectedValue);
    }

    private void doEditPrompt() {
        InputPromptModel selectedValue = (InputPromptModel)this.inputPromptGrid.getSelectedRow();
        if (selectedValue == null) {
            return;
        }
        CloudInputDialog cloudInputDialog = new CloudInputDialog("Input field name");
        cloudInputDialog.setTfvalue(selectedValue.getFieldName());
        cloudInputDialog.setSize(350, 150);
        cloudInputDialog.open();
        cloudInputDialog.addCloseListener((Window.CloseListener & Serializable)e -> {
            if (cloudInputDialog.isCanceled()) {
                return;
            }
            String inputValue = cloudInputDialog.getTfvalue();
            if (StringUtils.isNotBlank((String)inputValue)) {
                selectedValue.setFieldName(inputValue);
                this.inputPromptGrid.refreshRows(new Object[]{selectedValue});
            }
        });
    }

    private void doAddPrompt() {
        CloudInputDialog cloudInputDialog = new CloudInputDialog("Input field name");
        cloudInputDialog.setSize(350, 150);
        cloudInputDialog.open();
        cloudInputDialog.addCloseListener((Window.CloseListener & Serializable)e -> {
            if (cloudInputDialog.isCanceled()) {
                return;
            }
            String inputValue = cloudInputDialog.getTfvalue();
            if (StringUtils.isNotBlank((String)inputValue)) {
                InputPromptModel inputPromptModel = new InputPromptModel(inputValue);
                this.inputPromptGrid.addOrUpdateItem(inputPromptModel, -1);
            }
        });
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
    }

    public void updateView(CustomPayment payment) {
        if (payment == null) {
            return;
        }
        this.tfName.setValue(payment.getName());
        this.inputPromptGrid.setItems(payment.getInputPromptList());
        this.chkEnable.setValue((Object)payment.isEnable());
        this.chkLinkWithBankAccount.setValue((Object)payment.isLinkWithBankAccount());
    }

    @Override
    protected boolean doCheckValidation() {
        if (this.tfName.getValue() == null || StringUtils.isBlank((String)((String)this.tfName.getValue()).trim())) {
            CloudNotification.showErrorMessage(ConsoleMessages.getString("CustomPaymentInlineForm.3"));
            this.tfName.selectAll();
            this.tfName.focus();
            return true;
        }
        return false;
    }

    public String getName() {
        String value = (String)this.tfName.getValue();
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        return value.trim();
    }

    public String getReferenceFieldName() {
        ArrayList<InputPromptModel> inputPromptList = new ArrayList<InputPromptModel>();
        for (int i = 0; i < this.inputPromptGrid.getRowCount(); ++i) {
            InputPromptModel inputPromptModel = (InputPromptModel)this.inputPromptGrid.getContainer().getIdByIndex(i);
            inputPromptModel.setSortOrder(i);
            inputPromptList.add(inputPromptModel);
        }
        return new Gson().toJson(inputPromptList);
    }

    public boolean isComfirmPaymentImmediately() {
        return true;
    }

    public boolean getIsEnable() {
        return (Boolean)this.chkEnable.getValue();
    }

    private class InputPromptGrid
    extends BeanGrid<InputPromptModel> {
        public InputPromptGrid() {
            this.addColumn("Input Prompt", "fieldName");
            this.removeHeaderSort();
        }

        @Override
        public boolean hidePagination() {
            return true;
        }

        @Override
        public Class getReferenceClass() {
            return InputPromptModel.class;
        }
    }
}

