/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.form.inline;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BankAccountDAO;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanExplorerGridView;
import com.orocube.siiopa.cloud.client.BeanInlineEditorView;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.InlineFormEditorWindow;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class BankAccountInlineForm
extends BeanInlineEditorView<BankAccount> {
    private BeanExplorerGridView<BankAccount> crudView;
    private InlineFormEditorWindow mainWindow;
    private SiiopaTextField tfBankName;
    private SiiopaTextField tfAccountName;
    private SiiopaTextField tfBankBranchName;
    private SiiopaTextField tfAccountNumber;
    private SiiopaTextField tfBankBranchAddress;
    private SiiopaTextField tfBankBranchPhone;
    private SiiopaTextField tfBankBranchEmail;
    private OutletCombobox cbOutlet;
    private CheckBox chkEnable;
    private SiiopaTextField tfBankBalance;

    public BankAccountInlineForm() {
    }

    public BankAccountInlineForm(BeanExplorerGridView<BankAccount> crudView, BankAccount bankAccount) {
        this.crudView = crudView;
        this.setBean(bankAccount);
    }

    public BankAccountInlineForm(BeanExplorerGridView<BankAccount> crudView, BankAccount bankAccount, InlineFormEditorWindow mainWindow) {
        this.crudView = crudView;
        this.mainWindow = mainWindow;
        this.setBean(bankAccount);
    }

    @Override
    protected void doClose() {
        super.doClose();
        if (this.mainWindow != null) {
            this.mainWindow.close();
            BeanItem dataSource = this.binder.getItemDataSource();
            BankAccount bean = (BankAccount)dataSource.getBean();
            if (bean.getId() != null) {
                this.crudView.refresh(bean);
            }
        }
        this.crudView.clearSelection();
    }

    @Override
    protected boolean save() {
        try {
            BeanItem dataSource = this.binder.getItemDataSource();
            BankAccount bankAcccount = (BankAccount)dataSource.getBean();
            bankAcccount.setBankName(StringUtils.isNotBlank((String)this.tfBankName.getValue()) ? this.tfBankName.getValue().trim() : this.tfBankName.getValue());
            bankAcccount.setAccountName(StringUtils.isNotBlank((String)this.tfAccountName.getValue()) ? this.tfAccountName.getValue().trim() : this.tfAccountName.getValue());
            bankAcccount.setAccountNo(StringUtils.isNotBlank((String)this.tfAccountNumber.getValue()) ? this.tfAccountNumber.getValue().trim() : this.tfAccountNumber.getValue());
            bankAcccount.setBankBranch(this.tfBankBranchName.getValue());
            bankAcccount.setBankAddress(this.tfBankBranchAddress.getValue());
            bankAcccount.setBankPhone(this.tfBankBranchPhone.getValue());
            bankAcccount.setEmail(this.tfBankBranchEmail.getValue());
            String outletId = ((Outlet)this.cbOutlet.getValue()).getId();
            bankAcccount.setOutletId(outletId);
            if (this.getIsEnable()) {
                bankAcccount.setActivationDate(new Date());
                bankAcccount.setDeActivationDate(null);
            } else {
                bankAcccount.setDeActivationDate(new Date());
            }
            bankAcccount.setActive(Boolean.valueOf(this.getIsEnable()));
            bankAcccount.setCreateDate(bankAcccount.getCreateDate() == null ? new Date() : null);
            BankAccountDAO.getInstance().saveOrUpdate(bankAcccount);
            return true;
        }
        catch (PosException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
        }
        catch (StaleStateException e) {
            CloudNotification.showMessageDialogWithReloadButton(this);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("CurrencyForm.3"), "Could not save bank account. Please try again", e);
        }
        return false;
    }

    public FormLayout createForm(BeanFieldGroup<BankAccount> binder) {
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(true);
        formLayout.setMargin(true);
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
            }
        };
        this.cbOutlet.setCaption(ConsoleMessages.getString("OUTLET"));
        formLayout.addComponent((Component)this.cbOutlet);
        this.tfBankName = new SiiopaTextField("Bank Name");
        this.tfBankName.setWidth("100%");
        this.tfBankName.setRequired(true);
        this.tfAccountName = new SiiopaTextField("A/C Name");
        this.tfAccountName.setWidth("100%");
        this.tfAccountName.setRequired(true);
        this.tfAccountNumber = new SiiopaTextField("A/C No");
        this.tfAccountNumber.setWidth("100%");
        this.tfAccountNumber.setRequired(true);
        this.tfBankBranchAddress = new SiiopaTextField("Address");
        this.tfBankBranchAddress.setWidth("100%");
        this.tfBankBranchName = new SiiopaTextField("Branch name");
        this.tfBankBranchName.setWidth("100%");
        this.tfBankBranchName.setRequired(true);
        this.tfBankBranchPhone = new SiiopaTextField("Phone");
        this.tfBankBranchPhone.setWidth("100%");
        this.tfBankBranchEmail = new SiiopaTextField("Email");
        this.tfBankBranchEmail.setWidth("100%");
        this.tfBankBalance = new SiiopaTextField("Balance");
        this.tfBankBalance.setWidth("100%");
        this.chkEnable = new CheckBox(POSConstants.ENABLE_OPTION_LABEL);
        formLayout.addComponents(new Component[]{this.tfBankName, this.tfAccountName, this.tfAccountNumber, this.tfBankBranchName, this.tfBankBranchAddress, this.tfBankBranchPhone, this.tfBankBranchEmail, this.tfBankBalance, this.chkEnable});
        this.updateView((BankAccount)this.getBean());
        return formLayout;
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
    }

    public void updateView(BankAccount bankAccount) {
        if (bankAccount == null) {
            return;
        }
        boolean isNewBankAccount = StringUtils.isBlank((String)bankAccount.getId());
        this.tfBankName.setValue(StringUtils.isBlank((String)bankAccount.getBankName()) ? "" : bankAccount.getBankName());
        this.tfAccountName.setValue(StringUtils.isBlank((String)bankAccount.getAccountName()) ? "" : bankAccount.getAccountName());
        this.tfAccountNumber.setValue(StringUtils.isBlank((String)bankAccount.getAccountNo()) ? "" : bankAccount.getAccountNo());
        this.tfBankBranchName.setValue(StringUtils.isBlank((String)bankAccount.getBankBranch()) ? "" : bankAccount.getBankBranch());
        this.tfBankBranchAddress.setValue(StringUtils.isBlank((String)bankAccount.getBankAddress()) ? "" : bankAccount.getBankAddress());
        this.tfBankBranchPhone.setValue(StringUtils.isBlank((String)bankAccount.getBankPhone()) ? "" : bankAccount.getBankPhone());
        this.tfBankBranchEmail.setValue(StringUtils.isBlank((String)bankAccount.getEmail()) ? "" : bankAccount.getEmail());
        this.tfBankBalance.setValue(NumberUtil.formatAmount((Double)bankAccount.getBalance()));
        this.tfBankBalance.setReadOnly(true);
        this.chkEnable.setValue((Object)bankAccount.isActive());
        if (isNewBankAccount) {
            this.chkEnable.setValue((Object)true);
            this.tfBankBalance.setVisible(false);
        } else {
            this.tfBankBalance.setVisible(true);
        }
        this.tfAccountName.setEnabled(isNewBankAccount);
        this.tfAccountNumber.setEnabled(isNewBankAccount);
    }

    @Override
    protected boolean doCheckValidation() {
        boolean exists;
        BeanItem dataSource = this.binder.getItemDataSource();
        BankAccount bankAcccount = (BankAccount)dataSource.getBean();
        String outletId = ((Outlet)this.cbOutlet.getValue()).getId();
        String accountNumber = this.tfAccountNumber.getValue();
        if (StringUtils.isNotBlank((String)accountNumber) && (exists = BankAccountDAO.getInstance().isAccountExists(bankAcccount.getId(), this.tfBankName.getValue(), accountNumber, outletId))) {
            CloudNotification.showErrorMessage("Duplicate Account found within same bank.");
            return true;
        }
        if (StringUtils.isBlank((String)this.tfBankName.getValue())) {
            CloudNotification.showErrorMessage("Bank name can't be empty");
            this.tfBankName.focus();
            return true;
        }
        if (StringUtils.isBlank((String)this.tfAccountName.getValue())) {
            CloudNotification.showErrorMessage("Account name name can't be empty");
            this.tfAccountName.focus();
            return true;
        }
        if (StringUtils.isBlank((String)this.tfBankBranchName.getValue())) {
            CloudNotification.showErrorMessage("Branch name can't be empty");
            this.tfBankBranchName.focus();
            return true;
        }
        return false;
    }

    public boolean getIsEnable() {
        return (Boolean)this.chkEnable.getValue();
    }
}

