/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.action;

import com.floreantpos.POSConstants;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.YesNoDialog;

public class DeleteCustomPaymentAction
implements YesNoDialog.Callback {
    BeanGrid<CustomPayment> customPaymentGrid;
    private CustomPayment customPayment;

    public DeleteCustomPaymentAction(CustomPayment customPayment) {
        this.customPayment = customPayment;
    }

    public DeleteCustomPaymentAction(BeanGrid<CustomPayment> customPaymentGrid, CustomPayment customPayment) {
        this.customPaymentGrid = customPaymentGrid;
        this.customPayment = customPayment;
    }

    public void execute() {
        try {
            CloudNotification.showYesNoDialog(POSConstants.DELETE, POSConstants.CONFIRM_DELETE, this);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
        }
    }

    @Override
    public void dialogClosed(boolean isApproved) {
        if (isApproved) {
            this.onApprove();
        }
    }

    public void onApprove() {
        try {
            CustomPaymentDAO.getInstance().delete(this.customPayment);
            CloudNotification.showMessage(ConsoleMessages.getString("DeletedSuccessfully"));
            if (this.customPaymentGrid != null) {
                this.customPaymentGrid.getContainerDataSource().removeItem((Object)this.customPayment);
                this.customPaymentGrid.getSelectionModel().reset();
            }
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            return;
        }
    }
}

