/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.POSConstants;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class PayoutReportGrid
extends FooterSupportedBeanGrid<PayOutTransaction> {
    public PayoutReportGrid() {
        this.addColumn("Payout ID", PayOutTransaction.PROP_ID, String.class);
        this.addColumn(POSConstants.DATE, "dateDisplayString", String.class);
        this.addColumn("Paid by", "user", String.class);
        this.addColumn("Payout Recipient", "recepientDisplay", String.class);
        this.addColumn("Payout Reason", "reasonDisplay", String.class);
        this.addColumn("Note", PayOutTransaction.PROP_NOTE, String.class);
        this.addColumn("Batch No", PosTransaction.PROP_BATCH_NO, String.class);
        this.addColumn("Amount", PayOutTransaction.PROP_AMOUNT, Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.showSummaryRow(PayOutTransaction.PROP_AMOUNT, PayOutTransaction.PROP_ID, "dateDisplayString", "user", "recepientDisplay", "reasonDisplay", PayOutTransaction.PROP_NOTE, PosTransaction.PROP_BATCH_NO);
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
    }

    @Override
    public void setItems(Collection<PayOutTransaction> items) {
        super.setItems(items);
        double totalAmount = 0.0;
        if (items != null && items.size() > 0) {
            for (PosTransaction posTransaction : items) {
                totalAmount += posTransaction.getAmount().doubleValue();
            }
        }
        super.updateView(totalAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PayOutTransaction.class;
    }
}

