/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.server.security;

import com.floreantpos.PosLog;
import com.floreantpos.jdbc.SchemaResolver;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SiiopaCustomer;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.WebServiceClient;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.CityResponse;
import com.orocube.siiopa.cloud.server.CloudDataProvider;
import com.orocube.siiopa.cloud.server.CloudResourceCache;
import com.orocube.workspace.subscription.SubscriptionFeature;
import com.orocube.workspace.subscription.SubscriptionPlan;
import com.orocube.workspace.subscription.SubscriptionProduct;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.io.File;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public final class CurrentSession {
    public static final String WEB_INF_RESOURCES = "/WEB-INF/resources/";
    public static final String CURRENT_USER_SESSION_ATTRIBUTE_KEY = CurrentSession.class.getCanonicalName();
    public static final String CURRENT_USER_TICKET_SESSION_ATTRIBUTE_KEY = Ticket.class.getCanonicalName();
    private static boolean visibleActionButtons = true;
    private static ThreadLocal<HttpServletRequest> requestThread = new ThreadLocal();

    private CurrentSession() {
    }

    public static boolean isLoggedIn() {
        return CurrentSession.getStore() != null && CurrentSession.getStoreSchema() != null;
    }

    public static void setSiiopaCustomer(SiiopaCustomer customer) {
    }

    public static SiiopaCustomer getSiiopaCustomer() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (SiiopaCustomer)VaadinSession.getCurrent().getAttribute("siiopa-customer");
    }

    private static void setUser(User currentUser) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        if (currentUser == null) {
            CurrentSession.setShowWelcomeDialog(Boolean.TRUE);
        }
        VaadinSession.getCurrent().setAttribute(User.class, (Object)currentUser);
    }

    public static User getUser() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (User)VaadinSession.getCurrent().getAttribute(User.class);
    }

    private static void setSelectedOutlet(Outlet outlet) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        Object attribute = VaadinSession.getCurrent().getAttribute(Outlet.REF);
        if (attribute != null && attribute.equals(outlet)) {
            return;
        }
        VaadinSession.getCurrent().setAttribute(Outlet.REF, (Object)outlet);
        if (outlet != null) {
            CloudDataProvider.get().initialize();
        }
    }

    public static Outlet getSelectedOutlet() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (Outlet)VaadinSession.getCurrent().getAttribute(Outlet.REF);
    }

    public static void setSelectedOutletId(String outletId) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        CurrentSession.setSelectedOutlet(OutletDAO.getInstance().get(outletId));
    }

    public static String getSelectedOutletId() {
        Outlet selectedOutlet = CurrentSession.getSelectedOutlet();
        if (selectedOutlet != null) {
            return selectedOutlet.getId();
        }
        return null;
    }

    public static String getCurrentSchema() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (String)VaadinSession.getCurrent().getAttribute("storeId");
    }

    public static void setCurrentSchema(String currentSchema) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        VaadinSession.getCurrent().setAttribute("storeId", (Object)currentSchema);
    }

    public static void clear() {
        SchemaResolver.setTenant(null);
        CurrentSession.setUser(null);
        CurrentSession.setCurrentSchema(null);
        CurrentSession.setStore(null);
        CurrentSession.setSelectedOutlet(null);
        CurrentSession.setSiiopaCustomer(null);
        VaadinSession.getCurrent().setAttribute("data_provider", null);
    }

    public static void setStore(Store store) {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession == null) {
            return;
        }
        if (store == null) {
            vaadinSession.setAttribute("store", null);
            vaadinSession.setAttribute("storeSchema", null);
            vaadinSession.setAttribute("storeUrl", null);
        } else {
            vaadinSession.setAttribute("store", (Object)store);
            vaadinSession.setAttribute("storeSchema", (Object)store.getUuid());
            vaadinSession.setAttribute("storeUrl", (Object)store.getFriendlyUid());
        }
    }

    public static Store getStore() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (Store)VaadinSession.getCurrent().getAttribute("store");
    }

    public static String getStoreSchema() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        String storeSchema = (String)VaadinSession.getCurrent().getAttribute("storeSchema");
        if (StringUtils.isNotBlank((String)storeSchema)) {
            return storeSchema;
        }
        return null;
    }

    public static String getStoreUrl() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (String)VaadinSession.getCurrent().getAttribute("storeUrl");
    }

    public static void setUserAgentInfo(String userAgentInfo) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        VaadinSession.getCurrent().setAttribute("userAgent", (Object)userAgentInfo);
    }

    public static String getUserAgentInfo() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (String)VaadinSession.getCurrent().getAttribute("userAgent");
    }

    public static void setDataProvider(DataProvider dataProvider) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        VaadinSession.getCurrent().setAttribute("data_provider", (Object)dataProvider);
    }

    public static void setLoginData(Store store, User user) {
        String userOutletId;
        CloudDataProvider dataProvider = new CloudDataProvider();
        CurrentSession.setDataProvider(dataProvider);
        CurrentSession.setStore(store);
        CurrentSession.setUser(user);
        String string = userOutletId = user == null ? null : user.getOutletId();
        if (StringUtils.isNotBlank((String)userOutletId)) {
            CurrentSession.setSelectedOutletId(userOutletId);
        } else {
            CurrentSession.setSelectedOutletId(StoreDAO.getInstance().getDefaultOutlet().getId());
        }
    }

    public static void invalidate() {
        CurrentSession.clear();
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession != null) {
            if (vaadinSession.getSession() != null) {
                vaadinSession.getSession().invalidate();
            }
            vaadinSession.close();
        }
    }

    public static String getClientIpAddress() {
        String ip = UI.getCurrent().getPage().getWebBrowser().getAddress();
        if (StringUtils.isNotBlank((String)ip)) {
            if ("127.0.0.1".equals(ip)) {
                return "103.197.205.65";
            }
            return ip;
        }
        return CurrentSession.getClientIpAddressFromRequestHeader();
    }

    public static String getClientIpAddressFromRequestHeader() {
        String[] HEADERS_TO_TRY;
        VaadinRequest request = VaadinService.getCurrentRequest();
        if (request == null) {
            return null;
        }
        for (String header : HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"}) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CityResponse getClientCity() {
        Throwable throwable;
        String clientIpAddress = CurrentSession.getClientIpAddress();
        CloudResourceCache cloudResourceCache = CloudResourceCache.get();
        if (cloudResourceCache != null && cloudResourceCache.isMaxMindLocalDBEnabled() != null && cloudResourceCache.isMaxMindLocalDBEnabled().booleanValue()) {
            try {
                throwable = null;
                try (DatabaseReader reader = new DatabaseReader.Builder(CurrentSession.readCityDBFile()).build();){
                    CityResponse response = reader.city(InetAddress.getByName(clientIpAddress));
                    if (response != null && response.getCountry() != null) {
                        CityResponse cityResponse2 = response;
                        return cityResponse2;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (AddressNotFoundException e) {
                PosLog.error(CurrentSession.class, (String)("Address not found for IP: " + clientIpAddress));
            }
            catch (Exception e) {
                PosLog.error(CurrentSession.class, (Exception)e);
            }
        }
        try {
            throwable = null;
            try (WebServiceClient client = new WebServiceClient.Builder(cloudResourceCache.getMaxMindUserId().intValue(), cloudResourceCache.getMaxMindApiKey()).build();){
                CityResponse cityResponse = client.city(InetAddress.getByName(clientIpAddress));
                return cityResponse;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
        catch (AddressNotFoundException e) {
            PosLog.error(CurrentSession.class, (String)("Address not found for IP: " + clientIpAddress));
            return null;
        }
        catch (Exception e) {
            PosLog.error(CurrentSession.class, (Exception)e);
        }
        return null;
    }

    private static File readCityDBFile() {
        return new File(VaadinServlet.getCurrent().getServletContext().getRealPath("/WEB-INF/resources/GeoLite2-City.mmdb"));
    }

    public static void setVisibleActionButtons(boolean visibleActionButtons) {
        CurrentSession.visibleActionButtons = visibleActionButtons;
    }

    public static boolean isProductionMode() {
        return visibleActionButtons;
    }

    public static HttpServletRequest getServletRequest() {
        return requestThread.get();
    }

    public static void setServletRequest(HttpServletRequest request) {
        requestThread.set(request);
    }

    public static boolean hasMultioutletSubscription() {
        return true;
    }

    public static boolean hasPosIntegration() {
        return CurrentSession.isSubscriptionEnabled(SubscriptionProduct.Menugreat, SubscriptionFeature.POSIntegration);
    }

    public static boolean isSubscriptionEnabled(SubscriptionProduct product, SubscriptionFeature subscriptionFeature) {
        return true;
    }

    public static boolean isMenugreatAndHasPosIntegration() {
        return CloudResourceCache.get().isMenugreat() && CurrentSession.hasPosIntegration();
    }

    public static SubscriptionPlan getMenugreatOrSiiopaPricingPlan() {
        return CurrentSession.getPricingPlan(CloudResourceCache.get().isSiiopa() ? SubscriptionProduct.Siiopa : SubscriptionProduct.Menugreat);
    }

    public static void setPricingPlan(SubscriptionProduct product, SubscriptionPlan subscriptionPlan) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        VaadinSession.getCurrent().setAttribute("pricing_plan." + product.getId(), (Object)(subscriptionPlan == null ? null : subscriptionPlan.getId()));
    }

    public static SubscriptionPlan getPricingPlan(SubscriptionProduct product) {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        String pricingPlan = String.valueOf(VaadinSession.getCurrent().getAttribute("pricing_plan." + product.getId()));
        SubscriptionPlan subscriptionPlan = SubscriptionPlan.getById((String)pricingPlan);
        if (subscriptionPlan == null) {
            return SubscriptionPlan.getStarterPlan((boolean)CloudResourceCache.get().isSiiopa());
        }
        return subscriptionPlan;
    }

    public static boolean hasEmployeeManagementSubscription() {
        return CurrentSession.isSubscriptionEnabled(CloudResourceCache.get().isSiiopa() ? SubscriptionProduct.Siiopa : SubscriptionProduct.Menugreat, SubscriptionFeature.EmployeeUnlimited);
    }

    public static void setRegisterData(Store store) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        VaadinSession.getCurrent().setAttribute("register_data", (Object)store);
    }

    public static Store getRegisterData() {
        if (VaadinSession.getCurrent() == null) {
            return null;
        }
        return (Store)VaadinSession.getCurrent().getAttribute("register_data");
    }

    public static void setShowWelcomeDialog(Boolean visibleWelcomeDialog) {
        if (VaadinSession.getCurrent() == null) {
            return;
        }
        VaadinSession.getCurrent().setAttribute("welcome_dialog.show", (Object)visibleWelcomeDialog);
    }

    public static boolean shouldShowWelcomeDialog() {
        if (VaadinSession.getCurrent() == null) {
            return false;
        }
        Object visibleWelcomeDialog = VaadinSession.getCurrent().getAttribute("welcome_dialog.show");
        return visibleWelcomeDialog == null ? true : POSUtil.getBoolean((String)visibleWelcomeDialog.toString(), (boolean)true);
    }
}

