/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.POSConstants;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class BankAccountTransactionReportGrid
extends FooterSupportedBeanGrid<BalanceUpdateTransaction> {
    public BankAccountTransactionReportGrid() {
        this.addColumn(POSConstants.DATE, "transactionTimeDisplay", String.class);
        this.addColumn("Description", "descriptionDisplay", String.class);
        this.addColumn("Order/Employee ID", "orderIdOrEmployeeId", String.class);
        this.addColumn("Note", "noteDisplay", String.class);
        this.addColumn("Amount", BalanceUpdateTransaction.PROP_AMOUNT, String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.showSummaryRow(BalanceUpdateTransaction.PROP_AMOUNT, "transactionTimeDisplay", "descriptionDisplay", "orderIdOrEmployeeId", "noteDisplay");
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
        this.getColumn(BalanceUpdateTransaction.PROP_AMOUNT).setWidth(180.0);
        this.getColumn("descriptionDisplay").setMaximumWidth(420.0);
    }

    @Override
    public void setItems(Collection<BalanceUpdateTransaction> items) {
        super.setItems(items);
        double totalAmount = 0.0;
        if (items != null && items.size() > 0) {
            for (BalanceUpdateTransaction posTransaction : items) {
                totalAmount += posTransaction.getAmount().doubleValue();
            }
        }
        super.updateView(totalAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return BalanceUpdateTransaction.class;
    }
}

