/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.inventory.view;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.UnitType;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanExplorerMultiSelectGridView;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.crud.inventory.grid.InventoryStockSummaryGrid;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InventoryStockSummaryCrudView
extends BeanExplorerMultiSelectGridView<InventoryStock> {
    public static final String VIEW_NAME = "Stock summary";
    private OutletCombobox cbOutlet;
    private TextField tfNameField;
    private Button btnSearch;
    private VerticalLayout mainTopLayout;
    private String menuitemId;
    private InventoryStockSummaryGrid inventoryStockGrid;

    @Override
    public VerticalLayout createTopBar() {
        CssLayout topLayout = new CssLayout();
        this.mainTopLayout = new VerticalLayout();
        this.mainTopLayout.setWidth("100%");
        ShortcutListener shortcutListener = new ShortcutListener(ConsoleMessages.getString("ShopTableCrudView.1"), 13, null){

            public void handleAction(Object sender, Object target) {
                PosLog.debug(InventoryStockSummaryCrudView.class, (String)"button shortcut listener fired");
                if (target == InventoryStockSummaryCrudView.this.btnSearch) {
                    InventoryStockSummaryCrudView.this.doSearch();
                }
            }
        };
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                InventoryStockSummaryCrudView.this.doSearch();
            }
        };
        this.tfNameField = new TextField();
        this.tfNameField.setMaxLength(120);
        this.tfNameField.setInputPrompt(ConsoleMessages.getString("InventoryStockCrudView.0"));
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("MenuModifierCrudView.6"));
        this.btnSearch = CommonUIUtil.createColorButton("");
        this.btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        this.btnSearch.addShortcutListener(shortcutListener);
        this.btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.doSearch());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET") + " :", (Component)this.cbOutlet));
        if (this.cbOutlet.isVisible()) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("", (Component)this.tfNameField));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout(this.btnSearch, (Object)btnClear));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.doSearch();
        });
        this.mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        return this.mainTopLayout;
    }

    private void doClear() {
        this.tfNameField.setValue("");
    }

    private void doSearch() {
        this.reloadPage();
    }

    @Override
    public void clearSelection() {
        this.grid.getSelectionModel().reset();
    }

    public InventoryStock getSelectedRow() {
        List<InventoryStock> selectedInventoryStocks = this.getSelectedInventoryStocks();
        return selectedInventoryStocks.isEmpty() ? null : selectedInventoryStocks.get(0);
    }

    @Override
    protected void doCreateNewItem() {
    }

    @Override
    protected void doEditItem(Collection<Object> selectedRows) {
        this.setInlineFromVisible(false);
    }

    @Override
    protected void doDeleteItems(Collection<Object> selectedRows) {
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.inventoryStockGrid = new InventoryStockSummaryGrid();
        this.inventoryStockGrid.addStyleName("custom-grid-cell-focus");
        return this.inventoryStockGrid;
    }

    @Override
    protected void addButton(HorizontalLayout buttonLayout) {
        buttonLayout.removeAllComponents();
    }

    public List<InventoryStock> getSelectedInventoryStocks() {
        ArrayList<InventoryStock> inventoryStocks = new ArrayList<InventoryStock>();
        Collection selectedRows = this.grid.getSelectedRows();
        if (selectedRows != null) {
            for (Object object : selectedRows) {
                if (!(object instanceof InventoryStock)) continue;
                inventoryStocks.add((InventoryStock)object);
            }
        }
        return inventoryStocks;
    }

    @Override
    public void updateView(Pagination<InventoryStock> pagination) {
        try {
            String name = (String)this.tfNameField.getValue();
            HashMap<String, IUnit> unitMap = new HashMap<String, IUnit>();
            String outletId = this.getSelectedOutlet() == null ? "" : this.getSelectedOutlet().getId();
            InventoryStockDAO.getInstance().getInventoryStockSummary(pagination, name, this.menuitemId, outletId);
            List dataList = pagination.getDataList();
            HashMap<String, InventoryStock> dataMap = new HashMap<String, InventoryStock>();
            double totalQty = 0.0;
            for (InventoryStock inventoryStock : dataList) {
                double convertQtyToEach;
                InventoryStock mapInventoryStock;
                IUnit sourceInvUnit;
                IUnit destInvUnit;
                String key = inventoryStock.getMenuItemId() + "_" + inventoryStock.getOutletId();
                String unitId = inventoryStock.getUnit();
                String unitType = inventoryStock.getUnitType();
                if (StringUtils.isBlank((String)unitId)) {
                    unitId = "each";
                }
                String destInvUnitId = "each";
                MenuItem menuItem = inventoryStock.getMenuItem();
                if (menuItem != null && StringUtils.isNotBlank((String)menuItem.getUnitId())) {
                    destInvUnitId = menuItem.getUnitId();
                }
                if ((destInvUnit = (IUnit)unitMap.get(destInvUnitId)) == null) {
                    destInvUnit = DataProvider.get().getUnitById(destInvUnitId, UnitType.UNIT.name());
                    if (destInvUnit != null) {
                        unitMap.put(destInvUnit.getId(), destInvUnit);
                        inventoryStock.setUnitCodeDisplay(destInvUnit.getName());
                    }
                } else {
                    inventoryStock.setUnitCodeDisplay(destInvUnit.getName());
                }
                if ((sourceInvUnit = (IUnit)unitMap.get(unitId)) == null && (sourceInvUnit = DataProvider.get().getUnitById(unitId, unitType)) != null) {
                    unitMap.put(sourceInvUnit.getId(), sourceInvUnit);
                }
                if ((mapInventoryStock = (InventoryStock)dataMap.get(key)) == null) {
                    convertQtyToEach = this.convertQtyToEach(inventoryStock, sourceInvUnit, destInvUnit, menuItem);
                    inventoryStock.setQuantityInHand(Double.valueOf(convertQtyToEach));
                    dataMap.put(key, inventoryStock);
                } else {
                    convertQtyToEach = this.convertQtyToEach(inventoryStock, sourceInvUnit, destInvUnit, menuItem);
                    mapInventoryStock.setQuantityInHand(Double.valueOf(mapInventoryStock.getQuantityInHand() + convertQtyToEach));
                }
                totalQty += inventoryStock.getQuantityInHand().doubleValue();
            }
            this.grid.setItems(new ArrayList(dataMap.values()));
            this.inventoryStockGrid.updateFooterCellValue(totalQty);
        }
        catch (PosException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
        }
    }

    private double convertQtyToEach(InventoryStock sourceInvStock, IUnit sourceInvUnit, IUnit destInvUnit, MenuItem menuItem) {
        double unitQty = InventoryUnitConvertionUtil.getUnitQuantity((IUnit)sourceInvUnit, (IUnit)destInvUnit, (MenuItem)menuItem);
        return sourceInvStock.getQuantityInHand() * unitQty;
    }

    public Outlet getSelectedOutlet() {
        return this.cbOutlet.getSelectedOrDefaultOutlet();
    }

    public void setVisibleTopLayout(boolean visible) {
        this.mainTopLayout.setVisible(visible);
    }

    public void setMenuitemId(String menuitemId) {
        this.menuitemId = menuitemId;
    }
}

