/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.report.model.ByzlogicsProjectReportData;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ProjectReportGrid
extends FooterSupportedBeanGrid<ByzlogicsProjectReportData> {
    private Grid.FooterCell totalAmountCell;
    private Grid.FooterCell totalPaidAmountCell;
    private Grid.FooterCell totalDueAmountCell;

    public ProjectReportGrid() {
        this.addColumn("Time", "date", String.class);
        this.addColumn("Performed by", "performerName", String.class);
        this.addColumn("Type", "type", String.class);
        this.addColumn("Project", "projectName", String.class);
        this.addColumn("Recipient", "expenseRecipient", String.class);
        this.addColumn("Category", "category", String.class);
        this.addColumn("Sub category", "subCategory", String.class);
        this.addColumn("Description", "description", String.class);
        this.addColumn("Total", "totalAmountDisplay", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.addColumn("Paid amount", "paidAmountDisplay", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.addColumn("Due amount", "dueAmountDisplay", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.showSummaryRow("date", "performerName", "type", "projectName", "expenseRecipient", "category", "subCategory", "description");
        this.totalAmountCell = this.createSummaryCell("totalAmountDisplay");
        this.totalPaidAmountCell = this.createSummaryCell("paidAmountDisplay");
        this.totalDueAmountCell = this.createSummaryCell("dueAmountDisplay");
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
    }

    @Override
    public void setItems(Collection<ByzlogicsProjectReportData> items) {
        super.setItems(items);
        this.calculateTotalAmount(items);
    }

    public void calculateTotalAmount(Collection<ByzlogicsProjectReportData> projectReportDataList) {
        double totalAmount = 0.0;
        double totalPaidAmount = 0.0;
        double totalDueAmount = 0.0;
        if (projectReportDataList != null && projectReportDataList.size() > 0) {
            for (ByzlogicsProjectReportData projectReportData : projectReportDataList) {
                String type = projectReportData.getType();
                if (StringUtils.isNotBlank((CharSequence)type) && (type.equalsIgnoreCase("Purchase") || type.equalsIgnoreCase("Expense") || type.equalsIgnoreCase("Purchase due paid"))) {
                    totalAmount -= projectReportData.getTotalAmount();
                    totalPaidAmount -= projectReportData.getPaidAmount();
                    totalDueAmount -= projectReportData.getDueAmount();
                    continue;
                }
                totalAmount += projectReportData.getTotalAmount();
                totalPaidAmount += projectReportData.getPaidAmount();
                totalDueAmount += projectReportData.getDueAmount();
            }
        }
        this.updateAccountingCellValue(this.totalAmountCell, totalAmount);
        this.updateAccountingCellValue(this.totalPaidAmountCell, totalPaidAmount);
        this.updateAccountingCellValue(this.totalDueAmountCell, totalDueAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return ByzlogicsProjectReportData.class;
    }

    @Override
    public void clearFooterCell() {
        this.updateCellValue(this.totalAmountCell, 0.0);
        this.updateCellValue(this.totalPaidAmountCell, 0.0);
        this.updateCellValue(this.totalDueAmountCell, 0.0);
    }
}

