/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.BankAccountDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.BankAccountTransactionReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class BankAccountTransactionReportView
extends ReportView {
    public static final String VIEW_NAME = "Bank account transaction report";
    private OutletCombobox cbOutlet;
    private SiiopaCombobox cbBankName;
    private SiiopaTextField tfCurrentBalance;
    private List<BalanceUpdateTransaction> transactions;
    private BankAccountTransactionReportGrid reportGrid;
    private VerticalLayout gridLayout;
    private CloudButton btnClear;

    public BankAccountTransactionReportView() {
        super(UserPermission.BANK_ACCOUNT_TRANSACTION_REPORT);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        topLayout.setSizeUndefined();
        this.cbBankName = new SiiopaCombobox();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                BankAccountTransactionReportView.this.cbBankName.removeAllItems();
                BankAccountTransactionReportView.this.cbBankName.addItems(BankAccountDAO.getInstance().findAllActive(BankAccountTransactionReportView.this.cbOutlet.getSelectedOrDefaultOutlet().getId()));
                BankAccountTransactionReportView.this.cbBankName.selectFirstComponent();
            }
        };
        this.cbBankName.addItems(BankAccountDAO.getInstance().findAllActive(this.cbOutlet.getSelectedOrDefaultOutlet().getId()));
        this.cbBankName.selectFirstComponent();
        this.cbBankName.setNullSelectionAllowed(false);
        this.cbBankName.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.tfCurrentBalance = new SiiopaTextField();
        this.tfCurrentBalance.setWidth("180px");
        this.tfCurrentBalance.setFieldRightAligment();
        this.tfCurrentBalance.setEnabled(false);
        this.tfCurrentBalance.addStyleName("remove-opacity");
        this.tfCurrentBalance.addStyleName("bold-style");
        VerticalLayout formLayout = new VerticalLayout();
        formLayout.addStyleName("bold");
        Label lblEndBalance = new Label("Current balance");
        lblEndBalance.addStyleName("bold");
        HorizontalLayout row1 = new HorizontalLayout();
        row1.setSpacing(true);
        row1.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        row1.addComponents(new Component[]{lblEndBalance, this.tfCurrentBalance});
        formLayout.addComponents(new Component[]{row1});
        formLayout.setComponentAlignment((Component)row1, Alignment.MIDDLE_RIGHT);
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        this.btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("CreditCardReportView.5"));
        this.btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Bank", (Component)this.cbBankName));
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)this.btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 3.0f);
        HorizontalLayout footerLayout = new HorizontalLayout();
        footerLayout.setWidth("100%");
        Label space = new Label();
        space.setWidth("100%");
        formLayout.setWidthUndefined();
        footerLayout.addComponents(new Component[]{this.btnExportPdf, space, formLayout});
        footerLayout.setComponentAlignment((Component)formLayout, Alignment.MIDDLE_RIGHT);
        this.gridLayout.addComponent((Component)footerLayout);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
    }

    protected void doClear() {
        this.grid.removeAll();
        this.gridLayout.setVisible(false);
        this.clearDateFields();
        this.cbOutlet.selectFirstComponent();
        this.cbBankName.selectFirstComponent();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Outlet outlet = this.cbOutlet.getSelectedOrDefaultOutlet();
        BankAccount bankAccount = (BankAccount)this.cbBankName.getValue();
        if (bankAccount == null) {
            this.transactions = Collections.emptyList();
            return;
        }
        PosLog.info(this.getClass(), (String)("Start time: " + startTime + ", End time: " + endTime));
        this.transactions = BalanceUpdateTransactionDAO.getInstance().findBankAccountTransaction(outlet, startTime, endTime, bankAccount.getId());
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        StreamResource streamResource = null;
        try {
            this.validateDate();
            Date startTime = this.getFromDate();
            Date endTime = this.getToDate();
            Outlet outlet = null;
            Object value = this.cbOutlet.getValue();
            if (value instanceof Outlet) {
                outlet = (Outlet)value;
            }
            JasperPrint jasperPrint = CommonCloudReportService.getBankAccountTransactionReportPrint(startTime, endTime, outlet, this.transactions, this.cbBankName.getValue());
            streamResource = CommonCloudReportService.getReportStream(VIEW_NAME, jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (PosException e0) {
            CloudNotification.showErrorMessageDialog(e0.getMessage());
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.reportGrid = new BankAccountTransactionReportGrid();
        return this.reportGrid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            this.reportGrid.clearFooterCell();
            if (this.transactions == null || this.transactions.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage("No data found!");
                return;
            }
            this.reportGrid.setItems((Collection<BalanceUpdateTransaction>)this.transactions);
            this.gridLayout.setVisible(true);
            this.updateFooter(this.cbBankName.getValue());
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }

    private void updateFooter(Object bank) {
        if (bank instanceof BankAccount) {
            BankAccount bankAccount = (BankAccount)bank;
            bankAccount = (BankAccount)DataProvider.get().getObjectOf(BankAccount.class, (Serializable)((Object)bankAccount.getId()));
            double bankAccountBalance = bankAccount.getBalance() == 0.0 ? 0.0 : bankAccount.getBalance();
            this.tfCurrentBalance.setValue(NumberUtil.formatAmount((Double)bankAccountBalance));
        }
    }

    public void doSelectBankAccountAndDisable(BankAccount bankAccount) {
        if (this.cbBankName != null) {
            this.cbBankName.select(bankAccount);
        }
        if (this.cbOutlet != null) {
            this.cbOutlet.setEnabled(false);
        }
        if (this.cbBankName != null) {
            this.cbBankName.setEnabled(false);
        }
        if (this.btnClear != null) {
            this.btnClear.setVisible(false);
        }
    }
}

