/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.curd.grid.PurchasePaymentReportGrid;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PurchasePaymentReportView
extends ReportView {
    public static final String VIEW_NAME = "Purchase Payment Report";
    private OutletCombobox cbOutlet;
    private List<PosTransaction> transactions;
    private VerticalLayout gridLayout;
    private PurchasePaymentReportGrid purchasePaymentReportGrid;

    public PurchasePaymentReportView() {
        super(UserPermission.PURCHASE_PAYMENT_REPORT);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                PurchasePaymentReportView.this.updateView();
            }
        };
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET") + " :", (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(false);
        buttonLayout.setSpacing(true);
        this.gridLayout.addComponent((Component)buttonLayout);
        this.gridLayout.setExpandRatio((Component)buttonLayout, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource(this.transactions);
    }

    protected void doClear() {
        this.grid.removeAll();
        this.cbOutlet.selectFirstComponent();
        this.gridLayout.setVisible(false);
        this.clearDateFields();
    }

    private void doSearch() throws Exception {
        Date from = this.getFromDate();
        Date to = this.getToDate();
        if (from != null && to != null && from.after(to)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        this.transactions = PosTransactionDAO.getInstance().findPurchaseTransaction(outlet, from, to);
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.purchasePaymentReportGrid = new PurchasePaymentReportGrid();
        return this.purchasePaymentReportGrid;
    }

    public StreamResource getStreamResource(List<PosTransaction> transactions) {
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        StreamResource streamResource = null;
        return streamResource;
    }

    @Override
    public void updateView() {
        this.purchasePaymentReportGrid.removeAll();
        try {
            this.doSearch();
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
            this.gridLayout.setVisible(false);
            return;
        }
        if (this.transactions == null || this.transactions.isEmpty()) {
            this.gridLayout.setVisible(false);
            CloudNotification.showMessage(ConsoleMessages.getString("TransactionReportView.2"));
            return;
        }
        Double sumOfTotal = 0.0;
        for (PosTransaction transaction : this.transactions) {
            String total;
            Double amount;
            String poNo = StringUtils.isBlank((String)transaction.getEntityNo()) ? "" : transaction.getEntityNo();
            String time = DateUtil.formatDateWithTime((Date)DateUtil.convertServerTimeToBrowserTime((Date)transaction.getTransactionTime()));
            String vendorName = transaction.getVendorDisplay();
            String paymentTypeDisplay = "";
            PaymentType paymentType = transaction.getPaymentType();
            if (paymentType != null) {
                String customPaymentName;
                paymentTypeDisplay = paymentType.equals((Object)PaymentType.CUSTOM_PAYMENT) ? (StringUtils.isEmpty((String)(customPaymentName = transaction.getCustomPaymentName())) ? null : customPaymentName) : paymentType.getDisplayString();
            }
            String transactionType = transaction.getTransactionType();
            if (Arrays.asList(TransactionType.CREDIT.name(), TransactionType.IN.name()).contains(transactionType)) {
                amount = transaction.getAmount() * -1.0;
                total = NumberUtil.getCurrencyFormatWithoutCurrencySymbol((Object)amount);
                sumOfTotal = sumOfTotal + amount;
            } else {
                amount = transaction.getAmount();
                total = NumberUtil.getCurrencyFormatWithoutCurrencySymbol((Object)amount);
                sumOfTotal = sumOfTotal + amount;
            }
            this.purchasePaymentReportGrid.addRow(new Object[]{poNo, time, vendorName, paymentTypeDisplay, total});
        }
        this.purchasePaymentReportGrid.updateTotal(sumOfTotal);
        this.gridLayout.setVisible(true);
    }
}

